/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.login;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.login.LoginPacketTypes;
import net.minecraft.network.protocol.login.PacketLoginInListener;
import net.minecraft.network.protocol.login.custom.CustomQueryAnswerPayload;
import net.minecraft.network.protocol.login.custom.DiscardedQueryAnswerPayload;
import org.jspecify.annotations.Nullable;

public record ServerboundCustomQueryAnswerPacket(int transactionId, @Nullable CustomQueryAnswerPayload payload) implements Packet<PacketLoginInListener>
{
    public static final StreamCodec<PacketDataSerializer, ServerboundCustomQueryAnswerPacket> STREAM_CODEC = Packet.codec(ServerboundCustomQueryAnswerPacket::write, ServerboundCustomQueryAnswerPacket::read);
    private static final int MAX_PAYLOAD_SIZE = 0x100000;

    private static ServerboundCustomQueryAnswerPacket read(PacketDataSerializer var0) {
        int var1 = var0.readVarInt();
        return new ServerboundCustomQueryAnswerPacket(var1, ServerboundCustomQueryAnswerPacket.readPayload(var1, var0));
    }

    private static CustomQueryAnswerPayload readPayload(int var0, PacketDataSerializer var1) {
        return ServerboundCustomQueryAnswerPacket.readUnknownPayload(var1);
    }

    private static CustomQueryAnswerPayload readUnknownPayload(PacketDataSerializer var0) {
        int var1 = var0.readableBytes();
        if (var1 < 0 || var1 > 0x100000) {
            throw new IllegalArgumentException("Payload may not be larger than 1048576 bytes");
        }
        var0.skipBytes(var1);
        return DiscardedQueryAnswerPayload.INSTANCE;
    }

    private void write(PacketDataSerializer var02) {
        var02.writeVarInt(this.transactionId);
        var02.writeNullable(this.payload, (var0, var1) -> var1.write((PacketDataSerializer)((Object)var0)));
    }

    @Override
    public PacketType<ServerboundCustomQueryAnswerPacket> type() {
        return LoginPacketTypes.SERVERBOUND_CUSTOM_QUERY_ANSWER;
    }

    @Override
    public void handle(PacketLoginInListener var0) {
        var0.handleCustomQueryPacket(this);
    }
}

