/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.DynamicOpsWrapper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;

public class RegistryOps<T>
extends DynamicOpsWrapper<T> {
    private final c lookupProvider;

    public static <T> RegistryOps<T> create(DynamicOps<T> var0, HolderLookup.a var1) {
        return RegistryOps.create(var0, new a(var1));
    }

    public static <T> RegistryOps<T> create(DynamicOps<T> var0, c var1) {
        return new RegistryOps<T>(var0, var1);
    }

    public static <T> Dynamic<T> injectRegistryContext(Dynamic<T> var0, HolderLookup.a var1) {
        return new Dynamic(var1.createSerializationContext(var0.getOps()), var0.getValue());
    }

    private RegistryOps(DynamicOps<T> var0, c var1) {
        super(var0);
        this.lookupProvider = var1;
    }

    public <U> RegistryOps<U> withParent(DynamicOps<U> var0) {
        if (var0 == this.delegate) {
            return this;
        }
        return new RegistryOps<U>(var0, this.lookupProvider);
    }

    public <E> Optional<HolderOwner<E>> owner(ResourceKey<? extends IRegistry<? extends E>> var0) {
        return this.lookupProvider.lookup(var0).map(b::owner);
    }

    public <E> Optional<HolderGetter<E>> getter(ResourceKey<? extends IRegistry<? extends E>> var0) {
        return this.lookupProvider.lookup(var0).map(b::getter);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        RegistryOps var1 = (RegistryOps)var0;
        return this.delegate.equals((Object)var1.delegate) && this.lookupProvider.equals(var1.lookupProvider);
    }

    public int hashCode() {
        return this.delegate.hashCode() * 31 + this.lookupProvider.hashCode();
    }

    public static <E, O> RecordCodecBuilder<O, HolderGetter<E>> retrieveGetter(ResourceKey<? extends IRegistry<? extends E>> var02) {
        return ExtraCodecs.retrieveContext(var1 -> {
            if (var1 instanceof RegistryOps) {
                RegistryOps var2 = (RegistryOps)var1;
                return var2.lookupProvider.lookup(var02).map(var0 -> DataResult.success(var0.getter(), (Lifecycle)var0.elementsLifecycle())).orElseGet(() -> DataResult.error(() -> "Unknown registry: " + String.valueOf(var02)));
            }
            return DataResult.error(() -> "Not a registry ops");
        }).forGetter(var0 -> null);
    }

    public static <E, O> RecordCodecBuilder<O, Holder.c<E>> retrieveElement(ResourceKey<E> var02) {
        ResourceKey var1 = ResourceKey.createRegistryKey(var02.registry());
        return ExtraCodecs.retrieveContext(var2 -> {
            if (var2 instanceof RegistryOps) {
                RegistryOps var3 = (RegistryOps)var2;
                return var3.lookupProvider.lookup(var1).flatMap(var1 -> var1.getter().get(var02)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Can't find value: " + String.valueOf(var02)));
            }
            return DataResult.error(() -> "Not a registry ops");
        }).forGetter(var0 -> null);
    }

    static final class a
    implements c {
        private final HolderLookup.a lookupProvider;
        private final Map<ResourceKey<? extends IRegistry<?>>, Optional<? extends b<?>>> lookups = new ConcurrentHashMap();

        public a(HolderLookup.a var0) {
            this.lookupProvider = var0;
        }

        public <E> Optional<b<E>> lookup(ResourceKey<? extends IRegistry<? extends E>> var0) {
            return this.lookups.computeIfAbsent(var0, this::createLookup);
        }

        private Optional<b<Object>> createLookup(ResourceKey<? extends IRegistry<?>> var0) {
            return this.lookupProvider.lookup(var0).map(b::fromRegistryLookup);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (!(var0 instanceof a)) return false;
            a var1 = (a)var0;
            if (!this.lookupProvider.equals(var1.lookupProvider)) return false;
            return true;
        }

        public int hashCode() {
            return this.lookupProvider.hashCode();
        }
    }

    public static interface c {
        public <T> Optional<b<T>> lookup(ResourceKey<? extends IRegistry<? extends T>> var1);
    }

    public record b<T>(HolderOwner<T> owner, HolderGetter<T> getter, Lifecycle elementsLifecycle) {
        public static <T> b<T> fromRegistryLookup(HolderLookup.b<T> var0) {
            return new b<T>(var0, var0, var0.registryLifecycle());
        }
    }
}

