/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.CustomFunctionManager;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.util.Unit;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.CraftingManager;
import org.slf4j.Logger;

public class DataPackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final CompletableFuture<Unit> DATA_RELOAD_INITIAL_TASK = CompletableFuture.completedFuture(Unit.INSTANCE);
    private final ReloadableServerRegistries.a fullRegistryHolder;
    public CommandDispatcher commands;
    private final CraftingManager recipes;
    private final AdvancementDataWorld advancements;
    private final CustomFunctionManager functionLibrary;
    private final List<IRegistry.a<?>> postponedTags;

    private DataPackResources(LayeredRegistryAccess<RegistryLayer> var0, HolderLookup.a var1, FeatureFlagSet var2, CommandDispatcher.ServerType var3, List<IRegistry.a<?>> var4, PermissionSet var5) {
        this.fullRegistryHolder = new ReloadableServerRegistries.a(var0.compositeAccess());
        this.postponedTags = var4;
        this.recipes = new CraftingManager(var1);
        this.commands = new CommandDispatcher(var3, CommandBuildContext.simple(var1, var2));
        this.advancements = new AdvancementDataWorld(var1);
        this.functionLibrary = new CustomFunctionManager(var5, this.commands.getDispatcher());
    }

    public CustomFunctionManager getFunctionLibrary() {
        return this.functionLibrary;
    }

    public ReloadableServerRegistries.a fullRegistries() {
        return this.fullRegistryHolder;
    }

    public CraftingManager getRecipeManager() {
        return this.recipes;
    }

    public CommandDispatcher getCommands() {
        return this.commands;
    }

    public AdvancementDataWorld getAdvancements() {
        return this.advancements;
    }

    public List<IReloadListener> listeners() {
        return List.of(this.recipes, this.functionLibrary, this.advancements);
    }

    public static CompletableFuture<DataPackResources> loadResources(IResourceManager var0, LayeredRegistryAccess<RegistryLayer> var1, List<IRegistry.a<?>> var2, FeatureFlagSet var3, CommandDispatcher.ServerType var4, PermissionSet var5, Executor var6, Executor var72) {
        return ReloadableServerRegistries.reload(var1, var2, var0, var6).thenCompose(var7 -> {
            DataPackResources var8 = new DataPackResources(var7.layers(), var7.lookupWithUpdatedTags(), var3, var4, var2, var5);
            return Reloadable.create(var0, var8.listeners(), var6, var72, DATA_RELOAD_INITIAL_TASK, LOGGER.isDebugEnabled()).done().thenApply(var1 -> var8);
        });
    }

    public void updateStaticRegistryTags() {
        this.postponedTags.forEach(IRegistry.a::apply);
    }
}

