/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.tags.TagDataPack;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.slf4j.Logger;

public class ReloadableServerRegistries {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final RegistrationInfo DEFAULT_REGISTRATION_INFO = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());

    public static CompletableFuture<b> reload(LayeredRegistryAccess<RegistryLayer> var0, List<IRegistry.a<?>> var1, IResourceManager var22, Executor var32) {
        List<HolderLookup.b<?>> var4 = TagDataPack.buildUpdatedLookups(var0.getAccessForLoading(RegistryLayer.RELOADABLE), var1);
        HolderLookup.a var5 = HolderLookup.a.create(var4.stream());
        RegistryOps var6 = var5.createSerializationContext(JsonOps.INSTANCE);
        List<CompletableFuture> var7 = LootDataType.values().map(var3 -> ReloadableServerRegistries.scheduleRegistryLoad(var3, var6, var22, var32)).toList();
        CompletableFuture var8 = SystemUtils.sequence(var7);
        return var8.thenApplyAsync(var2 -> ReloadableServerRegistries.createAndValidateFullContext(var0, var5, var2), var32);
    }

    private static <T> CompletableFuture<IRegistryWritable<?>> scheduleRegistryLoad(LootDataType<T> var0, RegistryOps<JsonElement> var1, IResourceManager var2, Executor var3) {
        return CompletableFuture.supplyAsync(() -> {
            RegistryMaterials var32 = new RegistryMaterials(var0.registryKey(), Lifecycle.experimental());
            HashMap<MinecraftKey, Object> var4 = new HashMap<MinecraftKey, Object>();
            ResourceDataJson.scanDirectory(var2, var0.registryKey(), (DynamicOps<JsonElement>)var1, var0.codec(), var4);
            var4.forEach((var2, var3) -> var32.register(ResourceKey.create(var0.registryKey(), var2), var3, DEFAULT_REGISTRATION_INFO));
            TagDataPack.loadTagsForRegistry(var2, var32);
            return var32;
        }, var3);
    }

    private static b createAndValidateFullContext(LayeredRegistryAccess<RegistryLayer> var0, HolderLookup.a var1, List<IRegistryWritable<?>> var2) {
        LayeredRegistryAccess<RegistryLayer> var3 = ReloadableServerRegistries.createUpdatedRegistries(var0, var2);
        HolderLookup.a var4 = ReloadableServerRegistries.concatenateLookups(var1, var3.getLayer(RegistryLayer.RELOADABLE));
        ReloadableServerRegistries.validateLootRegistries(var4);
        return new b(var3, var4);
    }

    private static HolderLookup.a concatenateLookups(HolderLookup.a var0, HolderLookup.a var1) {
        return HolderLookup.a.create(Stream.concat(var0.listRegistries(), var1.listRegistries()));
    }

    private static void validateLootRegistries(HolderLookup.a var02) {
        ProblemReporter.a var12 = new ProblemReporter.a();
        LootCollector var22 = new LootCollector(var12, LootContextParameterSets.ALL_PARAMS, var02);
        LootDataType.values().forEach(var2 -> ReloadableServerRegistries.validateRegistry(var22, var2, var02));
        var12.forEach((var0, var1) -> LOGGER.warn("Found loot table element validation problem in {}: {}", var0, (Object)var1.description()));
    }

    private static LayeredRegistryAccess<RegistryLayer> createUpdatedRegistries(LayeredRegistryAccess<RegistryLayer> var0, List<IRegistryWritable<?>> var1) {
        return var0.replaceFrom(RegistryLayer.RELOADABLE, new IRegistryCustom.c(var1).freeze());
    }

    private static <T> void validateRegistry(LootCollector var0, LootDataType<T> var1, HolderLookup.a var22) {
        HolderGetter var3 = var22.lookupOrThrow(var1.registryKey());
        var3.listElements().forEach(var2 -> var1.runValidation(var0, var2.key(), var2.value()));
    }

    public record b(LayeredRegistryAccess<RegistryLayer> layers, HolderLookup.a lookupWithUpdatedTags) {
    }

    public static class a {
        private final HolderLookup.a registries;

        public a(HolderLookup.a var0) {
            this.registries = var0;
        }

        public HolderLookup.a lookup() {
            return this.registries;
        }

        public LootTable getLootTable(ResourceKey<LootTable> var0) {
            return this.registries.lookup(Registries.LOOT_TABLE).flatMap(var1 -> var1.get(var0)).map(Holder::value).orElse(LootTable.EMPTY);
        }
    }
}

