/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.bossevents;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.BossBattle;

public class BossBattleCustom
extends BossBattleServer {
    private static final int DEFAULT_MAX = 100;
    private final MinecraftKey id;
    private final Set<UUID> players = Sets.newHashSet();
    private int value;
    private int max = 100;

    public BossBattleCustom(MinecraftKey var0, IChatBaseComponent var1) {
        super(var1, BossBattle.BarColor.WHITE, BossBattle.BarStyle.PROGRESS);
        this.id = var0;
        this.setProgress(0.0f);
    }

    public MinecraftKey getTextId() {
        return this.id;
    }

    @Override
    public void addPlayer(EntityPlayer var0) {
        super.addPlayer(var0);
        this.players.add(var0.getUUID());
    }

    public void addOfflinePlayer(UUID var0) {
        this.players.add(var0);
    }

    @Override
    public void removePlayer(EntityPlayer var0) {
        super.removePlayer(var0);
        this.players.remove(var0.getUUID());
    }

    @Override
    public void removeAllPlayers() {
        super.removeAllPlayers();
        this.players.clear();
    }

    public int getValue() {
        return this.value;
    }

    public int getMax() {
        return this.max;
    }

    public void setValue(int var0) {
        this.value = var0;
        this.setProgress(MathHelper.clamp((float)var0 / (float)this.max, 0.0f, 1.0f));
    }

    public void setMax(int var0) {
        this.max = var0;
        this.setProgress(MathHelper.clamp((float)this.value / (float)var0, 0.0f, 1.0f));
    }

    public final IChatBaseComponent getDisplayName() {
        return ChatComponentUtils.wrapInSquareBrackets(this.getName()).withStyle(var0 -> var0.withColor(this.getColor().getFormatting()).withHoverEvent(new ChatHoverable.e(IChatBaseComponent.literal(this.getTextId().toString()))).withInsertion(this.getTextId().toString()));
    }

    public boolean setPlayers(Collection<EntityPlayer> var0) {
        boolean var5;
        HashSet var1 = Sets.newHashSet();
        HashSet var2 = Sets.newHashSet();
        for (UUID uUID : this.players) {
            var5 = false;
            for (EntityPlayer entityPlayer : var0) {
                if (!entityPlayer.getUUID().equals(uUID)) continue;
                var5 = true;
                break;
            }
            if (var5) continue;
            var1.add(uUID);
        }
        for (EntityPlayer entityPlayer : var0) {
            var5 = false;
            for (UUID uUID : this.players) {
                if (!entityPlayer.getUUID().equals(uUID)) continue;
                var5 = true;
                break;
            }
            if (var5) continue;
            var2.add(entityPlayer);
        }
        for (UUID uUID : var1) {
            for (EntityPlayer var6 : this.getPlayers()) {
                if (!var6.getUUID().equals(uUID)) continue;
                this.removePlayer(var6);
                break;
            }
            this.players.remove(uUID);
        }
        for (EntityPlayer entityPlayer : var2) {
            this.addPlayer(entityPlayer);
        }
        return !var1.isEmpty() || !var2.isEmpty();
    }

    public static BossBattleCustom load(MinecraftKey var0, a var1) {
        BossBattleCustom var2 = new BossBattleCustom(var0, var1.name);
        var2.setVisible(var1.visible);
        var2.setValue(var1.value);
        var2.setMax(var1.max);
        var2.setColor(var1.color);
        var2.setOverlay(var1.overlay);
        var2.setDarkenScreen(var1.darkenScreen);
        var2.setPlayBossMusic(var1.playBossMusic);
        var2.setCreateWorldFog(var1.createWorldFog);
        var1.players.forEach(var2::addOfflinePlayer);
        return var2;
    }

    public a pack() {
        return new a(this.getName(), this.isVisible(), this.getValue(), this.getMax(), this.getColor(), this.getOverlay(), this.shouldDarkenScreen(), this.shouldPlayBossMusic(), this.shouldCreateWorldFog(), Set.copyOf(this.players));
    }

    public void onPlayerConnect(EntityPlayer var0) {
        if (this.players.contains(var0.getUUID())) {
            this.addPlayer(var0);
        }
    }

    public void onPlayerDisconnect(EntityPlayer var0) {
        super.removePlayer(var0);
    }

    public static final class a
    extends Record {
        final IChatBaseComponent name;
        final boolean visible;
        final int value;
        final int max;
        final BossBattle.BarColor color;
        final BossBattle.BarStyle overlay;
        final boolean darkenScreen;
        final boolean playBossMusic;
        final boolean createWorldFog;
        final Set<UUID> players;
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ComponentSerialization.CODEC.fieldOf("Name").forGetter(a::name), (App)Codec.BOOL.optionalFieldOf("Visible", (Object)false).forGetter(a::visible), (App)Codec.INT.optionalFieldOf("Value", (Object)0).forGetter(a::value), (App)Codec.INT.optionalFieldOf("Max", (Object)100).forGetter(a::max), (App)BossBattle.BarColor.CODEC.optionalFieldOf("Color", (Object)BossBattle.BarColor.WHITE).forGetter(a::color), (App)BossBattle.BarStyle.CODEC.optionalFieldOf("Overlay", (Object)BossBattle.BarStyle.PROGRESS).forGetter(a::overlay), (App)Codec.BOOL.optionalFieldOf("DarkenScreen", (Object)false).forGetter(a::darkenScreen), (App)Codec.BOOL.optionalFieldOf("PlayBossMusic", (Object)false).forGetter(a::playBossMusic), (App)Codec.BOOL.optionalFieldOf("CreateWorldFog", (Object)false).forGetter(a::createWorldFog), (App)UUIDUtil.CODEC_SET.optionalFieldOf("Players", Set.of()).forGetter(a::players)).apply((Applicative)var0, a::new));

        public a(IChatBaseComponent var0, boolean var1, int var2, int var3, BossBattle.BarColor var4, BossBattle.BarStyle var5, boolean var6, boolean var7, boolean var8, Set<UUID> var9) {
            this.name = var0;
            this.visible = var1;
            this.value = var2;
            this.max = var3;
            this.color = var4;
            this.overlay = var5;
            this.darkenScreen = var6;
            this.playBossMusic = var7;
            this.createWorldFog = var8;
            this.players = var9;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "name;visible;value;max;color;overlay;darkenScreen;playBossMusic;createWorldFog;players", "name", "visible", "value", "max", "color", "overlay", "darkenScreen", "playBossMusic", "createWorldFog", "players"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "name;visible;value;max;color;overlay;darkenScreen;playBossMusic;createWorldFog;players", "name", "visible", "value", "max", "color", "overlay", "darkenScreen", "playBossMusic", "createWorldFog", "players"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "name;visible;value;max;color;overlay;darkenScreen;playBossMusic;createWorldFog;players", "name", "visible", "value", "max", "color", "overlay", "darkenScreen", "playBossMusic", "createWorldFog", "players"}, this, var0);
        }

        public IChatBaseComponent name() {
            return this.name;
        }

        public boolean visible() {
            return this.visible;
        }

        public int value() {
            return this.value;
        }

        public int max() {
            return this.max;
        }

        public BossBattle.BarColor color() {
            return this.color;
        }

        public BossBattle.BarStyle overlay() {
            return this.overlay;
        }

        public boolean darkenScreen() {
            return this.darkenScreen;
        }

        public boolean playBossMusic() {
            return this.playBossMusic;
        }

        public boolean createWorldFog() {
            return this.createWorldFog;
        }

        public Set<UUID> players() {
            return this.players;
        }
    }
}

