/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import org.jspecify.annotations.Nullable;

public class CommandEffect {
    private static final SimpleCommandExceptionType ERROR_GIVE_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.effect.give.failed"));
    private static final SimpleCommandExceptionType ERROR_CLEAR_EVERYTHING_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.effect.clear.everything.failed"));
    private static final SimpleCommandExceptionType ERROR_CLEAR_SPECIFIC_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.effect.clear.specific.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("effect").requires(net.minecraft.commands.CommandDispatcher.hasPermission(net.minecraft.commands.CommandDispatcher.LEVEL_GAMEMASTERS))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("clear").executes(var0 -> CommandEffect.clearEffects((CommandListenerWrapper)var0.getSource(), (Collection<? extends Entity>)ImmutableList.of((Object)((CommandListenerWrapper)var0.getSource()).getEntityOrException())))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).executes(var0 -> CommandEffect.clearEffects((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets")))).then(net.minecraft.commands.CommandDispatcher.argument("effect", ResourceArgument.resource(var1, Registries.MOB_EFFECT)).executes(var0 -> CommandEffect.clearEffect((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandListenerWrapper>)var0, "effect"))))))).then(net.minecraft.commands.CommandDispatcher.literal("give").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("effect", ResourceArgument.resource(var1, Registries.MOB_EFFECT)).executes(var0 -> CommandEffect.giveEffect((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandListenerWrapper>)var0, "effect"), null, 0, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("seconds", IntegerArgumentType.integer((int)1, (int)1000000)).executes(var0 -> CommandEffect.giveEffect((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandListenerWrapper>)var0, "effect"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"seconds"), 0, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("amplifier", IntegerArgumentType.integer((int)0, (int)255)).executes(var0 -> CommandEffect.giveEffect((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandListenerWrapper>)var0, "effect"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"seconds"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"amplifier"), true))).then(net.minecraft.commands.CommandDispatcher.argument("hideParticles", BoolArgumentType.bool()).executes(var0 -> CommandEffect.giveEffect((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandListenerWrapper>)var0, "effect"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"seconds"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"amplifier"), !BoolArgumentType.getBool((CommandContext)var0, (String)"hideParticles"))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("infinite").executes(var0 -> CommandEffect.giveEffect((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandListenerWrapper>)var0, "effect"), -1, 0, true))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("amplifier", IntegerArgumentType.integer((int)0, (int)255)).executes(var0 -> CommandEffect.giveEffect((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandListenerWrapper>)var0, "effect"), -1, IntegerArgumentType.getInteger((CommandContext)var0, (String)"amplifier"), true))).then(net.minecraft.commands.CommandDispatcher.argument("hideParticles", BoolArgumentType.bool()).executes(var0 -> CommandEffect.giveEffect((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandListenerWrapper>)var0, "effect"), -1, IntegerArgumentType.getInteger((CommandContext)var0, (String)"amplifier"), !BoolArgumentType.getBool((CommandContext)var0, (String)"hideParticles"))))))))));
    }

    private static int giveEffect(CommandListenerWrapper var0, Collection<? extends Entity> var1, Holder<MobEffectList> var2, @Nullable Integer var3, int var4, boolean var5) throws CommandSyntaxException {
        MobEffectList var6 = var2.value();
        int var7 = 0;
        int var8 = var3 != null ? (var6.isInstantenous() ? var3 : (var3 == -1 ? -1 : var3 * 20)) : (var6.isInstantenous() ? 1 : 600);
        for (Entity entity : var1) {
            MobEffect var11;
            if (!(entity instanceof EntityLiving) || !((EntityLiving)entity).addEffect(var11 = new MobEffect(var2, var8, var4, false, var5), var0.getEntity())) continue;
            ++var7;
        }
        if (var7 == 0) {
            throw ERROR_GIVE_FAILED.create();
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.effect.give.success.single", var6.getDisplayName(), ((Entity)var1.iterator().next()).getDisplayName(), var8 / 20), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.effect.give.success.multiple", var6.getDisplayName(), var1.size(), var8 / 20), true);
        }
        return var7;
    }

    private static int clearEffects(CommandListenerWrapper var0, Collection<? extends Entity> var1) throws CommandSyntaxException {
        int var2 = 0;
        for (Entity entity : var1) {
            if (!(entity instanceof EntityLiving) || !((EntityLiving)entity).removeAllEffects()) continue;
            ++var2;
        }
        if (var2 == 0) {
            throw ERROR_CLEAR_EVERYTHING_FAILED.create();
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.effect.clear.everything.success.single", ((Entity)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.effect.clear.everything.success.multiple", var1.size()), true);
        }
        return var2;
    }

    private static int clearEffect(CommandListenerWrapper var0, Collection<? extends Entity> var1, Holder<MobEffectList> var2) throws CommandSyntaxException {
        MobEffectList var3 = var2.value();
        int var4 = 0;
        for (Entity entity : var1) {
            if (!(entity instanceof EntityLiving) || !((EntityLiving)entity).removeEffect(var2)) continue;
            ++var4;
        }
        if (var4 == 0) {
            throw ERROR_CLEAR_SPECIFIC_FAILED.create();
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.effect.clear.specific.success.single", var3.getDisplayName(), ((Entity)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.effect.clear.specific.success.multiple", var3.getDisplayName(), var1.size()), true);
        }
        return var4;
    }
}

