/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class CommandPlaySound {
    private static final SimpleCommandExceptionType ERROR_TOO_FAR = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.playsound.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        RequiredArgumentBuilder var1 = (RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("sound", ArgumentMinecraftKeyRegistered.id()).suggests(CompletionProviders.cast(CompletionProviders.AVAILABLE_SOUNDS)).executes(var0 -> CommandPlaySound.playSound((CommandListenerWrapper)var0.getSource(), CommandPlaySound.getCallingPlayerAsCollection(((CommandListenerWrapper)var0.getSource()).getPlayer()), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "sound"), SoundCategory.MASTER, ((CommandListenerWrapper)var0.getSource()).getPosition(), 1.0f, 1.0f, 0.0f));
        for (SoundCategory var5 : SoundCategory.values()) {
            var1.then(CommandPlaySound.source(var5));
        }
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("playsound").requires(net.minecraft.commands.CommandDispatcher.hasPermission(net.minecraft.commands.CommandDispatcher.LEVEL_GAMEMASTERS))).then((ArgumentBuilder)var1));
    }

    private static LiteralArgumentBuilder<CommandListenerWrapper> source(SoundCategory var0) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal(var0.getName()).executes(var1 -> CommandPlaySound.playSound((CommandListenerWrapper)var1.getSource(), CommandPlaySound.getCallingPlayerAsCollection(((CommandListenerWrapper)var1.getSource()).getPlayer()), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var1, "sound"), var0, ((CommandListenerWrapper)var1.getSource()).getPosition(), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.players()).executes(var1 -> CommandPlaySound.playSound((CommandListenerWrapper)var1.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var1, "targets"), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var1, "sound"), var0, ((CommandListenerWrapper)var1.getSource()).getPosition(), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentVec3.vec3()).executes(var1 -> CommandPlaySound.playSound((CommandListenerWrapper)var1.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var1, "targets"), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var1, "sound"), var0, ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var1, "pos"), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("volume", FloatArgumentType.floatArg((float)0.0f)).executes(var1 -> CommandPlaySound.playSound((CommandListenerWrapper)var1.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var1, "targets"), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var1, "sound"), var0, ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var1, "pos"), ((Float)var1.getArgument("volume", Float.class)).floatValue(), 1.0f, 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("pitch", FloatArgumentType.floatArg((float)0.0f, (float)2.0f)).executes(var1 -> CommandPlaySound.playSound((CommandListenerWrapper)var1.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var1, "targets"), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var1, "sound"), var0, ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var1, "pos"), ((Float)var1.getArgument("volume", Float.class)).floatValue(), ((Float)var1.getArgument("pitch", Float.class)).floatValue(), 0.0f))).then(net.minecraft.commands.CommandDispatcher.argument("minVolume", FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(var1 -> CommandPlaySound.playSound((CommandListenerWrapper)var1.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var1, "targets"), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var1, "sound"), var0, ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var1, "pos"), ((Float)var1.getArgument("volume", Float.class)).floatValue(), ((Float)var1.getArgument("pitch", Float.class)).floatValue(), ((Float)var1.getArgument("minVolume", Float.class)).floatValue())))))));
    }

    private static Collection<EntityPlayer> getCallingPlayerAsCollection(@Nullable EntityPlayer var0) {
        return var0 != null ? List.of(var0) : List.of();
    }

    private static int playSound(CommandListenerWrapper var0, Collection<EntityPlayer> var1, MinecraftKey var2, SoundCategory var3, Vec3D var4, float var5, float var6, float var7) throws CommandSyntaxException {
        Holder<SoundEffect> var8 = Holder.direct(SoundEffect.createVariableRangeEvent(var2));
        double var9 = MathHelper.square(var8.value().getRange(var5));
        WorldServer var11 = var0.getLevel();
        long var12 = var11.getRandom().nextLong();
        ArrayList<EntityPlayer> var14 = new ArrayList<EntityPlayer>();
        for (EntityPlayer var16 : var1) {
            if (var16.level() != var11) continue;
            double var17 = var4.x - var16.getX();
            double var19 = var4.y - var16.getY();
            double var21 = var4.z - var16.getZ();
            double var23 = var17 * var17 + var19 * var19 + var21 * var21;
            Vec3D var25 = var4;
            float var26 = var5;
            if (var23 > var9) {
                if (var7 <= 0.0f) continue;
                double var27 = Math.sqrt(var23);
                var25 = new Vec3D(var16.getX() + var17 / var27 * 2.0, var16.getY() + var19 / var27 * 2.0, var16.getZ() + var21 / var27 * 2.0);
                var26 = var7;
            }
            var16.connection.send(new PacketPlayOutNamedSoundEffect(var8, var3, var25.x(), var25.y(), var25.z(), var26, var6, var12));
            var14.add(var16);
        }
        int var15 = var14.size();
        if (var15 == 0) {
            throw ERROR_TOO_FAR.create();
        }
        if (var15 == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.playsound.success.single", IChatBaseComponent.translationArg(var2), ((EntityPlayer)var14.getFirst()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.playsound.success.multiple", IChatBaseComponent.translationArg(var2), var15), true);
        }
        return var15;
    }
}

