/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentChatFormat;
import net.minecraft.commands.arguments.ArgumentScoreboardTeam;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;

public class CommandTeam {
    private static final SimpleCommandExceptionType ERROR_TEAM_ALREADY_EXISTS = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.team.add.duplicate"));
    private static final SimpleCommandExceptionType ERROR_TEAM_ALREADY_EMPTY = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.team.empty.unchanged"));
    private static final SimpleCommandExceptionType ERROR_TEAM_ALREADY_NAME = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.team.option.name.unchanged"));
    private static final SimpleCommandExceptionType ERROR_TEAM_ALREADY_COLOR = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.team.option.color.unchanged"));
    private static final SimpleCommandExceptionType ERROR_TEAM_ALREADY_FRIENDLYFIRE_ENABLED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.team.option.friendlyfire.alreadyEnabled"));
    private static final SimpleCommandExceptionType ERROR_TEAM_ALREADY_FRIENDLYFIRE_DISABLED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.team.option.friendlyfire.alreadyDisabled"));
    private static final SimpleCommandExceptionType ERROR_TEAM_ALREADY_FRIENDLYINVISIBLES_ENABLED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.team.option.seeFriendlyInvisibles.alreadyEnabled"));
    private static final SimpleCommandExceptionType ERROR_TEAM_ALREADY_FRIENDLYINVISIBLES_DISABLED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.team.option.seeFriendlyInvisibles.alreadyDisabled"));
    private static final SimpleCommandExceptionType ERROR_TEAM_NAMETAG_VISIBLITY_UNCHANGED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.team.option.nametagVisibility.unchanged"));
    private static final SimpleCommandExceptionType ERROR_TEAM_DEATH_MESSAGE_VISIBLITY_UNCHANGED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.team.option.deathMessageVisibility.unchanged"));
    private static final SimpleCommandExceptionType ERROR_TEAM_COLLISION_UNCHANGED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.team.option.collisionRule.unchanged"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("team").requires(net.minecraft.commands.CommandDispatcher.hasPermission(net.minecraft.commands.CommandDispatcher.LEVEL_GAMEMASTERS))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("list").executes(var0 -> CommandTeam.listTeams((CommandListenerWrapper)var0.getSource()))).then(net.minecraft.commands.CommandDispatcher.argument("team", ArgumentScoreboardTeam.team()).executes(var0 -> CommandTeam.listMembers((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team")))))).then(net.minecraft.commands.CommandDispatcher.literal("add").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("team", StringArgumentType.word()).executes(var0 -> CommandTeam.createTeam((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"team")))).then(net.minecraft.commands.CommandDispatcher.argument("displayName", ArgumentChatComponent.textComponent(var1)).executes(var0 -> CommandTeam.createTeam((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"team"), ArgumentChatComponent.getResolvedComponent((CommandContext<CommandListenerWrapper>)var0, "displayName"))))))).then(net.minecraft.commands.CommandDispatcher.literal("remove").then(net.minecraft.commands.CommandDispatcher.argument("team", ArgumentScoreboardTeam.team()).executes(var0 -> CommandTeam.deleteTeam((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team")))))).then(net.minecraft.commands.CommandDispatcher.literal("empty").then(net.minecraft.commands.CommandDispatcher.argument("team", ArgumentScoreboardTeam.team()).executes(var0 -> CommandTeam.emptyTeam((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team")))))).then(net.minecraft.commands.CommandDispatcher.literal("join").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("team", ArgumentScoreboardTeam.team()).executes(var0 -> CommandTeam.joinTeam((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team"), Collections.singleton(((CommandListenerWrapper)var0.getSource()).getEntityOrException())))).then(net.minecraft.commands.CommandDispatcher.argument("members", ArgumentScoreholder.scoreHolders()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).executes(var0 -> CommandTeam.joinTeam((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team"), ArgumentScoreholder.getNamesWithDefaultWildcard((CommandContext<CommandListenerWrapper>)var0, "members"))))))).then(net.minecraft.commands.CommandDispatcher.literal("leave").then(net.minecraft.commands.CommandDispatcher.argument("members", ArgumentScoreholder.scoreHolders()).suggests(ArgumentScoreholder.SUGGEST_SCORE_HOLDERS).executes(var0 -> CommandTeam.leaveTeam((CommandListenerWrapper)var0.getSource(), ArgumentScoreholder.getNamesWithDefaultWildcard((CommandContext<CommandListenerWrapper>)var0, "members")))))).then(net.minecraft.commands.CommandDispatcher.literal("modify").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("team", ArgumentScoreboardTeam.team()).then(net.minecraft.commands.CommandDispatcher.literal("displayName").then(net.minecraft.commands.CommandDispatcher.argument("displayName", ArgumentChatComponent.textComponent(var1)).executes(var0 -> CommandTeam.setDisplayName((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team"), ArgumentChatComponent.getResolvedComponent((CommandContext<CommandListenerWrapper>)var0, "displayName")))))).then(net.minecraft.commands.CommandDispatcher.literal("color").then(net.minecraft.commands.CommandDispatcher.argument("value", ArgumentChatFormat.color()).executes(var0 -> CommandTeam.setColor((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team"), ArgumentChatFormat.getColor((CommandContext<CommandListenerWrapper>)var0, "value")))))).then(net.minecraft.commands.CommandDispatcher.literal("friendlyFire").then(net.minecraft.commands.CommandDispatcher.argument("allowed", BoolArgumentType.bool()).executes(var0 -> CommandTeam.setFriendlyFire((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team"), BoolArgumentType.getBool((CommandContext)var0, (String)"allowed")))))).then(net.minecraft.commands.CommandDispatcher.literal("seeFriendlyInvisibles").then(net.minecraft.commands.CommandDispatcher.argument("allowed", BoolArgumentType.bool()).executes(var0 -> CommandTeam.setFriendlySight((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team"), BoolArgumentType.getBool((CommandContext)var0, (String)"allowed")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("nametagVisibility").then(net.minecraft.commands.CommandDispatcher.literal("never").executes(var0 -> CommandTeam.setNametagVisibility((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team"), ScoreboardTeamBase.EnumNameTagVisibility.NEVER)))).then(net.minecraft.commands.CommandDispatcher.literal("hideForOtherTeams").executes(var0 -> CommandTeam.setNametagVisibility((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team"), ScoreboardTeamBase.EnumNameTagVisibility.HIDE_FOR_OTHER_TEAMS)))).then(net.minecraft.commands.CommandDispatcher.literal("hideForOwnTeam").executes(var0 -> CommandTeam.setNametagVisibility((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team"), ScoreboardTeamBase.EnumNameTagVisibility.HIDE_FOR_OWN_TEAM)))).then(net.minecraft.commands.CommandDispatcher.literal("always").executes(var0 -> CommandTeam.setNametagVisibility((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team"), ScoreboardTeamBase.EnumNameTagVisibility.ALWAYS))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("deathMessageVisibility").then(net.minecraft.commands.CommandDispatcher.literal("never").executes(var0 -> CommandTeam.setDeathMessageVisibility((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team"), ScoreboardTeamBase.EnumNameTagVisibility.NEVER)))).then(net.minecraft.commands.CommandDispatcher.literal("hideForOtherTeams").executes(var0 -> CommandTeam.setDeathMessageVisibility((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team"), ScoreboardTeamBase.EnumNameTagVisibility.HIDE_FOR_OTHER_TEAMS)))).then(net.minecraft.commands.CommandDispatcher.literal("hideForOwnTeam").executes(var0 -> CommandTeam.setDeathMessageVisibility((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team"), ScoreboardTeamBase.EnumNameTagVisibility.HIDE_FOR_OWN_TEAM)))).then(net.minecraft.commands.CommandDispatcher.literal("always").executes(var0 -> CommandTeam.setDeathMessageVisibility((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team"), ScoreboardTeamBase.EnumNameTagVisibility.ALWAYS))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("collisionRule").then(net.minecraft.commands.CommandDispatcher.literal("never").executes(var0 -> CommandTeam.setCollision((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team"), ScoreboardTeamBase.EnumTeamPush.NEVER)))).then(net.minecraft.commands.CommandDispatcher.literal("pushOwnTeam").executes(var0 -> CommandTeam.setCollision((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team"), ScoreboardTeamBase.EnumTeamPush.PUSH_OWN_TEAM)))).then(net.minecraft.commands.CommandDispatcher.literal("pushOtherTeams").executes(var0 -> CommandTeam.setCollision((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team"), ScoreboardTeamBase.EnumTeamPush.PUSH_OTHER_TEAMS)))).then(net.minecraft.commands.CommandDispatcher.literal("always").executes(var0 -> CommandTeam.setCollision((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team"), ScoreboardTeamBase.EnumTeamPush.ALWAYS))))).then(net.minecraft.commands.CommandDispatcher.literal("prefix").then(net.minecraft.commands.CommandDispatcher.argument("prefix", ArgumentChatComponent.textComponent(var1)).executes(var0 -> CommandTeam.setPrefix((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team"), ArgumentChatComponent.getResolvedComponent((CommandContext<CommandListenerWrapper>)var0, "prefix")))))).then(net.minecraft.commands.CommandDispatcher.literal("suffix").then(net.minecraft.commands.CommandDispatcher.argument("suffix", ArgumentChatComponent.textComponent(var1)).executes(var0 -> CommandTeam.setSuffix((CommandListenerWrapper)var0.getSource(), ArgumentScoreboardTeam.getTeam((CommandContext<CommandListenerWrapper>)var0, "team"), ArgumentChatComponent.getResolvedComponent((CommandContext<CommandListenerWrapper>)var0, "suffix"))))))));
    }

    private static IChatBaseComponent getFirstMemberName(Collection<ScoreHolder> var0) {
        return var0.iterator().next().getFeedbackDisplayName();
    }

    private static int leaveTeam(CommandListenerWrapper var0, Collection<ScoreHolder> var1) {
        ScoreboardServer var2 = var0.getServer().getScoreboard();
        for (ScoreHolder var4 : var1) {
            var2.removePlayerFromTeam(var4.getScoreboardName());
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.team.leave.success.single", CommandTeam.getFirstMemberName(var1)), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.team.leave.success.multiple", var1.size()), true);
        }
        return var1.size();
    }

    private static int joinTeam(CommandListenerWrapper var0, ScoreboardTeam var1, Collection<ScoreHolder> var2) {
        ScoreboardServer var3 = var0.getServer().getScoreboard();
        for (ScoreHolder var5 : var2) {
            ((Scoreboard)var3).addPlayerToTeam(var5.getScoreboardName(), var1);
        }
        if (var2.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.team.join.success.single", CommandTeam.getFirstMemberName(var2), var1.getFormattedDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.team.join.success.multiple", var2.size(), var1.getFormattedDisplayName()), true);
        }
        return var2.size();
    }

    private static int setNametagVisibility(CommandListenerWrapper var0, ScoreboardTeam var1, ScoreboardTeamBase.EnumNameTagVisibility var2) throws CommandSyntaxException {
        if (var1.getNameTagVisibility() == var2) {
            throw ERROR_TEAM_NAMETAG_VISIBLITY_UNCHANGED.create();
        }
        var1.setNameTagVisibility(var2);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.team.option.nametagVisibility.success", var1.getFormattedDisplayName(), var2.getDisplayName()), true);
        return 0;
    }

    private static int setDeathMessageVisibility(CommandListenerWrapper var0, ScoreboardTeam var1, ScoreboardTeamBase.EnumNameTagVisibility var2) throws CommandSyntaxException {
        if (var1.getDeathMessageVisibility() == var2) {
            throw ERROR_TEAM_DEATH_MESSAGE_VISIBLITY_UNCHANGED.create();
        }
        var1.setDeathMessageVisibility(var2);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.team.option.deathMessageVisibility.success", var1.getFormattedDisplayName(), var2.getDisplayName()), true);
        return 0;
    }

    private static int setCollision(CommandListenerWrapper var0, ScoreboardTeam var1, ScoreboardTeamBase.EnumTeamPush var2) throws CommandSyntaxException {
        if (var1.getCollisionRule() == var2) {
            throw ERROR_TEAM_COLLISION_UNCHANGED.create();
        }
        var1.setCollisionRule(var2);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.team.option.collisionRule.success", var1.getFormattedDisplayName(), var2.getDisplayName()), true);
        return 0;
    }

    private static int setFriendlySight(CommandListenerWrapper var0, ScoreboardTeam var1, boolean var2) throws CommandSyntaxException {
        if (var1.canSeeFriendlyInvisibles() == var2) {
            if (var2) {
                throw ERROR_TEAM_ALREADY_FRIENDLYINVISIBLES_ENABLED.create();
            }
            throw ERROR_TEAM_ALREADY_FRIENDLYINVISIBLES_DISABLED.create();
        }
        var1.setSeeFriendlyInvisibles(var2);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.team.option.seeFriendlyInvisibles." + (var2 ? "enabled" : "disabled"), var1.getFormattedDisplayName()), true);
        return 0;
    }

    private static int setFriendlyFire(CommandListenerWrapper var0, ScoreboardTeam var1, boolean var2) throws CommandSyntaxException {
        if (var1.isAllowFriendlyFire() == var2) {
            if (var2) {
                throw ERROR_TEAM_ALREADY_FRIENDLYFIRE_ENABLED.create();
            }
            throw ERROR_TEAM_ALREADY_FRIENDLYFIRE_DISABLED.create();
        }
        var1.setAllowFriendlyFire(var2);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.team.option.friendlyfire." + (var2 ? "enabled" : "disabled"), var1.getFormattedDisplayName()), true);
        return 0;
    }

    private static int setDisplayName(CommandListenerWrapper var0, ScoreboardTeam var1, IChatBaseComponent var2) throws CommandSyntaxException {
        if (var1.getDisplayName().equals(var2)) {
            throw ERROR_TEAM_ALREADY_NAME.create();
        }
        var1.setDisplayName(var2);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.team.option.name.success", var1.getFormattedDisplayName()), true);
        return 0;
    }

    private static int setColor(CommandListenerWrapper var0, ScoreboardTeam var1, EnumChatFormat var2) throws CommandSyntaxException {
        if (var1.getColor() == var2) {
            throw ERROR_TEAM_ALREADY_COLOR.create();
        }
        var1.setColor(var2);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.team.option.color.success", var1.getFormattedDisplayName(), var2.getName()), true);
        return 0;
    }

    private static int emptyTeam(CommandListenerWrapper var0, ScoreboardTeam var1) throws CommandSyntaxException {
        ScoreboardServer var2 = var0.getServer().getScoreboard();
        ArrayList var3 = Lists.newArrayList(var1.getPlayers());
        if (var3.isEmpty()) {
            throw ERROR_TEAM_ALREADY_EMPTY.create();
        }
        for (String var5 : var3) {
            ((Scoreboard)var2).removePlayerFromTeam(var5, var1);
        }
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.team.empty.success", var3.size(), var1.getFormattedDisplayName()), true);
        return var3.size();
    }

    private static int deleteTeam(CommandListenerWrapper var0, ScoreboardTeam var1) {
        ScoreboardServer var2 = var0.getServer().getScoreboard();
        var2.removePlayerTeam(var1);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.team.remove.success", var1.getFormattedDisplayName()), true);
        return var2.getPlayerTeams().size();
    }

    private static int createTeam(CommandListenerWrapper var0, String var1) throws CommandSyntaxException {
        return CommandTeam.createTeam(var0, var1, IChatBaseComponent.literal(var1));
    }

    private static int createTeam(CommandListenerWrapper var0, String var1, IChatBaseComponent var2) throws CommandSyntaxException {
        ScoreboardServer var3 = var0.getServer().getScoreboard();
        if (var3.getPlayerTeam(var1) != null) {
            throw ERROR_TEAM_ALREADY_EXISTS.create();
        }
        ScoreboardTeam var4 = var3.addPlayerTeam(var1);
        var4.setDisplayName(var2);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.team.add.success", var4.getFormattedDisplayName()), true);
        return var3.getPlayerTeams().size();
    }

    private static int listMembers(CommandListenerWrapper var0, ScoreboardTeam var1) {
        Collection<String> var2 = var1.getPlayers();
        if (var2.isEmpty()) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.team.list.members.empty", var1.getFormattedDisplayName()), false);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.team.list.members.success", var1.getFormattedDisplayName(), var2.size(), ChatComponentUtils.formatList(var2)), false);
        }
        return var2.size();
    }

    private static int listTeams(CommandListenerWrapper var0) {
        Collection<ScoreboardTeam> var1 = var0.getServer().getScoreboard().getPlayerTeams();
        if (var1.isEmpty()) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.team.list.teams.empty"), false);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.team.list.teams.success", var1.size(), ChatComponentUtils.formatList(var1, ScoreboardTeam::getFormattedDisplayName)), false);
        }
        return var1.size();
    }

    private static int setPrefix(CommandListenerWrapper var0, ScoreboardTeam var1, IChatBaseComponent var2) {
        var1.setPlayerPrefix(var2);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.team.option.prefix.success", var2), false);
        return 1;
    }

    private static int setSuffix(CommandListenerWrapper var0, ScoreboardTeam var1, IChatBaseComponent var2) {
        var1.setPlayerSuffix(var2);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.team.option.suffix.success", var2), false);
        return 1;
    }
}

