/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.player.EntityHuman;

public class CommandXp {
    private static final SimpleCommandExceptionType ERROR_SET_POINTS_INVALID = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.experience.set.points.invalid"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        LiteralCommandNode var1 = var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("experience").requires(net.minecraft.commands.CommandDispatcher.hasPermission(net.minecraft.commands.CommandDispatcher.LEVEL_GAMEMASTERS))).then(net.minecraft.commands.CommandDispatcher.literal("add").then(net.minecraft.commands.CommandDispatcher.argument("target", ArgumentEntity.players()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("amount", IntegerArgumentType.integer()).executes(var0 -> CommandXp.addExperience((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "target"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"amount"), Unit.POINTS))).then(net.minecraft.commands.CommandDispatcher.literal("points").executes(var0 -> CommandXp.addExperience((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "target"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"amount"), Unit.POINTS)))).then(net.minecraft.commands.CommandDispatcher.literal("levels").executes(var0 -> CommandXp.addExperience((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "target"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"amount"), Unit.LEVELS))))))).then(net.minecraft.commands.CommandDispatcher.literal("set").then(net.minecraft.commands.CommandDispatcher.argument("target", ArgumentEntity.players()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("amount", IntegerArgumentType.integer((int)0)).executes(var0 -> CommandXp.setExperience((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "target"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"amount"), Unit.POINTS))).then(net.minecraft.commands.CommandDispatcher.literal("points").executes(var0 -> CommandXp.setExperience((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "target"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"amount"), Unit.POINTS)))).then(net.minecraft.commands.CommandDispatcher.literal("levels").executes(var0 -> CommandXp.setExperience((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "target"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"amount"), Unit.LEVELS))))))).then(net.minecraft.commands.CommandDispatcher.literal("query").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("target", ArgumentEntity.player()).then(net.minecraft.commands.CommandDispatcher.literal("points").executes(var0 -> CommandXp.queryExperience((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayer((CommandContext<CommandListenerWrapper>)var0, "target"), Unit.POINTS)))).then(net.minecraft.commands.CommandDispatcher.literal("levels").executes(var0 -> CommandXp.queryExperience((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayer((CommandContext<CommandListenerWrapper>)var0, "target"), Unit.LEVELS))))));
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("xp").requires(net.minecraft.commands.CommandDispatcher.hasPermission(net.minecraft.commands.CommandDispatcher.LEVEL_GAMEMASTERS))).redirect((CommandNode)var1));
    }

    private static int queryExperience(CommandListenerWrapper var0, EntityPlayer var1, Unit var2) {
        int var3 = var2.query.applyAsInt(var1);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.experience.query." + var0.name, var1.getDisplayName(), var3), false);
        return var3;
    }

    private static int addExperience(CommandListenerWrapper var0, Collection<? extends EntityPlayer> var1, int var2, Unit var3) {
        for (EntityPlayer entityPlayer : var1) {
            var3.add.accept(entityPlayer, var2);
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.experience.add." + var0.name + ".success.single", var1, ((EntityPlayer)var2.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.experience.add." + var0.name + ".success.multiple", var1, var2.size()), true);
        }
        return var1.size();
    }

    private static int setExperience(CommandListenerWrapper var0, Collection<? extends EntityPlayer> var1, int var2, Unit var3) throws CommandSyntaxException {
        int var4 = 0;
        for (EntityPlayer entityPlayer : var1) {
            if (!var3.set.test(entityPlayer, var2)) continue;
            ++var4;
        }
        if (var4 == 0) {
            throw ERROR_SET_POINTS_INVALID.create();
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.experience.set." + var0.name + ".success.single", var1, ((EntityPlayer)var2.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.experience.set." + var0.name + ".success.multiple", var1, var2.size()), true);
        }
        return var1.size();
    }

    static final class Unit
    extends Enum<Unit> {
        public static final /* enum */ Unit POINTS = new Unit("points", EntityHuman::giveExperiencePoints, (var0, var1) -> {
            if (var1 >= var0.getXpNeededForNextLevel()) {
                return false;
            }
            var0.setExperiencePoints((int)var1);
            return true;
        }, var0 -> MathHelper.floor(var0.experienceProgress * (float)var0.getXpNeededForNextLevel()));
        public static final /* enum */ Unit LEVELS = new Unit("levels", EntityPlayer::giveExperienceLevels, (var0, var1) -> {
            var0.setExperienceLevels((int)var1);
            return true;
        }, var0 -> var0.experienceLevel);
        public final BiConsumer<EntityPlayer, Integer> add;
        public final BiPredicate<EntityPlayer, Integer> set;
        public final String name;
        final ToIntFunction<EntityPlayer> query;
        private static final /* synthetic */ Unit[] g;

        public static Unit[] values() {
            return (Unit[])g.clone();
        }

        public static Unit valueOf(String var0) {
            return Enum.valueOf(Unit.class, var0);
        }

        private Unit(String var2, BiConsumer var3, BiPredicate var4, ToIntFunction var5) {
            this.add = var3;
            this.name = var2;
            this.set = var4;
            this.query = var5;
        }

        private static /* synthetic */ Unit[] a() {
            return new Unit[]{POINTS, LEVELS};
        }

        static {
            g = Unit.a();
        }
    }
}

