/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.level.pathfinder.PathEntity;

public class DebugPathCommand {
    private static final SimpleCommandExceptionType ERROR_NOT_MOB = new SimpleCommandExceptionType((Message)IChatBaseComponent.literal("Source is not a mob"));
    private static final SimpleCommandExceptionType ERROR_NO_PATH = new SimpleCommandExceptionType((Message)IChatBaseComponent.literal("Path not found"));
    private static final SimpleCommandExceptionType ERROR_NOT_COMPLETE = new SimpleCommandExceptionType((Message)IChatBaseComponent.literal("Target not reached"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("debugpath").requires(net.minecraft.commands.CommandDispatcher.hasPermission(net.minecraft.commands.CommandDispatcher.LEVEL_GAMEMASTERS))).then(net.minecraft.commands.CommandDispatcher.argument("to", ArgumentPosition.blockPos()).executes(var0 -> DebugPathCommand.fillBlocks((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "to")))));
    }

    private static int fillBlocks(CommandListenerWrapper var0, BlockPosition var1) throws CommandSyntaxException {
        Entity var2 = var0.getEntity();
        if (!(var2 instanceof EntityInsentient)) {
            throw ERROR_NOT_MOB.create();
        }
        EntityInsentient var3 = (EntityInsentient)var2;
        Navigation var4 = new Navigation(var3, var0.getLevel());
        PathEntity var5 = ((NavigationAbstract)var4).createPath(var1, 0);
        if (var5 == null) {
            throw ERROR_NO_PATH.create();
        }
        if (!var5.canReach()) {
            throw ERROR_NOT_COMPLETE.create();
        }
        var0.sendSuccess(() -> IChatBaseComponent.literal("Made path"), true);
        return 1;
    }
}

