/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Stopwatch;
import net.minecraft.world.Stopwatches;

public class StopwatchCommand {
    private static final DynamicCommandExceptionType ERROR_ALREADY_EXISTS = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.stopwatch.already_exists", var0));
    public static final DynamicCommandExceptionType ERROR_DOES_NOT_EXIST = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.stopwatch.does_not_exist", var0));
    public static final SuggestionProvider<CommandListenerWrapper> SUGGEST_STOPWATCHES = (var0, var1) -> ICompletionProvider.suggestResource(((CommandListenerWrapper)var0.getSource()).getServer().getStopwatches().ids(), var1);

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("stopwatch").requires(net.minecraft.commands.CommandDispatcher.hasPermission(net.minecraft.commands.CommandDispatcher.LEVEL_GAMEMASTERS))).then(net.minecraft.commands.CommandDispatcher.literal("create").then(net.minecraft.commands.CommandDispatcher.argument("id", ArgumentMinecraftKeyRegistered.id()).executes(var0 -> StopwatchCommand.createStopwatch((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "id")))))).then(net.minecraft.commands.CommandDispatcher.literal("query").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("id", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_STOPWATCHES).then(net.minecraft.commands.CommandDispatcher.argument("scale", DoubleArgumentType.doubleArg()).executes(var0 -> StopwatchCommand.queryStopwatch((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "id"), DoubleArgumentType.getDouble((CommandContext)var0, (String)"scale"))))).executes(var0 -> StopwatchCommand.queryStopwatch((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "id"), 1.0))))).then(net.minecraft.commands.CommandDispatcher.literal("restart").then(net.minecraft.commands.CommandDispatcher.argument("id", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_STOPWATCHES).executes(var0 -> StopwatchCommand.restartStopwatch((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "id")))))).then(net.minecraft.commands.CommandDispatcher.literal("remove").then(net.minecraft.commands.CommandDispatcher.argument("id", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_STOPWATCHES).executes(var0 -> StopwatchCommand.removeStopwatch((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "id"))))));
    }

    private static int createStopwatch(CommandListenerWrapper var0, MinecraftKey var1) throws CommandSyntaxException {
        Stopwatch var4;
        MinecraftServer var2 = var0.getServer();
        Stopwatches var3 = var2.getStopwatches();
        if (!var3.add(var1, var4 = new Stopwatch(Stopwatches.currentTime()))) {
            throw ERROR_ALREADY_EXISTS.create((Object)var1);
        }
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.stopwatch.create.success", IChatBaseComponent.translationArg(var1)), true);
        return 1;
    }

    private static int queryStopwatch(CommandListenerWrapper var0, MinecraftKey var1, double var2) throws CommandSyntaxException {
        MinecraftServer var4 = var0.getServer();
        Stopwatches var5 = var4.getStopwatches();
        Stopwatch var6 = var5.get(var1);
        if (var6 == null) {
            throw ERROR_DOES_NOT_EXIST.create((Object)var1);
        }
        long var7 = Stopwatches.currentTime();
        double var9 = var6.elapsedSeconds(var7);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.stopwatch.query", IChatBaseComponent.translationArg(var1), var9), true);
        return (int)(var9 * var2);
    }

    private static int restartStopwatch(CommandListenerWrapper var02, MinecraftKey var1) throws CommandSyntaxException {
        MinecraftServer var2 = var02.getServer();
        Stopwatches var3 = var2.getStopwatches();
        if (!var3.update(var1, var0 -> new Stopwatch(Stopwatches.currentTime()))) {
            throw ERROR_DOES_NOT_EXIST.create((Object)var1);
        }
        var02.sendSuccess(() -> IChatBaseComponent.translatable("commands.stopwatch.restart.success", IChatBaseComponent.translationArg(var1)), true);
        return 1;
    }

    private static int removeStopwatch(CommandListenerWrapper var0, MinecraftKey var1) throws CommandSyntaxException {
        MinecraftServer var2 = var0.getServer();
        Stopwatches var3 = var2.getStopwatches();
        if (!var3.remove(var1)) {
            throw ERROR_DOES_NOT_EXIST.create((Object)var1);
        }
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.stopwatch.remove.success", IChatBaseComponent.translationArg(var1)), true);
        return 1;
    }
}

