/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HexFormat;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentChatFormat;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.HexColorArgument;
import net.minecraft.commands.arguments.WaypointArgument;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.waypoints.Waypoint;
import net.minecraft.world.waypoints.WaypointStyleAsset;
import net.minecraft.world.waypoints.WaypointStyleAssets;
import net.minecraft.world.waypoints.WaypointTransmitter;

public class WaypointCommand {
    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("waypoint").requires(net.minecraft.commands.CommandDispatcher.hasPermission(net.minecraft.commands.CommandDispatcher.LEVEL_GAMEMASTERS))).then(net.minecraft.commands.CommandDispatcher.literal("list").executes(var0 -> WaypointCommand.listWaypoints((CommandListenerWrapper)var0.getSource())))).then(net.minecraft.commands.CommandDispatcher.literal("modify").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("waypoint", ArgumentEntity.entity()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("color").then(net.minecraft.commands.CommandDispatcher.argument("color", ArgumentChatFormat.color()).executes(var0 -> WaypointCommand.setWaypointColor((CommandListenerWrapper)var0.getSource(), WaypointArgument.getWaypoint((CommandContext<CommandListenerWrapper>)var0, "waypoint"), ArgumentChatFormat.getColor((CommandContext<CommandListenerWrapper>)var0, "color"))))).then(net.minecraft.commands.CommandDispatcher.literal("hex").then(net.minecraft.commands.CommandDispatcher.argument("color", HexColorArgument.hexColor()).executes(var0 -> WaypointCommand.setWaypointColor((CommandListenerWrapper)var0.getSource(), WaypointArgument.getWaypoint((CommandContext<CommandListenerWrapper>)var0, "waypoint"), HexColorArgument.getHexColor((CommandContext<CommandListenerWrapper>)var0, "color")))))).then(net.minecraft.commands.CommandDispatcher.literal("reset").executes(var0 -> WaypointCommand.resetWaypointColor((CommandListenerWrapper)var0.getSource(), WaypointArgument.getWaypoint((CommandContext<CommandListenerWrapper>)var0, "waypoint")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("style").then(net.minecraft.commands.CommandDispatcher.literal("reset").executes(var0 -> WaypointCommand.setWaypointStyle((CommandListenerWrapper)var0.getSource(), WaypointArgument.getWaypoint((CommandContext<CommandListenerWrapper>)var0, "waypoint"), WaypointStyleAssets.DEFAULT)))).then(net.minecraft.commands.CommandDispatcher.literal("set").then(net.minecraft.commands.CommandDispatcher.argument("style", ArgumentMinecraftKeyRegistered.id()).executes(var0 -> WaypointCommand.setWaypointStyle((CommandListenerWrapper)var0.getSource(), WaypointArgument.getWaypoint((CommandContext<CommandListenerWrapper>)var0, "waypoint"), ResourceKey.create(WaypointStyleAssets.ROOT_ID, ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "style"))))))))));
    }

    private static int setWaypointStyle(CommandListenerWrapper var0, WaypointTransmitter var12, ResourceKey<WaypointStyleAsset> var2) {
        WaypointCommand.mutateIcon(var0, var12, var1 -> {
            var1.style = var2;
        });
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.waypoint.modify.style"), false);
        return 0;
    }

    private static int setWaypointColor(CommandListenerWrapper var0, WaypointTransmitter var12, EnumChatFormat var2) {
        WaypointCommand.mutateIcon(var0, var12, var1 -> {
            var1.color = Optional.of(var2.getColor());
        });
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.waypoint.modify.color", IChatBaseComponent.literal(var2.getName()).withStyle(var2)), false);
        return 0;
    }

    private static int setWaypointColor(CommandListenerWrapper var0, WaypointTransmitter var12, Integer var2) {
        WaypointCommand.mutateIcon(var0, var12, var1 -> {
            var1.color = Optional.of(var2);
        });
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.waypoint.modify.color", IChatBaseComponent.literal(HexFormat.of().withUpperCase().toHexDigits(ARGB.color(0, (int)var2), 6)).withColor(var2)), false);
        return 0;
    }

    private static int resetWaypointColor(CommandListenerWrapper var02, WaypointTransmitter var1) {
        WaypointCommand.mutateIcon(var02, var1, var0 -> {
            var0.color = Optional.empty();
        });
        var02.sendSuccess(() -> IChatBaseComponent.translatable("commands.waypoint.modify.color.reset"), false);
        return 0;
    }

    private static int listWaypoints(CommandListenerWrapper var0) {
        WorldServer var12 = var0.getLevel();
        Set<WaypointTransmitter> var2 = var12.getWaypointManager().transmitters();
        String var3 = var12.dimension().identifier().toString();
        if (var2.isEmpty()) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.waypoint.list.empty", var3), false);
            return 0;
        }
        IChatBaseComponent var4 = ChatComponentUtils.formatList(var2.stream().map(var1 -> {
            if (var1 instanceof EntityLiving) {
                EntityLiving var2 = (EntityLiving)var1;
                BlockPosition var32 = var2.blockPosition();
                return var2.getFeedbackDisplayName().copy().withStyle(var3 -> var3.withClickEvent(new ChatClickable.SuggestCommand("/execute in " + var3 + " run tp @s " + var32.getX() + " " + var32.getY() + " " + var32.getZ())).withHoverEvent(new ChatHoverable.e(IChatBaseComponent.translatable("chat.coordinates.tooltip"))).withColor(var2.waypointIcon().color.orElse(-1)));
            }
            return IChatBaseComponent.literal(var1.toString());
        }).toList(), Function.identity());
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.waypoint.list.success", var2.size(), var3, var4), false);
        return var2.size();
    }

    private static void mutateIcon(CommandListenerWrapper var0, WaypointTransmitter var1, Consumer<Waypoint.a> var2) {
        WorldServer var3 = var0.getLevel();
        var3.getWaypointManager().untrackWaypoint(var1);
        var2.accept(var1.waypointIcon());
        var3.getWaypointManager().trackWaypoint(var1);
    }
}

