/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import io.netty.handler.ssl.SslContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.IMinecraftServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerCommand;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.Services;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.dedicated.ThreadWatchdog;
import net.minecraft.server.gui.ServerGUI;
import net.minecraft.server.jsonrpc.JsonRpcNotificationService;
import net.minecraft.server.jsonrpc.ManagementServer;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.security.AuthenticationHandler;
import net.minecraft.server.jsonrpc.security.JsonRpcSslContextProvider;
import net.minecraft.server.jsonrpc.security.SecurityConfig;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.LoggingLevelLoadListener;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerTextFilter;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.rcon.RemoteControlCommandListener;
import net.minecraft.server.rcon.thread.RemoteControlListener;
import net.minecraft.server.rcon.thread.RemoteStatusListener;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.TimeRange;
import net.minecraft.util.UtilColor;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debugchart.RemoteDebugSampleType;
import net.minecraft.util.debugchart.RemoteSampleLogger;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.util.debugchart.TpsDebugDimensions;
import net.minecraft.util.monitoring.jmx.MinecraftServerBeans;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldData;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class DedicatedServer
extends MinecraftServer
implements IMinecraftServer {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int CONVERSION_RETRY_DELAY_MS = 5000;
    private static final int CONVERSION_RETRIES = 2;
    private final List<ServerCommand> consoleInput = Collections.synchronizedList(Lists.newArrayList());
    private @Nullable RemoteStatusListener queryThreadGs4;
    private final RemoteControlCommandListener rconConsoleSource;
    private @Nullable RemoteControlListener rconThread;
    public DedicatedServerSettings settings;
    private @Nullable ServerGUI gui;
    private final @Nullable ServerTextFilter serverTextFilter;
    private @Nullable RemoteSampleLogger tickTimeLogger;
    private boolean isTickTimeLoggingEnabled;
    public ServerLinks serverLinks;
    private final Map<String, String> codeOfConductTexts;
    private @Nullable ManagementServer jsonRpcServer;
    private long lastHeartbeat;

    public DedicatedServer(Thread var0, Convertable.ConversionSession var1, ResourcePackRepository var2, WorldStem var3, DedicatedServerSettings var4, DataFixer var5, Services var6) {
        super(var0, var1, var2, var3, Proxy.NO_PROXY, var5, var6, LoggingLevelLoadListener.forDedicatedServer());
        this.settings = var4;
        this.rconConsoleSource = new RemoteControlCommandListener(this);
        this.serverTextFilter = ServerTextFilter.createFromConfig(var4.getProperties());
        this.serverLinks = DedicatedServer.createServerLinks(var4);
        this.codeOfConductTexts = var4.getProperties().codeOfConduct ? DedicatedServer.readCodeOfConducts() : Map.of();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> readCodeOfConducts() {
        Path var0 = Path.of("codeofconduct", new String[0]);
        if (!Files.isDirectory(var0, LinkOption.NOFOLLOW_LINKS)) {
            throw new IllegalArgumentException("Code of Conduct folder does not exist: " + String.valueOf(var0));
        }
        try {
            ImmutableMap.Builder var1 = ImmutableMap.builder();
            try (Stream<Path> var2 = Files.list(var0);){
                for (Path var4 : var2.toList()) {
                    String var5 = var4.getFileName().toString();
                    if (!var5.endsWith(".txt")) continue;
                    String var6 = var5.substring(0, var5.length() - 4).toLowerCase(Locale.ROOT);
                    if (!var4.toRealPath(new LinkOption[0]).getParent().equals(var0.toAbsolutePath())) {
                        throw new IllegalArgumentException("Failed to read Code of Conduct file \"" + var5 + "\" because it links to a file outside the allowed directory");
                    }
                    try {
                        String var7 = String.join((CharSequence)"\n", Files.readAllLines(var4, StandardCharsets.UTF_8));
                        var1.put((Object)var6, (Object)UtilColor.stripColor(var7));
                    }
                    catch (IOException var7) {
                        throw new IllegalArgumentException("Failed to read Code of Conduct file " + var5, var7);
                        return var1.build();
                    }
                }
            }
        }
        catch (IOException var1) {
            throw new IllegalArgumentException("Failed to read Code of Conduct folder", var1);
        }
    }

    private SslContext createSslContext() {
        try {
            return JsonRpcSslContextProvider.createFrom(this.getProperties().managementServerTlsKeystore, this.getProperties().managementServerTlsKeystorePassword);
        }
        catch (Exception var0) {
            JsonRpcSslContextProvider.printInstructions();
            throw new IllegalStateException("Failed to configure TLS for the server management protocol", var0);
        }
    }

    @Override
    public boolean initServer() throws IOException {
        Object var8;
        Object var3;
        Object var2;
        Object var1;
        int var0 = this.getProperties().managementServerPort;
        if (this.getProperties().managementServerEnabled) {
            var1 = this.settings.getProperties().managementServerSecret;
            if (!SecurityConfig.isValid((String)var1)) {
                throw new IllegalStateException("Invalid management server secret, must be 40 alphanumeric characters");
            }
            var2 = this.getProperties().managementServerHost;
            var3 = HostAndPort.fromParts((String)var2, (int)var0);
            SecurityConfig var4 = new SecurityConfig((String)var1);
            String var5 = this.getProperties().managementServerAllowedOrigins;
            AuthenticationHandler var6 = new AuthenticationHandler(var4, var5);
            LOGGER.info("Starting json RPC server on {}", var3);
            this.jsonRpcServer = new ManagementServer((HostAndPort)var3, var6);
            MinecraftApi var7 = MinecraftApi.of(this);
            var7.notificationManager().registerService(new JsonRpcNotificationService(var7, this.jsonRpcServer));
            if (this.getProperties().managementServerTlsEnabled) {
                var8 = this.createSslContext();
                this.jsonRpcServer.startWithTls(var7, (SslContext)var8);
            } else {
                this.jsonRpcServer.startWithoutTls(var7);
            }
        }
        var1 = new Thread("Server console handler"){

            @Override
            public void run() {
                BufferedReader var0 = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
                try {
                    String var1;
                    while (!DedicatedServer.this.isStopped() && DedicatedServer.this.isRunning() && (var1 = var0.readLine()) != null) {
                        DedicatedServer.this.handleConsoleInput(var1, DedicatedServer.this.createCommandSourceStack());
                    }
                }
                catch (IOException var2) {
                    LOGGER.error("Exception handling console input", (Throwable)var2);
                }
            }
        };
        ((Thread)var1).setDaemon(true);
        ((Thread)var1).setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        ((Thread)var1).start();
        LOGGER.info("Starting minecraft server version {}", (Object)SharedConstants.getCurrentVersion().name());
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            LOGGER.warn("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        LOGGER.info("Loading properties");
        var2 = this.settings.getProperties();
        if (this.isSingleplayer()) {
            this.setLocalIp("127.0.0.1");
        } else {
            this.setUsesAuthentication(((DedicatedServerProperties)var2).onlineMode);
            this.setPreventProxyConnections(((DedicatedServerProperties)var2).preventProxyConnections);
            this.setLocalIp(((DedicatedServerProperties)var2).serverIp);
        }
        this.worldData.setGameType(((DedicatedServerProperties)var2).gameMode.get());
        LOGGER.info("Default game type: {}", (Object)((DedicatedServerProperties)var2).gameMode.get());
        var3 = null;
        if (!this.getLocalIp().isEmpty()) {
            var3 = InetAddress.getByName(this.getLocalIp());
        }
        if (this.getPort() < 0) {
            this.setPort(((DedicatedServerProperties)var2).serverPort);
        }
        this.initializeKeyPair();
        LOGGER.info("Starting Minecraft server on {}:{}", (Object)(this.getLocalIp().isEmpty() ? "*" : this.getLocalIp()), (Object)this.getPort());
        try {
            this.getConnection().startTcpServerListener((InetAddress)var3, this.getPort());
        }
        catch (IOException var4) {
            LOGGER.warn("**** FAILED TO BIND TO PORT!");
            LOGGER.warn("The exception was: {}", (Object)var4.toString());
            LOGGER.warn("Perhaps a server is already running on that port?");
            return false;
        }
        if (!this.usesAuthentication()) {
            LOGGER.warn("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            LOGGER.warn("The server will make no attempt to authenticate usernames. Beware.");
            LOGGER.warn("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            LOGGER.warn("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        if (this.convertOldUsers()) {
            this.services.nameToIdCache().save();
        }
        if (!NameReferencingFileConverter.serverReadyAfterUserconversion(this)) {
            return false;
        }
        this.setPlayerList(new DedicatedPlayerList(this, this.registries(), this.playerDataStorage));
        this.tickTimeLogger = new RemoteSampleLogger(TpsDebugDimensions.values().length, this.debugSubscribers(), RemoteDebugSampleType.TICK_TIME);
        long var4 = SystemUtils.getNanos();
        this.services.nameToIdCache().resolveOfflineUsers(!this.usesAuthentication());
        LOGGER.info("Preparing level \"{}\"", (Object)this.getLevelIdName());
        this.loadLevel();
        long var6 = SystemUtils.getNanos() - var4;
        var8 = String.format(Locale.ROOT, "%.3fs", (double)var6 / 1.0E9);
        LOGGER.info("Done ({})! For help, type \"help\"", var8);
        if (((DedicatedServerProperties)var2).announcePlayerAchievements != null) {
            this.worldData.getGameRules().set(GameRules.SHOW_ADVANCEMENT_MESSAGES, ((DedicatedServerProperties)var2).announcePlayerAchievements, this);
        }
        if (((DedicatedServerProperties)var2).enableQuery) {
            LOGGER.info("Starting GS4 status listener");
            this.queryThreadGs4 = RemoteStatusListener.create(this);
        }
        if (((DedicatedServerProperties)var2).enableRcon) {
            LOGGER.info("Starting remote control listener");
            this.rconThread = RemoteControlListener.create(this);
        }
        if (this.getMaxTickLength() > 0L) {
            Thread var9 = new Thread(new ThreadWatchdog(this));
            var9.setUncaughtExceptionHandler(new ThreadNamedUncaughtExceptionHandler(LOGGER));
            var9.setName("Server Watchdog");
            var9.setDaemon(true);
            var9.start();
        }
        if (((DedicatedServerProperties)var2).enableJmxMonitoring) {
            MinecraftServerBeans.registerJmxMonitoring(this);
            LOGGER.info("JMX monitoring enabled");
        }
        this.notificationManager().serverStarted();
        return true;
    }

    @Override
    public boolean isEnforceWhitelist() {
        return this.settings.getProperties().enforceWhitelist.get();
    }

    @Override
    public void setEnforceWhitelist(boolean var0) {
        this.settings.update(var1 -> (DedicatedServerProperties)var1.enforceWhitelist.update(this.registryAccess(), var0));
    }

    @Override
    public boolean isUsingWhitelist() {
        return this.settings.getProperties().whiteList.get();
    }

    @Override
    public void setUsingWhitelist(boolean var0) {
        this.settings.update(var1 -> (DedicatedServerProperties)var1.whiteList.update(this.registryAccess(), var0));
    }

    @Override
    public void tickServer(BooleanSupplier var0) {
        long var4;
        super.tickServer(var0);
        if (this.jsonRpcServer != null) {
            this.jsonRpcServer.tick();
        }
        long var1 = SystemUtils.getMillis();
        int var3 = this.statusHeartbeatInterval();
        if (var3 > 0 && var1 - this.lastHeartbeat >= (var4 = (long)var3 * TimeRange.MILLISECONDS_PER_SECOND)) {
            this.lastHeartbeat = var1;
            this.notificationManager().statusHeartbeat();
        }
    }

    @Override
    public boolean saveAllChunks(boolean var0, boolean var1, boolean var2) {
        this.notificationManager().serverSaveStarted();
        boolean var3 = super.saveAllChunks(var0, var1, var2);
        this.notificationManager().serverSaveCompleted();
        return var3;
    }

    @Override
    public boolean allowFlight() {
        return this.settings.getProperties().allowFlight.get();
    }

    public void setAllowFlight(boolean var0) {
        this.settings.update(var1 -> (DedicatedServerProperties)var1.allowFlight.update(this.registryAccess(), var0));
    }

    @Override
    public DedicatedServerProperties getProperties() {
        return this.settings.getProperties();
    }

    public void setDifficulty(EnumDifficulty var0) {
        this.settings.update(var1 -> (DedicatedServerProperties)var1.difficulty.update(this.registryAccess(), var0));
        this.forceDifficulty();
    }

    @Override
    public void forceDifficulty() {
        this.setDifficulty(this.getProperties().difficulty.get(), true);
    }

    public int viewDistance() {
        return this.settings.getProperties().viewDistance.get();
    }

    public void setViewDistance(int var0) {
        this.settings.update(var1 -> (DedicatedServerProperties)var1.viewDistance.update(this.registryAccess(), var0));
        this.getPlayerList().setViewDistance(var0);
    }

    public int simulationDistance() {
        return this.settings.getProperties().simulationDistance.get();
    }

    public void setSimulationDistance(int var0) {
        this.settings.update(var1 -> (DedicatedServerProperties)var1.simulationDistance.update(this.registryAccess(), var0));
        this.getPlayerList().setSimulationDistance(var0);
    }

    @Override
    public SystemReport fillServerSystemReport(SystemReport var0) {
        var0.setDetail("Is Modded", () -> this.getModdedStatus().fullDescription());
        var0.setDetail("Type", () -> "Dedicated Server (map_server.txt)");
        return var0;
    }

    @Override
    public void dumpServerProperties(Path var0) throws IOException {
        DedicatedServerProperties var1 = this.getProperties();
        try (BufferedWriter var2 = Files.newBufferedWriter(var0, new OpenOption[0]);){
            var2.write(String.format(Locale.ROOT, "sync-chunk-writes=%s%n", var1.syncChunkWrites));
            var2.write(String.format(Locale.ROOT, "gamemode=%s%n", var1.gameMode.get()));
            var2.write(String.format(Locale.ROOT, "entity-broadcast-range-percentage=%d%n", var1.entityBroadcastRangePercentage.get()));
            var2.write(String.format(Locale.ROOT, "max-world-size=%d%n", var1.maxWorldSize));
            var2.write(String.format(Locale.ROOT, "view-distance=%d%n", var1.viewDistance.get()));
            var2.write(String.format(Locale.ROOT, "simulation-distance=%d%n", var1.simulationDistance.get()));
            var2.write(String.format(Locale.ROOT, "generate-structures=%s%n", var1.worldOptions.generateStructures()));
            var2.write(String.format(Locale.ROOT, "use-native=%s%n", var1.useNativeTransport));
            var2.write(String.format(Locale.ROOT, "rate-limit=%d%n", var1.rateLimitPacketsPerSecond));
        }
    }

    @Override
    public void onServerExit() {
        if (this.serverTextFilter != null) {
            this.serverTextFilter.close();
        }
        if (this.gui != null) {
            this.gui.close();
        }
        if (this.rconThread != null) {
            this.rconThread.stop();
        }
        if (this.queryThreadGs4 != null) {
            this.queryThreadGs4.stop();
        }
        if (this.jsonRpcServer != null) {
            try {
                this.jsonRpcServer.stop(true);
            }
            catch (InterruptedException var0) {
                LOGGER.error("Interrupted while stopping the management server", (Throwable)var0);
            }
        }
    }

    @Override
    public void tickConnection() {
        super.tickConnection();
        this.handleConsoleInputs();
    }

    public void handleConsoleInput(String var0, CommandListenerWrapper var1) {
        this.consoleInput.add(new ServerCommand(var0, var1));
    }

    public void handleConsoleInputs() {
        while (!this.consoleInput.isEmpty()) {
            ServerCommand var0 = this.consoleInput.remove(0);
            this.getCommands().performPrefixedCommand(var0.source, var0.msg);
        }
    }

    @Override
    public boolean isDedicatedServer() {
        return true;
    }

    @Override
    public int getRateLimitPacketsPerSecond() {
        return this.getProperties().rateLimitPacketsPerSecond;
    }

    @Override
    public boolean useNativeTransport() {
        return this.getProperties().useNativeTransport;
    }

    @Override
    public DedicatedPlayerList getPlayerList() {
        return (DedicatedPlayerList)super.getPlayerList();
    }

    @Override
    public int getMaxPlayers() {
        return this.settings.getProperties().maxPlayers.get();
    }

    public void setMaxPlayers(int var0) {
        this.settings.update(var1 -> (DedicatedServerProperties)var1.maxPlayers.update(this.registryAccess(), var0));
    }

    @Override
    public boolean isPublished() {
        return true;
    }

    @Override
    public String getServerIp() {
        return this.getLocalIp();
    }

    @Override
    public int getServerPort() {
        return this.getPort();
    }

    @Override
    public String getServerName() {
        return this.getMotd();
    }

    public void showGui() {
        if (this.gui == null) {
            this.gui = ServerGUI.showFrameFor(this);
        }
    }

    public int spawnProtectionRadius() {
        return this.getProperties().spawnProtection.get();
    }

    public void setSpawnProtectionRadius(int var0) {
        this.settings.update(var1 -> (DedicatedServerProperties)var1.spawnProtection.update(this.registryAccess(), var0));
    }

    @Override
    public boolean isUnderSpawnProtection(WorldServer var0, BlockPosition var1, EntityHuman var2) {
        int var6;
        WorldData.a var3 = var0.getRespawnData();
        if (var0.dimension() != var3.dimension()) {
            return false;
        }
        if (this.getPlayerList().getOps().isEmpty()) {
            return false;
        }
        if (this.getPlayerList().isOp(var2.nameAndId())) {
            return false;
        }
        if (this.spawnProtectionRadius() <= 0) {
            return false;
        }
        BlockPosition var4 = var3.pos();
        int var5 = MathHelper.abs(var1.getX() - var4.getX());
        int var7 = Math.max(var5, var6 = MathHelper.abs(var1.getZ() - var4.getZ()));
        return var7 <= this.spawnProtectionRadius();
    }

    @Override
    public boolean repliesToStatus() {
        return this.getProperties().enableStatus.get();
    }

    public void setRepliesToStatus(boolean var0) {
        this.settings.update(var1 -> (DedicatedServerProperties)var1.enableStatus.update(this.registryAccess(), var0));
    }

    @Override
    public boolean hidesOnlinePlayers() {
        return this.getProperties().hideOnlinePlayers.get();
    }

    public void setHidesOnlinePlayers(boolean var0) {
        this.settings.update(var1 -> (DedicatedServerProperties)var1.hideOnlinePlayers.update(this.registryAccess(), var0));
    }

    @Override
    public LevelBasedPermissionSet operatorUserPermissions() {
        return this.getProperties().opPermissions.get();
    }

    public void setOperatorUserPermissions(LevelBasedPermissionSet var0) {
        this.settings.update(var1 -> (DedicatedServerProperties)var1.opPermissions.update(this.registryAccess(), var0));
    }

    @Override
    public PermissionSet getFunctionCompilationPermissions() {
        return this.getProperties().functionPermissions;
    }

    @Override
    public int playerIdleTimeout() {
        return this.settings.getProperties().playerIdleTimeout.get();
    }

    @Override
    public void setPlayerIdleTimeout(int var0) {
        this.settings.update(var1 -> (DedicatedServerProperties)var1.playerIdleTimeout.update(this.registryAccess(), var0));
    }

    public int statusHeartbeatInterval() {
        return this.settings.getProperties().statusHeartbeatInterval.get();
    }

    public void setStatusHeartbeatInterval(int var0) {
        this.settings.update(var1 -> (DedicatedServerProperties)var1.statusHeartbeatInterval.update(this.registryAccess(), var0));
    }

    @Override
    public String getMotd() {
        return this.settings.getProperties().motd.get();
    }

    @Override
    public void setMotd(String var0) {
        this.settings.update(var1 -> (DedicatedServerProperties)var1.motd.update(this.registryAccess(), var0));
    }

    @Override
    public boolean shouldRconBroadcast() {
        return this.getProperties().broadcastRconToOps;
    }

    @Override
    public boolean shouldInformAdmins() {
        return this.getProperties().broadcastConsoleToOps;
    }

    @Override
    public int getAbsoluteMaxWorldSize() {
        return this.getProperties().maxWorldSize;
    }

    @Override
    public int getCompressionThreshold() {
        return this.getProperties().networkCompressionThreshold;
    }

    @Override
    public boolean enforceSecureProfile() {
        DedicatedServerProperties var0 = this.getProperties();
        return var0.enforceSecureProfile && var0.onlineMode && this.services.canValidateProfileKeys();
    }

    @Override
    public boolean logIPs() {
        return this.getProperties().logIPs;
    }

    protected boolean convertOldUsers() {
        int var0;
        boolean var1 = false;
        for (var0 = 0; !var1 && var0 <= 2; ++var0) {
            if (var0 > 0) {
                LOGGER.warn("Encountered a problem while converting the user banlist, retrying in a few seconds");
                this.waitForRetry();
            }
            var1 = NameReferencingFileConverter.convertUserBanlist(this);
        }
        boolean var2 = false;
        for (var0 = 0; !var2 && var0 <= 2; ++var0) {
            if (var0 > 0) {
                LOGGER.warn("Encountered a problem while converting the ip banlist, retrying in a few seconds");
                this.waitForRetry();
            }
            var2 = NameReferencingFileConverter.convertIpBanlist(this);
        }
        boolean var3 = false;
        for (var0 = 0; !var3 && var0 <= 2; ++var0) {
            if (var0 > 0) {
                LOGGER.warn("Encountered a problem while converting the op list, retrying in a few seconds");
                this.waitForRetry();
            }
            var3 = NameReferencingFileConverter.convertOpsList(this);
        }
        boolean var4 = false;
        for (var0 = 0; !var4 && var0 <= 2; ++var0) {
            if (var0 > 0) {
                LOGGER.warn("Encountered a problem while converting the whitelist, retrying in a few seconds");
                this.waitForRetry();
            }
            var4 = NameReferencingFileConverter.convertWhiteList(this);
        }
        boolean var5 = false;
        for (var0 = 0; !var5 && var0 <= 2; ++var0) {
            if (var0 > 0) {
                LOGGER.warn("Encountered a problem while converting the player save files, retrying in a few seconds");
                this.waitForRetry();
            }
            var5 = NameReferencingFileConverter.convertPlayers(this);
        }
        return var1 || var2 || var3 || var4 || var5;
    }

    private void waitForRetry() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException var0) {
            return;
        }
    }

    public long getMaxTickLength() {
        return this.getProperties().maxTickTime;
    }

    @Override
    public int getMaxChainedNeighborUpdates() {
        return this.getProperties().maxChainedNeighborUpdates;
    }

    @Override
    public String getPluginNames() {
        return "";
    }

    @Override
    public String runCommand(String var0) {
        this.rconConsoleSource.prepareForCommand();
        this.executeBlocking(() -> this.getCommands().performPrefixedCommand(this.rconConsoleSource.createCommandSourceStack(), var0));
        return this.rconConsoleSource.getCommandResponse();
    }

    @Override
    public void stopServer() {
        this.notificationManager().serverShuttingDown();
        super.stopServer();
        SystemUtils.shutdownExecutors();
    }

    @Override
    public boolean isSingleplayerOwner(NameAndId var0) {
        return false;
    }

    @Override
    public int getScaledTrackingDistance(int var0) {
        return this.entityBroadcastRangePercentage() * var0 / 100;
    }

    public int entityBroadcastRangePercentage() {
        return this.getProperties().entityBroadcastRangePercentage.get();
    }

    public void setEntityBroadcastRangePercentage(int var0) {
        this.settings.update(var1 -> (DedicatedServerProperties)var1.entityBroadcastRangePercentage.update(this.registryAccess(), var0));
    }

    @Override
    public String getLevelIdName() {
        return this.storageSource.getLevelId();
    }

    @Override
    public boolean forceSynchronousWrites() {
        return this.settings.getProperties().syncChunkWrites;
    }

    @Override
    public ITextFilter createTextFilterForPlayer(EntityPlayer var0) {
        if (this.serverTextFilter != null) {
            return this.serverTextFilter.createContext(var0.getGameProfile());
        }
        return ITextFilter.DUMMY;
    }

    @Override
    public @Nullable EnumGamemode getForcedGameType() {
        return this.forceGameMode() ? this.worldData.getGameType() : null;
    }

    public boolean forceGameMode() {
        return this.settings.getProperties().forceGameMode.get();
    }

    public void setForceGameMode(boolean var0) {
        this.settings.update(var1 -> (DedicatedServerProperties)var1.forceGameMode.update(this.registryAccess(), var0));
        this.enforceGameTypeForPlayers(this.getForcedGameType());
    }

    public EnumGamemode gameMode() {
        return this.getProperties().gameMode.get();
    }

    public void setGameMode(EnumGamemode var0) {
        this.settings.update(var1 -> (DedicatedServerProperties)var1.gameMode.update(this.registryAccess(), var0));
        this.worldData.setGameType(this.gameMode());
        this.enforceGameTypeForPlayers(this.getForcedGameType());
    }

    @Override
    public Optional<MinecraftServer.ServerResourcePackInfo> getServerResourcePack() {
        return this.settings.getProperties().serverResourcePackInfo;
    }

    @Override
    public void endMetricsRecordingTick() {
        super.endMetricsRecordingTick();
        this.isTickTimeLoggingEnabled = this.debugSubscribers().hasAnySubscriberFor(DebugSubscriptions.DEDICATED_SERVER_TICK_TIME);
    }

    @Override
    public SampleLogger getTickTimeLogger() {
        return this.tickTimeLogger;
    }

    @Override
    public boolean isTickTimeLoggingEnabled() {
        return this.isTickTimeLoggingEnabled;
    }

    @Override
    public boolean acceptsTransfers() {
        return this.settings.getProperties().acceptsTransfers.get();
    }

    public void setAcceptsTransfers(boolean var0) {
        this.settings.update(var1 -> (DedicatedServerProperties)var1.acceptsTransfers.update(this.registryAccess(), var0));
    }

    @Override
    public ServerLinks serverLinks() {
        return this.serverLinks;
    }

    @Override
    public int pauseWhenEmptySeconds() {
        return this.settings.getProperties().pauseWhenEmptySeconds.get();
    }

    public void setPauseWhenEmptySeconds(int var0) {
        this.settings.update(var1 -> (DedicatedServerProperties)var1.pauseWhenEmptySeconds.update(this.registryAccess(), var0));
    }

    private static ServerLinks createServerLinks(DedicatedServerSettings var02) {
        Optional<URI> var1 = DedicatedServer.parseBugReportLink(var02.getProperties());
        return var1.map(var0 -> new ServerLinks(List.of(ServerLinks.KnownLinkType.BUG_REPORT.create((URI)var0)))).orElse(ServerLinks.EMPTY);
    }

    private static Optional<URI> parseBugReportLink(DedicatedServerProperties var0) {
        String var1 = var0.bugReportLink;
        if (var1.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(SystemUtils.parseAndValidateUntrustedUri(var1));
        }
        catch (Exception var2) {
            LOGGER.warn("Failed to parse bug link {}", (Object)var1, (Object)var2);
            return Optional.empty();
        }
    }

    @Override
    public Map<String, String> getCodeOfConducts() {
        return this.codeOfConductTexts;
    }

    @Override
    public /* synthetic */ PlayerList getPlayerList() {
        return this.getPlayerList();
    }
}

