/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.internalapi;

import java.util.Collection;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.jsonrpc.JsonRpcLogger;
import net.minecraft.server.jsonrpc.internalapi.MinecraftBanListService;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.NameAndId;

public class MinecraftBanListServiceImpl
implements MinecraftBanListService {
    private final MinecraftServer server;
    private final JsonRpcLogger jsonrpcLogger;

    public MinecraftBanListServiceImpl(MinecraftServer var0, JsonRpcLogger var1) {
        this.server = var0;
        this.jsonrpcLogger = var1;
    }

    @Override
    public void addUserBan(GameProfileBanEntry var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Add player '{}' to banlist. Reason: '{}'", var0.getDisplayName(), var0.getReasonMessage().getString());
        this.server.getPlayerList().getBans().add(var0);
    }

    @Override
    public void removeUserBan(NameAndId var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Remove player '{}' from banlist", var0);
        this.server.getPlayerList().getBans().remove(var0);
    }

    @Override
    public void clearUserBans(ClientInfo var0) {
        this.server.getPlayerList().getBans().clear();
    }

    @Override
    public Collection<GameProfileBanEntry> getUserBanEntries() {
        return this.server.getPlayerList().getBans().getEntries();
    }

    @Override
    public Collection<IpBanEntry> getIpBanEntries() {
        return this.server.getPlayerList().getIpBans().getEntries();
    }

    @Override
    public void addIpBan(IpBanEntry var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Add ip '{}' to ban list", var0.getUser());
        this.server.getPlayerList().getIpBans().add(var0);
    }

    @Override
    public void clearIpBans(ClientInfo var0) {
        this.jsonrpcLogger.log(var0, "Clear ip ban list", new Object[0]);
        this.server.getPlayerList().getIpBans().clear();
    }

    @Override
    public void removeIpBan(String var0, ClientInfo var1) {
        this.jsonrpcLogger.log(var1, "Remove ip '{}' from ban list", var0);
        this.server.getPlayerList().getIpBans().remove(var0);
    }
}

