/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.jsonrpc.api.PlayerDto;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SystemUtils;
import org.jspecify.annotations.Nullable;

public class BanlistService {
    private static final String BAN_SOURCE = "Management server";

    public static List<b> get(MinecraftApi var02) {
        return var02.banListService().getUserBanEntries().stream().filter(var0 -> var0.getUser() != null).map(a::from).map(b::from).toList();
    }

    public static List<b> add(MinecraftApi var0, List<b> var1, ClientInfo var2) {
        List<CompletableFuture> var3 = var1.stream().map(var12 -> var0.playerListService().getUser(var12.player().id(), var12.player().name()).thenApply(var1 -> var1.map(var12::toUserBan))).toList();
        for (Optional var5 : SystemUtils.sequence(var3).join()) {
            if (var5.isEmpty()) continue;
            a var6 = (a)var5.get();
            var0.banListService().addUserBan(var6.toBanEntry(), var2);
            EntityPlayer var7 = var0.playerListService().getPlayer(((a)var5.get()).player().id());
            if (var7 == null) continue;
            var7.connection.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.banned"));
        }
        return BanlistService.get(var0);
    }

    public static List<b> clear(MinecraftApi var0, ClientInfo var1) {
        var0.banListService().clearUserBans(var1);
        return BanlistService.get(var0);
    }

    public static List<b> remove(MinecraftApi var0, List<PlayerDto> var12, ClientInfo var2) {
        List<CompletableFuture> var3 = var12.stream().map(var1 -> var0.playerListService().getUser(var1.id(), var1.name())).toList();
        for (Optional var5 : SystemUtils.sequence(var3).join()) {
            if (var5.isEmpty()) continue;
            var0.banListService().removeUserBan((NameAndId)var5.get(), var2);
        }
        return BanlistService.get(var0);
    }

    public static List<b> set(MinecraftApi var02, List<b> var13, ClientInfo var22) {
        List<CompletableFuture> var3 = var13.stream().map(var12 -> var02.playerListService().getUser(var12.player().id(), var12.player().name()).thenApply(var1 -> var1.map(var12::toUserBan))).toList();
        Set var4 = SystemUtils.sequence(var3).join().stream().flatMap(Optional::stream).collect(Collectors.toSet());
        Set var5 = var02.banListService().getUserBanEntries().stream().filter(var0 -> var0.getUser() != null).map(a::from).collect(Collectors.toSet());
        var5.stream().filter(var1 -> !var4.contains(var1)).forEach(var2 -> var02.banListService().removeUserBan(var2.player(), var22));
        var4.stream().filter(var1 -> !var5.contains(var1)).forEach(var2 -> {
            var02.banListService().addUserBan(var2.toBanEntry(), var22);
            EntityPlayer var3 = var02.playerListService().getPlayer(var2.player().id());
            if (var3 != null) {
                var3.connection.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.banned"));
            }
        });
        return BanlistService.get(var02);
    }

    record a(NameAndId player, @Nullable String reason, String source, Optional<Instant> expires) {
        static a from(GameProfileBanEntry var0) {
            return new a(Objects.requireNonNull((NameAndId)var0.getUser()), var0.getReason(), var0.getSource(), Optional.ofNullable(var0.getExpires()).map(Date::toInstant));
        }

        GameProfileBanEntry toBanEntry() {
            return new GameProfileBanEntry(new NameAndId(this.player().id(), this.player().name()), null, this.source(), (Date)this.expires().map(Date::from).orElse(null), this.reason());
        }
    }

    public record b(PlayerDto player, Optional<String> reason, Optional<String> source, Optional<Instant> expires) {
        public static final MapCodec<b> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)PlayerDto.CODEC.codec().fieldOf("player").forGetter(b::player), (App)Codec.STRING.optionalFieldOf("reason").forGetter(b::reason), (App)Codec.STRING.optionalFieldOf("source").forGetter(b::source), (App)ExtraCodecs.INSTANT_ISO8601.optionalFieldOf("expires").forGetter(b::expires)).apply((Applicative)var0, b::new));

        private static b from(a var0) {
            return new b(PlayerDto.from(var0.player()), Optional.ofNullable(var0.reason()), Optional.of(var0.source()), var0.expires());
        }

        public static b from(GameProfileBanEntry var0) {
            return b.from(a.from(var0));
        }

        private a toUserBan(NameAndId var0) {
            return new a(var0, this.reason().orElse(null), this.source().orElse(BanlistService.BAN_SOURCE), this.expires());
        }
    }
}

