/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import com.google.common.net.InetAddresses;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.jsonrpc.api.PlayerDto;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.util.ExtraCodecs;
import org.jspecify.annotations.Nullable;

public class IpBanlistService {
    private static final String BAN_SOURCE = "Management server";

    public static List<c> get(MinecraftApi var0) {
        return var0.banListService().getIpBanEntries().stream().map(b::from).map(c::from).toList();
    }

    public static List<c> add(MinecraftApi var02, List<a> var1, ClientInfo var22) {
        var1.stream().map(var2 -> IpBanlistService.banIp(var02, var2, var22)).flatMap(Collection::stream).forEach(var0 -> var0.connection.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.ip_banned")));
        return IpBanlistService.get(var02);
    }

    private static List<EntityPlayer> banIp(MinecraftApi var0, a var1, ClientInfo var2) {
        Optional<EntityPlayer> var4;
        b var3 = var1.toIpBan();
        if (var3 != null) {
            return IpBanlistService.banIp(var0, var3, var2);
        }
        if (var1.player().isPresent() && (var4 = var0.playerListService().getPlayer(var1.player().get().id(), var1.player().get().name())).isPresent()) {
            return IpBanlistService.banIp(var0, var1.toIpBan(var4.get()), var2);
        }
        return List.of();
    }

    private static List<EntityPlayer> banIp(MinecraftApi var0, b var1, ClientInfo var2) {
        var0.banListService().addIpBan(var1.toIpBanEntry(), var2);
        return var0.playerListService().getPlayersWithAddress(var1.ip());
    }

    public static List<c> clear(MinecraftApi var0, ClientInfo var1) {
        var0.banListService().clearIpBans(var1);
        return IpBanlistService.get(var0);
    }

    public static List<c> remove(MinecraftApi var0, List<String> var1, ClientInfo var22) {
        var1.forEach(var2 -> var0.banListService().removeIpBan((String)var2, var22));
        return IpBanlistService.get(var0);
    }

    public static List<c> set(MinecraftApi var02, List<c> var12, ClientInfo var22) {
        Set var3 = var12.stream().filter(var0 -> InetAddresses.isInetAddress((String)var0.ip())).map(c::toIpBan).collect(Collectors.toSet());
        Set var4 = var02.banListService().getIpBanEntries().stream().map(b::from).collect(Collectors.toSet());
        var4.stream().filter(var1 -> !var3.contains(var1)).forEach(var2 -> var02.banListService().removeIpBan(var2.ip(), var22));
        var3.stream().filter(var1 -> !var4.contains(var1)).forEach(var2 -> var02.banListService().addIpBan(var2.toIpBanEntry(), var22));
        var3.stream().filter(var1 -> !var4.contains(var1)).flatMap(var1 -> var02.playerListService().getPlayersWithAddress(var1.ip()).stream()).forEach(var0 -> var0.connection.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.ip_banned")));
        return IpBanlistService.get(var02);
    }

    public record a(Optional<PlayerDto> player, Optional<String> ip, Optional<String> reason, Optional<String> source, Optional<Instant> expires) {
        public static final MapCodec<a> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)PlayerDto.CODEC.codec().optionalFieldOf("player").forGetter(a::player), (App)Codec.STRING.optionalFieldOf("ip").forGetter(a::ip), (App)Codec.STRING.optionalFieldOf("reason").forGetter(a::reason), (App)Codec.STRING.optionalFieldOf("source").forGetter(a::source), (App)ExtraCodecs.INSTANT_ISO8601.optionalFieldOf("expires").forGetter(a::expires)).apply((Applicative)var0, a::new));

        b toIpBan(EntityPlayer var0) {
            return new b(var0.getIpAddress(), this.reason().orElse(null), this.source().orElse(IpBanlistService.BAN_SOURCE), this.expires());
        }

        @Nullable b toIpBan() {
            if (this.ip().isEmpty() || !InetAddresses.isInetAddress((String)this.ip().get())) {
                return null;
            }
            return new b(this.ip().get(), this.reason().orElse(null), this.source().orElse(IpBanlistService.BAN_SOURCE), this.expires());
        }
    }

    record b(String ip, @Nullable String reason, String source, Optional<Instant> expires) {
        static b from(IpBanEntry var0) {
            return new b(Objects.requireNonNull((String)var0.getUser()), var0.getReason(), var0.getSource(), Optional.ofNullable(var0.getExpires()).map(Date::toInstant));
        }

        IpBanEntry toIpBanEntry() {
            return new IpBanEntry(this.ip(), null, this.source(), (Date)this.expires().map(Date::from).orElse(null), this.reason());
        }
    }

    public record c(String ip, Optional<String> reason, Optional<String> source, Optional<Instant> expires) {
        public static final MapCodec<c> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.STRING.fieldOf("ip").forGetter(c::ip), (App)Codec.STRING.optionalFieldOf("reason").forGetter(c::reason), (App)Codec.STRING.optionalFieldOf("source").forGetter(c::source), (App)ExtraCodecs.INSTANT_ISO8601.optionalFieldOf("expires").forGetter(c::expires)).apply((Applicative)var0, c::new));

        private static c from(b var0) {
            return new c(var0.ip(), Optional.ofNullable(var0.reason()), Optional.of(var0.source()), var0.expires());
        }

        public static c from(IpBanEntry var0) {
            return c.from(b.from(var0));
        }

        private b toIpBan() {
            return new b(this.ip(), this.reason().orElse(null), this.source().orElse(IpBanlistService.BAN_SOURCE), this.expires());
        }
    }
}

