/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.security;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Set;
import net.minecraft.server.jsonrpc.security.SecurityConfig;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

@ChannelHandler.Sharable
public class AuthenticationHandler
extends ChannelDuplexHandler {
    private final Logger LOGGER = LogUtils.getLogger();
    private static final AttributeKey<Boolean> AUTHENTICATED_KEY = AttributeKey.valueOf((String)"authenticated");
    private static final AttributeKey<Boolean> ATTR_WEBSOCKET_ALLOWED = AttributeKey.valueOf((String)"websocket_auth_allowed");
    private static final String SUBPROTOCOL_VALUE = "minecraft-v1";
    private static final String SUBPROTOCOL_HEADER_PREFIX = "minecraft-v1,";
    public static final String BEARER_PREFIX = "Bearer ";
    private final SecurityConfig securityConfig;
    private final Set<String> allowedOrigins;

    public AuthenticationHandler(SecurityConfig var0, String var1) {
        this.securityConfig = var0;
        this.allowedOrigins = Sets.newHashSet((Object[])var1.split(","));
    }

    public void channelRead(ChannelHandlerContext var0, Object var1) throws Exception {
        Object var3;
        String var2 = this.getClientIp(var0);
        if (var1 instanceof HttpRequest) {
            var3 = (HttpRequest)var1;
            a var4 = this.performSecurityChecks((HttpRequest)var3);
            if (var4.isAllowed()) {
                var0.channel().attr(AUTHENTICATED_KEY).set((Object)true);
                if (var4.isTokenSentInSecWebsocketProtocol()) {
                    var0.channel().attr(ATTR_WEBSOCKET_ALLOWED).set((Object)Boolean.TRUE);
                }
            } else {
                this.LOGGER.debug("Authentication rejected for connection with ip {}: {}", (Object)var2, (Object)var4.getReason());
                var0.channel().attr(AUTHENTICATED_KEY).set((Object)false);
                this.sendUnauthorizedResponse(var0, var4.getReason());
                return;
            }
        }
        if (Boolean.TRUE.equals(var3 = (Boolean)var0.channel().attr(AUTHENTICATED_KEY).get())) {
            super.channelRead(var0, var1);
        } else {
            this.LOGGER.debug("Dropping unauthenticated connection with ip {}", (Object)var2);
            var0.close();
        }
    }

    public void write(ChannelHandlerContext var0, Object var1, ChannelPromise var2) throws Exception {
        HttpResponse var3;
        if (var1 instanceof HttpResponse && (var3 = (HttpResponse)var1).status().code() == HttpResponseStatus.SWITCHING_PROTOCOLS.code() && var0.channel().attr(ATTR_WEBSOCKET_ALLOWED).get() != null && ((Boolean)var0.channel().attr(ATTR_WEBSOCKET_ALLOWED).get()).equals(Boolean.TRUE)) {
            var3.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)SUBPROTOCOL_VALUE);
        }
        super.write(var0, var1, var2);
    }

    private a performSecurityChecks(HttpRequest var0) {
        String var1 = this.parseTokenInAuthorizationHeader(var0);
        if (var1 != null) {
            if (this.isValidApiKey(var1)) {
                return a.allowed();
            }
            return a.denied("Invalid API key");
        }
        String var2 = this.parseTokenInSecWebsocketProtocolHeader(var0);
        if (var2 != null) {
            if (!this.isAllowedOriginHeader(var0)) {
                return a.denied("Origin Not Allowed");
            }
            if (this.isValidApiKey(var2)) {
                return a.allowed(true);
            }
            return a.denied("Invalid API key");
        }
        return a.denied("Missing API key");
    }

    private boolean isAllowedOriginHeader(HttpRequest var0) {
        String var1 = var0.headers().get((CharSequence)HttpHeaderNames.ORIGIN);
        if (var1 == null || var1.isEmpty()) {
            return false;
        }
        return this.allowedOrigins.contains(var1);
    }

    private @Nullable String parseTokenInAuthorizationHeader(HttpRequest var0) {
        String var1 = var0.headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION);
        if (var1 != null && var1.startsWith(BEARER_PREFIX)) {
            return var1.substring(BEARER_PREFIX.length()).trim();
        }
        return null;
    }

    private @Nullable String parseTokenInSecWebsocketProtocolHeader(HttpRequest var0) {
        String var1 = var0.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        if (var1 != null && var1.startsWith(SUBPROTOCOL_HEADER_PREFIX)) {
            return var1.substring(SUBPROTOCOL_HEADER_PREFIX.length()).trim();
        }
        return null;
    }

    public boolean isValidApiKey(String var0) {
        if (var0.isEmpty()) {
            return false;
        }
        byte[] var1 = var0.getBytes(StandardCharsets.UTF_8);
        byte[] var2 = this.securityConfig.secretKey().getBytes(StandardCharsets.UTF_8);
        return MessageDigest.isEqual(var1, var2);
    }

    private String getClientIp(ChannelHandlerContext var0) {
        InetSocketAddress var1 = (InetSocketAddress)var0.channel().remoteAddress();
        return var1.getAddress().getHostAddress();
    }

    private void sendUnauthorizedResponse(ChannelHandlerContext var0, String var12) {
        String var2 = "{\"error\":\"Unauthorized\",\"message\":\"" + var12 + "\"}";
        byte[] var3 = var2.getBytes(StandardCharsets.UTF_8);
        DefaultFullHttpResponse var4 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED, Unpooled.wrappedBuffer((byte[])var3));
        var4.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
        var4.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)var3.length);
        var4.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        var0.writeAndFlush((Object)var4).addListener(var1 -> var0.close());
    }

    static class a {
        private final boolean allowed;
        private final String reason;
        private final boolean tokenSentInSecWebsocketProtocol;

        private a(boolean var0, String var1, boolean var2) {
            this.allowed = var0;
            this.reason = var1;
            this.tokenSentInSecWebsocketProtocol = var2;
        }

        public static a allowed() {
            return new a(true, null, false);
        }

        public static a allowed(boolean var0) {
            return new a(true, null, var0);
        }

        public static a denied(String var0) {
            return new a(false, var0, false);
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public String getReason() {
            return this.reason;
        }

        public boolean isTokenSentInSecWebsocketProtocol() {
            return this.tokenSentInSecWebsocketProtocol;
        }
    }
}

