/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMaps;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongConsumer;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.SharedConstants;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.LoadingChunkTracker;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.SimulationChunkTracker;
import net.minecraft.server.level.ThrottlingChunkTaskDispatcher;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.TriState;
import net.minecraft.util.thread.TaskScheduler;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.chunk.Chunk;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class ChunkMapDistance {
    private static final Logger LOGGER = LogUtils.getLogger();
    static final int PLAYER_TICKET_LEVEL = ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING);
    final Long2ObjectMap<ObjectSet<EntityPlayer>> playersPerChunk = new Long2ObjectOpenHashMap();
    private final LoadingChunkTracker loadingChunkTracker;
    private final SimulationChunkTracker simulationChunkTracker;
    final TicketStorage ticketStorage;
    private final a naturalSpawnChunkCounter = new a(8);
    private final b playerTicketManager = new b(32);
    protected final Set<PlayerChunk> chunksToUpdateFutures = new ReferenceOpenHashSet();
    final ThrottlingChunkTaskDispatcher ticketDispatcher;
    final LongSet ticketsToRelease = new LongOpenHashSet();
    final Executor mainThreadExecutor;
    public int simulationDistance = 10;

    protected ChunkMapDistance(TicketStorage var0, Executor var1, Executor var2) {
        this.ticketStorage = var0;
        this.loadingChunkTracker = new LoadingChunkTracker(this, var0);
        this.simulationChunkTracker = new SimulationChunkTracker(var0);
        TaskScheduler<Runnable> var3 = TaskScheduler.wrapExecutor("player ticket throttler", var2);
        this.ticketDispatcher = new ThrottlingChunkTaskDispatcher(var3, var1, 4);
        this.mainThreadExecutor = var2;
    }

    protected abstract boolean isChunkToRemove(long var1);

    protected abstract @Nullable PlayerChunk getChunk(long var1);

    protected abstract @Nullable PlayerChunk updateChunkScheduling(long var1, int var3, @Nullable PlayerChunk var4, int var5);

    public boolean runAllUpdates(PlayerChunkMap var02) {
        boolean var22;
        this.naturalSpawnChunkCounter.runAllUpdates();
        this.simulationChunkTracker.runAllUpdates();
        this.playerTicketManager.runAllUpdates();
        int var1 = Integer.MAX_VALUE - this.loadingChunkTracker.runDistanceUpdates(Integer.MAX_VALUE);
        boolean bl = var22 = var1 != 0;
        if (var22 && SharedConstants.DEBUG_VERBOSE_SERVER_EVENTS) {
            LOGGER.debug("DMU {}", (Object)var1);
        }
        if (!this.chunksToUpdateFutures.isEmpty()) {
            for (PlayerChunk var4 : this.chunksToUpdateFutures) {
                var4.updateHighestAllowedStatus(var02);
            }
            for (PlayerChunk var4 : this.chunksToUpdateFutures) {
                var4.updateFutures(var02, this.mainThreadExecutor);
            }
            this.chunksToUpdateFutures.clear();
            return true;
        }
        if (!this.ticketsToRelease.isEmpty()) {
            LongIterator var3 = this.ticketsToRelease.iterator();
            while (var3.hasNext()) {
                long var4 = var3.nextLong();
                if (!this.ticketStorage.getTickets(var4).stream().anyMatch(var0 -> var0.getType() == TicketType.PLAYER_LOADING)) continue;
                PlayerChunk var6 = var02.getUpdatingChunkIfPresent(var4);
                if (var6 == null) {
                    throw new IllegalStateException();
                }
                CompletableFuture<ChunkResult<Chunk>> var7 = var6.getEntityTickingChunkFuture();
                var7.thenAccept(var2 -> this.mainThreadExecutor.execute(() -> this.ticketDispatcher.release(var4, () -> {}, false)));
            }
            this.ticketsToRelease.clear();
        }
        return var22;
    }

    public void addPlayer(SectionPosition var02, EntityPlayer var1) {
        ChunkCoordIntPair var2 = var02.chunk();
        long var3 = var2.toLong();
        ((ObjectSet)this.playersPerChunk.computeIfAbsent(var3, var0 -> new ObjectOpenHashSet())).add((Object)var1);
        this.naturalSpawnChunkCounter.update(var3, 0, true);
        this.playerTicketManager.update(var3, 0, true);
        this.ticketStorage.addTicket(new Ticket(TicketType.PLAYER_SIMULATION, this.getPlayerTicketLevel()), var2);
    }

    public void removePlayer(SectionPosition var0, EntityPlayer var1) {
        ChunkCoordIntPair var2 = var0.chunk();
        long var3 = var2.toLong();
        ObjectSet var5 = (ObjectSet)this.playersPerChunk.get(var3);
        var5.remove((Object)var1);
        if (var5.isEmpty()) {
            this.playersPerChunk.remove(var3);
            this.naturalSpawnChunkCounter.update(var3, Integer.MAX_VALUE, false);
            this.playerTicketManager.update(var3, Integer.MAX_VALUE, false);
            this.ticketStorage.removeTicket(new Ticket(TicketType.PLAYER_SIMULATION, this.getPlayerTicketLevel()), var2);
        }
    }

    private int getPlayerTicketLevel() {
        return Math.max(0, ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING) - this.simulationDistance);
    }

    public boolean inEntityTickingRange(long var0) {
        return ChunkLevel.isEntityTicking(this.simulationChunkTracker.getLevel(var0));
    }

    public boolean inBlockTickingRange(long var0) {
        return ChunkLevel.isBlockTicking(this.simulationChunkTracker.getLevel(var0));
    }

    public int getChunkLevel(long var0, boolean var2) {
        if (var2) {
            return this.simulationChunkTracker.getLevel(var0);
        }
        return this.loadingChunkTracker.getLevel(var0);
    }

    protected void updatePlayerTickets(int var0) {
        this.playerTicketManager.updateViewDistance(var0);
    }

    public void updateSimulationDistance(int var0) {
        if (var0 != this.simulationDistance) {
            this.simulationDistance = var0;
            this.ticketStorage.replaceTicketLevelOfType(this.getPlayerTicketLevel(), TicketType.PLAYER_SIMULATION);
        }
    }

    public int getNaturalSpawnChunkCount() {
        this.naturalSpawnChunkCounter.runAllUpdates();
        return this.naturalSpawnChunkCounter.chunks.size();
    }

    public TriState hasPlayersNearby(long var0) {
        this.naturalSpawnChunkCounter.runAllUpdates();
        int var2 = this.naturalSpawnChunkCounter.getLevel(var0);
        if (var2 <= SpawnerCreature.INSCRIBED_SQUARE_SPAWN_DISTANCE_CHUNK) {
            return TriState.TRUE;
        }
        if (var2 > 8) {
            return TriState.FALSE;
        }
        return TriState.DEFAULT;
    }

    public void forEachEntityTickingChunk(LongConsumer var0) {
        for (Long2ByteMap.Entry var2 : Long2ByteMaps.fastIterable((Long2ByteMap)this.simulationChunkTracker.chunks)) {
            byte var3 = var2.getByteValue();
            long var4 = var2.getLongKey();
            if (!ChunkLevel.isEntityTicking(var3)) continue;
            var0.accept(var4);
        }
    }

    public LongIterator getSpawnCandidateChunks() {
        this.naturalSpawnChunkCounter.runAllUpdates();
        return this.naturalSpawnChunkCounter.chunks.keySet().iterator();
    }

    public String getDebugStatus() {
        return this.ticketDispatcher.getDebugStatus();
    }

    public boolean hasTickets() {
        return this.ticketStorage.hasTickets();
    }

    class a
    extends ChunkMap {
        protected final Long2ByteMap chunks;
        protected final int maxDistance;

        protected a(int var1) {
            super(var1 + 2, 16, 256);
            this.chunks = new Long2ByteOpenHashMap();
            this.maxDistance = var1;
            this.chunks.defaultReturnValue((byte)(var1 + 2));
        }

        @Override
        protected int getLevel(long var0) {
            return this.chunks.get(var0);
        }

        @Override
        protected void setLevel(long var0, int var2) {
            byte var3 = var2 > this.maxDistance ? this.chunks.remove(var0) : this.chunks.put(var0, (byte)var2);
            this.onLevelChange(var0, var3, var2);
        }

        protected void onLevelChange(long var0, int var2, int var3) {
        }

        @Override
        protected int getLevelFromSource(long var0) {
            return this.havePlayer(var0) ? 0 : Integer.MAX_VALUE;
        }

        private boolean havePlayer(long var0) {
            ObjectSet var2 = (ObjectSet)ChunkMapDistance.this.playersPerChunk.get(var0);
            return var2 != null && !var2.isEmpty();
        }

        public void runAllUpdates() {
            this.runUpdates(Integer.MAX_VALUE);
        }
    }

    class b
    extends a {
        private int viewDistance;
        private final Long2IntMap queueLevels;
        private final LongSet toUpdate;

        protected b(int var1) {
            super(var1);
            this.queueLevels = Long2IntMaps.synchronize((Long2IntMap)new Long2IntOpenHashMap());
            this.toUpdate = new LongOpenHashSet();
            this.viewDistance = 0;
            this.queueLevels.defaultReturnValue(var1 + 2);
        }

        @Override
        protected void onLevelChange(long var0, int var2, int var3) {
            this.toUpdate.add(var0);
        }

        public void updateViewDistance(int var0) {
            for (Long2ByteMap.Entry var2 : this.chunks.long2ByteEntrySet()) {
                byte var3 = var2.getByteValue();
                long var4 = var2.getLongKey();
                this.onLevelChange(var4, var3, this.haveTicketFor(var3), var3 <= var0);
            }
            this.viewDistance = var0;
        }

        private void onLevelChange(long var0, int var2, boolean var3, boolean var4) {
            if (var3 != var4) {
                Ticket var5 = new Ticket(TicketType.PLAYER_LOADING, PLAYER_TICKET_LEVEL);
                if (var4) {
                    ChunkMapDistance.this.ticketDispatcher.submit(() -> ChunkMapDistance.this.mainThreadExecutor.execute(() -> {
                        if (this.haveTicketFor(this.getLevel(var0))) {
                            ChunkMapDistance.this.ticketStorage.addTicket(var0, var5);
                            ChunkMapDistance.this.ticketsToRelease.add(var0);
                        } else {
                            ChunkMapDistance.this.ticketDispatcher.release(var0, () -> {}, false);
                        }
                    }), var0, () -> var2);
                } else {
                    ChunkMapDistance.this.ticketDispatcher.release(var0, () -> ChunkMapDistance.this.mainThreadExecutor.execute(() -> ChunkMapDistance.this.ticketStorage.removeTicket(var0, var5)), true);
                }
            }
        }

        @Override
        public void runAllUpdates() {
            super.runAllUpdates();
            if (!this.toUpdate.isEmpty()) {
                LongIterator var0 = this.toUpdate.iterator();
                while (var0.hasNext()) {
                    int var4;
                    long var1 = var0.nextLong();
                    int var3 = this.queueLevels.get(var1);
                    if (var3 == (var4 = this.getLevel(var1))) continue;
                    ChunkMapDistance.this.ticketDispatcher.onLevelChange(new ChunkCoordIntPair(var1), () -> this.queueLevels.get(var1), var4, var2 -> {
                        if (var2 >= this.queueLevels.defaultReturnValue()) {
                            this.queueLevels.remove(var1);
                        } else {
                            this.queueLevels.put(var1, var2);
                        }
                    });
                    this.onLevelChange(var1, var4, this.haveTicketFor(var3), this.haveTicketFor(var4));
                }
                this.toUpdate.clear();
            }
        }

        private boolean haveTicketFor(int var0) {
            return var0 <= this.viewDistance;
        }
    }
}

