/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerTextFilter;
import net.minecraft.util.ChatDeserializer;
import org.jspecify.annotations.Nullable;

public class LegacyTextFilter
extends ServerTextFilter {
    private static final String ENDPOINT = "v1/chat";
    final URL joinEndpoint;
    final a joinEncoder;
    final URL leaveEndpoint;
    final a leaveEncoder;
    private final String authKey;

    private LegacyTextFilter(URL var0, ServerTextFilter.b var1, URL var2, a var3, URL var4, a var5, String var6, ServerTextFilter.a var7, ExecutorService var8) {
        super(var0, var1, var7, var8);
        this.joinEndpoint = var2;
        this.joinEncoder = var3;
        this.leaveEndpoint = var4;
        this.leaveEncoder = var5;
        this.authKey = var6;
    }

    public static @Nullable ServerTextFilter createTextFilterFromConfig(String var0) {
        try {
            Object var17;
            ServerTextFilter.b var16;
            JsonObject var1 = ChatDeserializer.parse(var0);
            URI var22 = new URI(ChatDeserializer.getAsString(var1, "apiServer"));
            String var32 = ChatDeserializer.getAsString(var1, "apiKey");
            if (var32.isEmpty()) {
                throw new IllegalArgumentException("Missing API key");
            }
            int var42 = ChatDeserializer.getAsInt(var1, "ruleId", 1);
            String var5 = ChatDeserializer.getAsString(var1, "serverId", "");
            String var6 = ChatDeserializer.getAsString(var1, "roomId", "Java:Chat");
            int var7 = ChatDeserializer.getAsInt(var1, "hashesToDrop", -1);
            int var8 = ChatDeserializer.getAsInt(var1, "maxConcurrentRequests", 7);
            JsonObject var9 = ChatDeserializer.getAsJsonObject(var1, "endpoints", null);
            String var10 = LegacyTextFilter.getEndpointFromConfig(var9, "chat", ENDPOINT);
            boolean var11 = var10.equals(ENDPOINT);
            URL var12 = var22.resolve("/" + var10).toURL();
            URL var13 = LegacyTextFilter.getEndpoint(var22, var9, "join", "v1/join");
            URL var14 = LegacyTextFilter.getEndpoint(var22, var9, "leave", "v1/leave");
            a var15 = var2 -> {
                JsonObject var3 = new JsonObject();
                var3.addProperty("server", var5);
                var3.addProperty("room", var6);
                var3.addProperty("user_id", var2.id().toString());
                var3.addProperty("user_display_name", var2.name());
                return var3;
            };
            if (var11) {
                var16 = (var3, var4) -> {
                    JsonObject var5 = new JsonObject();
                    var5.addProperty("rule", (Number)var42);
                    var5.addProperty("server", var5);
                    var5.addProperty("room", var6);
                    var5.addProperty("player", var3.id().toString());
                    var5.addProperty("player_display_name", var3.name());
                    var5.addProperty("text", var4);
                    var5.addProperty("language", "*");
                    return var5;
                };
            } else {
                var17 = String.valueOf(var42);
                var16 = (arg_0, arg_1) -> LegacyTextFilter.a((String)var17, var5, var6, arg_0, arg_1);
            }
            var17 = ServerTextFilter.a.select(var7);
            ExecutorService var18 = LegacyTextFilter.createWorkerPool(var8);
            String var19 = Base64.getEncoder().encodeToString(var32.getBytes(StandardCharsets.US_ASCII));
            return new LegacyTextFilter(var12, var16, var13, var15, var14, var15, var19, (ServerTextFilter.a)var17, var18);
        }
        catch (Exception var1) {
            LOGGER.warn("Failed to parse chat filter config {}", (Object)var0, (Object)var1);
            return null;
        }
    }

    @Override
    public ITextFilter createContext(GameProfile var0) {
        return new ServerTextFilter.c(var0){

            @Override
            public void join() {
                LegacyTextFilter.this.processJoinOrLeave(this.profile, LegacyTextFilter.this.joinEndpoint, LegacyTextFilter.this.joinEncoder, this.streamExecutor);
            }

            @Override
            public void leave() {
                LegacyTextFilter.this.processJoinOrLeave(this.profile, LegacyTextFilter.this.leaveEndpoint, LegacyTextFilter.this.leaveEncoder, this.streamExecutor);
            }
        };
    }

    void processJoinOrLeave(GameProfile var0, URL var1, a var2, Executor var3) {
        var3.execute(() -> {
            JsonObject var3 = var2.encode(var0);
            try {
                this.processRequest(var3, var1);
            }
            catch (Exception var4) {
                LOGGER.warn("Failed to send join/leave packet to {} for player {}", new Object[]{var1, var0, var4});
            }
        });
    }

    private void processRequest(JsonObject var0, URL var1) throws IOException {
        HttpURLConnection var2 = this.makeRequest(var0, var1);
        try (InputStream var3 = var2.getInputStream();){
            this.drainStream(var3);
        }
    }

    @Override
    protected void setAuthorizationProperty(HttpURLConnection var0) {
        var0.setRequestProperty("Authorization", "Basic " + this.authKey);
    }

    @Override
    protected FilteredText filterText(String var0, ServerTextFilter.a var1, JsonObject var2) {
        boolean var3 = ChatDeserializer.getAsBoolean(var2, "response", false);
        if (var3) {
            return FilteredText.passThrough(var0);
        }
        String var4 = ChatDeserializer.getAsString(var2, "hashed", null);
        if (var4 == null) {
            return FilteredText.fullyFiltered(var0);
        }
        JsonArray var5 = ChatDeserializer.getAsJsonArray(var2, "hashes");
        FilterMask var6 = this.parseMask(var0, var5, var1);
        return new FilteredText(var0, var6);
    }

    private static /* synthetic */ JsonObject a(String var0, String var1, String var2, GameProfile var3, String var4) {
        JsonObject var5 = new JsonObject();
        var5.addProperty("rule_id", var0);
        var5.addProperty("category", var1);
        var5.addProperty("subcategory", var2);
        var5.addProperty("user_id", var3.id().toString());
        var5.addProperty("user_display_name", var3.name());
        var5.addProperty("text", var4);
        var5.addProperty("language", "*");
        return var5;
    }

    @FunctionalInterface
    static interface a {
        public JsonObject encode(GameProfile var1);
    }
}

