/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCertificate;
import com.microsoft.aad.msal4j.IClientCredential;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ServerTextFilter;
import net.minecraft.util.ChatDeserializer;
import org.jspecify.annotations.Nullable;

public class PlayerSafetyServiceTextFilter
extends ServerTextFilter {
    private final ConfidentialClientApplication client;
    private final ClientCredentialParameters clientParameters;
    private final Set<String> fullyFilteredEvents;
    private final int connectionReadTimeoutMs;

    private PlayerSafetyServiceTextFilter(URL var0, ServerTextFilter.b var1, ServerTextFilter.a var2, ExecutorService var3, ConfidentialClientApplication var4, ClientCredentialParameters var5, Set<String> var6, int var7) {
        super(var0, var1, var2, var3);
        this.client = var4;
        this.clientParameters = var5;
        this.fullyFilteredEvents = var6;
        this.connectionReadTimeoutMs = var7;
    }

    public static @Nullable ServerTextFilter createTextFilterFromConfig(String var0) {
        IClientCertificate var20;
        InputStream var21;
        URL var16;
        JsonObject var12 = ChatDeserializer.parse(var0);
        URI var22 = URI.create(ChatDeserializer.getAsString(var12, "apiServer"));
        String var32 = ChatDeserializer.getAsString(var12, "apiPath");
        String var4 = ChatDeserializer.getAsString(var12, "scope");
        String var5 = ChatDeserializer.getAsString(var12, "serverId", "");
        String var6 = ChatDeserializer.getAsString(var12, "applicationId");
        String var7 = ChatDeserializer.getAsString(var12, "tenantId");
        String var8 = ChatDeserializer.getAsString(var12, "roomId", "Java:Chat");
        String var9 = ChatDeserializer.getAsString(var12, "certificatePath");
        String var10 = ChatDeserializer.getAsString(var12, "certificatePassword", "");
        int var11 = ChatDeserializer.getAsInt(var12, "hashesToDrop", -1);
        int var122 = ChatDeserializer.getAsInt(var12, "maxConcurrentRequests", 7);
        JsonArray var13 = ChatDeserializer.getAsJsonArray(var12, "fullyFilteredEvents");
        HashSet<String> var14 = new HashSet<String>();
        var13.forEach(var1 -> var14.add(ChatDeserializer.convertToString(var1, "filteredEvent")));
        int var15 = ChatDeserializer.getAsInt(var12, "connectionReadTimeoutMs", 2000);
        try {
            var16 = var22.resolve(var32).toURL();
        }
        catch (MalformedURLException var17) {
            throw new RuntimeException(var17);
        }
        ServerTextFilter.b var17 = (var2, var3) -> {
            JsonObject var4 = new JsonObject();
            var4.addProperty("userId", var2.id().toString());
            var4.addProperty("userDisplayName", var2.name());
            var4.addProperty("server", var5);
            var4.addProperty("room", var8);
            var4.addProperty("area", "JavaChatRealms");
            var4.addProperty("data", var3);
            var4.addProperty("language", "*");
            return var4;
        };
        ServerTextFilter.a var18 = ServerTextFilter.a.select(var11);
        ExecutorService var19 = PlayerSafetyServiceTextFilter.createWorkerPool(var122);
        try {
            var21 = Files.newInputStream(Path.of(var9, new String[0]), new OpenOption[0]);
            try {
                var20 = ClientCredentialFactory.createFromCertificate((InputStream)var21, (String)var10);
            }
            finally {
                if (var21 != null) {
                    var21.close();
                }
            }
        }
        catch (Exception var212) {
            LOGGER.warn("Failed to open certificate file");
            return null;
        }
        try {
            var21 = ((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)var6, (IClientCredential)var20).sendX5c(true).executorService(var19)).authority(String.format(Locale.ROOT, "https://login.microsoftonline.com/%s/", var7))).build();
        }
        catch (Exception var222) {
            LOGGER.warn("Failed to create confidential client application");
            return null;
        }
        ClientCredentialParameters var223 = ClientCredentialParameters.builder(Set.of(var4)).build();
        return new PlayerSafetyServiceTextFilter(var16, var17, var18, var19, (ConfidentialClientApplication)var21, var223, var14, var15);
    }

    private IAuthenticationResult aquireIAuthenticationResult() {
        return (IAuthenticationResult)this.client.acquireToken(this.clientParameters).join();
    }

    @Override
    protected void setAuthorizationProperty(HttpURLConnection var0) {
        IAuthenticationResult var1 = this.aquireIAuthenticationResult();
        var0.setRequestProperty("Authorization", "Bearer " + var1.accessToken());
    }

    @Override
    protected FilteredText filterText(String var0, ServerTextFilter.a var1, JsonObject var2) {
        JsonObject var3 = ChatDeserializer.getAsJsonObject(var2, "result", null);
        if (var3 == null) {
            return FilteredText.fullyFiltered(var0);
        }
        boolean var4 = ChatDeserializer.getAsBoolean(var3, "filtered", true);
        if (!var4) {
            return FilteredText.passThrough(var0);
        }
        JsonArray var5 = ChatDeserializer.getAsJsonArray(var3, "events", new JsonArray());
        for (JsonElement var7 : var5) {
            JsonObject var8 = var7.getAsJsonObject();
            String var9 = ChatDeserializer.getAsString(var8, "id", "");
            if (!this.fullyFilteredEvents.contains(var9)) continue;
            return FilteredText.fullyFiltered(var0);
        }
        JsonArray var6 = ChatDeserializer.getAsJsonArray(var3, "redactedTextIndex", new JsonArray());
        return new FilteredText(var0, this.parseMask(var0, var6, var1));
    }

    @Override
    protected int connectionReadTimeout() {
        return this.connectionReadTimeoutMs;
    }
}

