/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network.config;

import com.mojang.logging.LogUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkLoadCounter;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerSpawnFinder;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.LevelLoadListener;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class PrepareSpawnTask
implements ConfigurationTask {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final ConfigurationTask.a TYPE = new ConfigurationTask.a("prepare_spawn");
    public static final int PREPARE_CHUNK_RADIUS = 3;
    final MinecraftServer server;
    final NameAndId nameAndId;
    final LevelLoadListener loadListener;
    private @Nullable c state;

    public PrepareSpawnTask(MinecraftServer var0, NameAndId var1) {
        this.server = var0;
        this.nameAndId = var1;
        this.loadListener = var0.getLevelLoadListener();
    }

    @Override
    public void start(Consumer<Packet<?>> var02) {
        try (ProblemReporter.j var12 = new ProblemReporter.j(LOGGER);){
            Optional<ValueInput> var2 = this.server.getPlayerList().loadPlayerData(this.nameAndId).map(var1 -> TagValueInput.create((ProblemReporter)var12, (HolderLookup.a)this.server.registryAccess(), var1));
            EntityPlayer.c var3 = var2.flatMap(var0 -> var0.read(EntityPlayer.c.MAP_CODEC)).orElse(EntityPlayer.c.EMPTY);
            WorldData.a var4 = this.server.getWorldData().overworldData().getRespawnData();
            WorldServer var5 = var3.dimension().map(this.server::getLevel).orElseGet(() -> {
                WorldServer var1 = this.server.getLevel(var4.dimension());
                return var1 != null ? var1 : this.server.overworld();
            });
            CompletableFuture var6 = var3.position().map(CompletableFuture::completedFuture).orElseGet(() -> PlayerSpawnFinder.findSpawn(var5, var4.pos()));
            Vec2F var7 = var3.rotation().orElse(new Vec2F(var4.yaw(), var4.pitch()));
            this.state = new a(var5, var6, var7);
        }
    }

    @Override
    public boolean tick() {
        c c2 = this.state;
        int n2 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{a.class, b.class}, (Object)c2, n2)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                a var2 = (a)c2;
                b var3 = var2.tick();
                if (var3 != null) {
                    this.state = var3;
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                b var3 = (b)c2;
                yield true;
            }
            case -1 -> false;
        };
    }

    public EntityPlayer spawnPlayer(NetworkManager var0, CommonListenerCookie var1) {
        c c2 = this.state;
        if (c2 instanceof b) {
            b var2 = (b)c2;
            return var2.spawn(var0, var1);
        }
        throw new IllegalStateException("Player spawn was not ready");
    }

    public void keepAlive() {
        c c2 = this.state;
        if (c2 instanceof b) {
            b var0 = (b)c2;
            var0.keepAlive();
        }
    }

    public void close() {
        c c2 = this.state;
        if (c2 instanceof a) {
            a var0 = (a)c2;
            var0.cancel();
        }
        this.state = null;
    }

    @Override
    public ConfigurationTask.a type() {
        return TYPE;
    }

    final class a
    implements c {
        private final WorldServer spawnLevel;
        private final CompletableFuture<Vec3D> spawnPosition;
        private final Vec2F spawnAngle;
        private @Nullable CompletableFuture<?> chunkLoadFuture;
        private final ChunkLoadCounter chunkLoadCounter = new ChunkLoadCounter();

        a(WorldServer var1, CompletableFuture var2, Vec2F var3) {
            this.spawnLevel = var1;
            this.spawnPosition = var2;
            this.spawnAngle = var3;
        }

        public void cancel() {
            this.spawnPosition.cancel(false);
        }

        public @Nullable b tick() {
            if (!this.spawnPosition.isDone()) {
                return null;
            }
            Vec3D var0 = this.spawnPosition.join();
            if (this.chunkLoadFuture == null) {
                ChunkCoordIntPair var1 = new ChunkCoordIntPair(BlockPosition.containing(var0));
                this.chunkLoadCounter.track(this.spawnLevel, () -> {
                    this.chunkLoadFuture = this.spawnLevel.getChunkSource().addTicketAndLoadWithRadius(TicketType.PLAYER_SPAWN, var1, 3);
                });
                PrepareSpawnTask.this.loadListener.start(LevelLoadListener.a.LOAD_PLAYER_CHUNKS, this.chunkLoadCounter.totalChunks());
                PrepareSpawnTask.this.loadListener.updateFocus(this.spawnLevel.dimension(), var1);
            }
            PrepareSpawnTask.this.loadListener.update(LevelLoadListener.a.LOAD_PLAYER_CHUNKS, this.chunkLoadCounter.readyChunks(), this.chunkLoadCounter.totalChunks());
            if (!this.chunkLoadFuture.isDone()) {
                return null;
            }
            PrepareSpawnTask.this.loadListener.finish(LevelLoadListener.a.LOAD_PLAYER_CHUNKS);
            return new b(this.spawnLevel, var0, this.spawnAngle);
        }
    }

    static sealed interface c
    permits a, b {
    }

    final class b
    implements c {
        private final WorldServer spawnLevel;
        private final Vec3D spawnPosition;
        private final Vec2F spawnAngle;

        b(WorldServer var1, Vec3D var2, Vec2F var3) {
            this.spawnLevel = var1;
            this.spawnPosition = var2;
            this.spawnAngle = var3;
        }

        public void keepAlive() {
            this.spawnLevel.getChunkSource().addTicketWithRadius(TicketType.PLAYER_SPAWN, new ChunkCoordIntPair(BlockPosition.containing(this.spawnPosition)), 3);
        }

        public EntityPlayer spawn(NetworkManager var0, CommonListenerCookie var12) {
            ChunkCoordIntPair var2 = new ChunkCoordIntPair(BlockPosition.containing(this.spawnPosition));
            this.spawnLevel.waitForEntities(var2, 3);
            EntityPlayer var3 = new EntityPlayer(PrepareSpawnTask.this.server, this.spawnLevel, var12.gameProfile(), var12.clientInformation());
            try (ProblemReporter.j var4 = new ProblemReporter.j(var3.problemPath(), LOGGER);){
                Optional<ValueInput> var5 = PrepareSpawnTask.this.server.getPlayerList().loadPlayerData(PrepareSpawnTask.this.nameAndId).map(var1 -> TagValueInput.create((ProblemReporter)var4, (HolderLookup.a)PrepareSpawnTask.this.server.registryAccess(), var1));
                var5.ifPresent(var3::load);
                var3.snapTo(this.spawnPosition, this.spawnAngle.x, this.spawnAngle.y);
                PrepareSpawnTask.this.server.getPlayerList().placeNewPlayer(var0, var3, var12);
                var5.ifPresent(var1 -> {
                    var3.loadAndSpawnEnderPearls((ValueInput)var1);
                    var3.loadAndSpawnParentVehicle((ValueInput)var1);
                });
                EntityPlayer entityPlayer = var3;
                return entityPlayer;
            }
        }
    }
}

