/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import java.util.function.UnaryOperator;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;

public interface PackSource {
    public static final UnaryOperator<IChatBaseComponent> NO_DECORATION = UnaryOperator.identity();
    public static final PackSource DEFAULT = PackSource.create(NO_DECORATION, true);
    public static final PackSource BUILT_IN = PackSource.create(PackSource.decorateWithSource("pack.source.builtin"), true);
    public static final PackSource FEATURE = PackSource.create(PackSource.decorateWithSource("pack.source.feature"), false);
    public static final PackSource WORLD = PackSource.create(PackSource.decorateWithSource("pack.source.world"), true);
    public static final PackSource SERVER = PackSource.create(PackSource.decorateWithSource("pack.source.server"), true);

    public IChatBaseComponent decorate(IChatBaseComponent var1);

    public boolean shouldAddAutomatically();

    public static PackSource create(final UnaryOperator<IChatBaseComponent> var0, final boolean var1) {
        return new PackSource(){

            @Override
            public IChatBaseComponent decorate(IChatBaseComponent var02) {
                return (IChatBaseComponent)var0.apply(var02);
            }

            @Override
            public boolean shouldAddAutomatically() {
                return var1;
            }
        };
    }

    private static UnaryOperator<IChatBaseComponent> decorateWithSource(String var0) {
        IChatMutableComponent var12 = IChatBaseComponent.translatable(var0);
        return var1 -> IChatBaseComponent.translatable("pack.nameAndSource", var1, var12).withStyle(EnumChatFormat.GRAY);
    }
}

