/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.ChatDeserializer;

public interface ResourceMetadata {
    public static final ResourceMetadata EMPTY = new ResourceMetadata(){

        @Override
        public <T> Optional<T> getSection(MetadataSectionType<T> var0) {
            return Optional.empty();
        }
    };
    public static final IoSupplier<ResourceMetadata> EMPTY_SUPPLIER = () -> EMPTY;

    public static ResourceMetadata fromJsonStream(InputStream var0) throws IOException {
        try (BufferedReader var1 = new BufferedReader(new InputStreamReader(var0, StandardCharsets.UTF_8));){
            final JsonObject var2 = ChatDeserializer.parse(var1);
            ResourceMetadata resourceMetadata = new ResourceMetadata(){

                @Override
                public <T> Optional<T> getSection(MetadataSectionType<T> var0) {
                    String var1 = var0.name();
                    if (var2.has(var1)) {
                        Object var22 = var0.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)var2.get(var1)).getOrThrow(JsonParseException::new);
                        return Optional.of(var22);
                    }
                    return Optional.empty();
                }
            };
            return resourceMetadata;
        }
    }

    public <T> Optional<T> getSection(MetadataSectionType<T> var1);

    default public <T> Optional<MetadataSectionType.a<T>> getTypedSection(MetadataSectionType<T> var0) {
        return this.getSection(var0).map(var0::withValue);
    }

    default public List<MetadataSectionType.a<?>> getTypedSections(Collection<MetadataSectionType<?>> var0) {
        return var0.stream().map(this::getTypedSection).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
    }
}

