/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.permissions;

import net.minecraft.server.permissions.Permission;
import net.minecraft.server.permissions.PermissionLevel;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.server.permissions.Permissions;

public interface LevelBasedPermissionSet
extends PermissionSet {
    @Deprecated
    public static final LevelBasedPermissionSet ALL = LevelBasedPermissionSet.create(PermissionLevel.ALL);
    public static final LevelBasedPermissionSet MODERATOR = LevelBasedPermissionSet.create(PermissionLevel.MODERATORS);
    public static final LevelBasedPermissionSet GAMEMASTER = LevelBasedPermissionSet.create(PermissionLevel.GAMEMASTERS);
    public static final LevelBasedPermissionSet ADMIN = LevelBasedPermissionSet.create(PermissionLevel.ADMINS);
    public static final LevelBasedPermissionSet OWNER = LevelBasedPermissionSet.create(PermissionLevel.OWNERS);

    public PermissionLevel level();

    @Override
    default public boolean hasPermission(Permission var0) {
        if (var0 instanceof Permission.b) {
            Permission.b var1 = (Permission.b)var0;
            return this.level().isEqualOrHigherThan(var1.level());
        }
        if (var0.equals(Permissions.COMMANDS_ENTITY_SELECTORS)) {
            return this.level().isEqualOrHigherThan(PermissionLevel.GAMEMASTERS);
        }
        return false;
    }

    @Override
    default public PermissionSet union(PermissionSet var0) {
        if (var0 instanceof LevelBasedPermissionSet) {
            LevelBasedPermissionSet var1 = (LevelBasedPermissionSet)var0;
            if (this.level().isEqualOrHigherThan(var1.level())) {
                return var1;
            }
            return this;
        }
        return PermissionSet.super.union(var0);
    }

    public static LevelBasedPermissionSet forLevel(PermissionLevel var0) {
        return switch (var0) {
            default -> throw new MatchException(null, null);
            case PermissionLevel.ALL -> ALL;
            case PermissionLevel.MODERATORS -> MODERATOR;
            case PermissionLevel.GAMEMASTERS -> GAMEMASTER;
            case PermissionLevel.ADMINS -> ADMIN;
            case PermissionLevel.OWNERS -> OWNER;
        };
    }

    private static LevelBasedPermissionSet create(final PermissionLevel var0) {
        return new LevelBasedPermissionSet(){

            @Override
            public PermissionLevel level() {
                return var0;
            }

            public String toString() {
                return "permission level: " + var0.name();
            }
        };
    }
}

