/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.UserNameToIdResolver;
import net.minecraft.util.UtilColor;
import org.slf4j.Logger;

public class CachedUserNameToIdResolver
implements UserNameToIdResolver {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int GAMEPROFILES_MRU_LIMIT = 1000;
    private static final int GAMEPROFILES_EXPIRATION_MONTHS = 1;
    private boolean resolveOfflineUsers = true;
    private final Map<String, a> profilesByName = new ConcurrentHashMap<String, a>();
    private final Map<UUID, a> profilesByUUID = new ConcurrentHashMap<UUID, a>();
    private final GameProfileRepository profileRepository;
    private final Gson gson = new GsonBuilder().create();
    private final File file;
    private final AtomicLong operationCount = new AtomicLong();

    public CachedUserNameToIdResolver(GameProfileRepository var0, File var1) {
        this.profileRepository = var0;
        this.file = var1;
        Lists.reverse(this.load()).forEach(this::safeAdd);
    }

    private void safeAdd(a var0) {
        NameAndId var1 = var0.nameAndId();
        var0.setLastAccess(this.getNextOperation());
        this.profilesByName.put(var1.name().toLowerCase(Locale.ROOT), var0);
        this.profilesByUUID.put(var1.id(), var0);
    }

    private Optional<NameAndId> lookupGameProfile(GameProfileRepository var0, String var1) {
        if (!UtilColor.isValidPlayerName(var1)) {
            return this.createUnknownProfile(var1);
        }
        Optional<NameAndId> var2 = var0.findProfileByName(var1).map(NameAndId::new);
        if (var2.isEmpty()) {
            return this.createUnknownProfile(var1);
        }
        return var2;
    }

    private Optional<NameAndId> createUnknownProfile(String var0) {
        if (this.resolveOfflineUsers) {
            return Optional.of(NameAndId.createOffline(var0));
        }
        return Optional.empty();
    }

    @Override
    public void resolveOfflineUsers(boolean var0) {
        this.resolveOfflineUsers = var0;
    }

    @Override
    public void add(NameAndId var0) {
        this.addInternal(var0);
    }

    private a addInternal(NameAndId var0) {
        Calendar var1 = Calendar.getInstance(TimeZone.getDefault(), Locale.ROOT);
        var1.setTime(new Date());
        var1.add(2, 1);
        Date var2 = var1.getTime();
        a var3 = new a(var0, var2);
        this.safeAdd(var3);
        this.save();
        return var3;
    }

    private long getNextOperation() {
        return this.operationCount.incrementAndGet();
    }

    @Override
    public Optional<NameAndId> get(String var0) {
        Optional<NameAndId> var4;
        String var1 = var0.toLowerCase(Locale.ROOT);
        a var2 = this.profilesByName.get(var1);
        boolean var3 = false;
        if (var2 != null && new Date().getTime() >= var2.expirationDate.getTime()) {
            this.profilesByUUID.remove(var2.nameAndId().id());
            this.profilesByName.remove(var2.nameAndId().name().toLowerCase(Locale.ROOT));
            var3 = true;
            var2 = null;
        }
        if (var2 != null) {
            var2.setLastAccess(this.getNextOperation());
            var4 = Optional.of(var2.nameAndId());
        } else {
            Optional<NameAndId> var5 = this.lookupGameProfile(this.profileRepository, var1);
            if (var5.isPresent()) {
                var4 = Optional.of(this.addInternal(var5.get()).nameAndId());
                var3 = false;
            } else {
                var4 = Optional.empty();
            }
        }
        if (var3) {
            this.save();
        }
        return var4;
    }

    @Override
    public Optional<NameAndId> get(UUID var0) {
        a var1 = this.profilesByUUID.get(var0);
        if (var1 == null) {
            return Optional.empty();
        }
        var1.setLastAccess(this.getNextOperation());
        return Optional.of(var1.nameAndId());
    }

    private static DateFormat createDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<a> load() {
        ArrayList var0 = Lists.newArrayList();
        try (BufferedReader var12222 = Files.newReader((File)this.file, (Charset)StandardCharsets.UTF_8);){
            JsonArray var22 = (JsonArray)this.gson.fromJson((Reader)var12222, JsonArray.class);
            if (var22 == null) {
                ArrayList arrayList = var0;
                return arrayList;
            }
            DateFormat var3 = CachedUserNameToIdResolver.createDateFormat();
            var22.forEach(var2 -> CachedUserNameToIdResolver.readGameProfile(var2, var3).ifPresent(var0::add));
            return var0;
        }
        catch (FileNotFoundException var12222) {
            return var0;
        }
        catch (JsonParseException | IOException var13) {
            LOGGER.warn("Failed to load profile cache {}", (Object)this.file, (Object)var13);
        }
        return var0;
    }

    @Override
    public void save() {
        JsonArray var0 = new JsonArray();
        DateFormat var1 = CachedUserNameToIdResolver.createDateFormat();
        this.getTopMRUProfiles(1000).forEach(var2 -> var0.add(CachedUserNameToIdResolver.writeGameProfile(var2, var1)));
        String var22 = this.gson.toJson((JsonElement)var0);
        try (BufferedWriter var3 = Files.newWriter((File)this.file, (Charset)StandardCharsets.UTF_8);){
            var3.write(var22);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Stream<a> getTopMRUProfiles(int var0) {
        return ImmutableList.copyOf(this.profilesByUUID.values()).stream().sorted(Comparator.comparing(a::lastAccess).reversed()).limit(var0);
    }

    private static JsonElement writeGameProfile(a var0, DateFormat var1) {
        JsonObject var2 = new JsonObject();
        var0.nameAndId().appendTo(var2);
        var2.addProperty("expiresOn", var1.format(var0.expirationDate()));
        return var2;
    }

    private static Optional<a> readGameProfile(JsonElement var0, DateFormat var1) {
        JsonElement var4;
        JsonObject var2;
        NameAndId var3;
        if (var0.isJsonObject() && (var3 = NameAndId.fromJson(var2 = var0.getAsJsonObject())) != null && (var4 = var2.get("expiresOn")) != null) {
            String var5 = var4.getAsString();
            try {
                Date var6 = var1.parse(var5);
                return Optional.of(new a(var3, var6));
            }
            catch (ParseException var6) {
                LOGGER.warn("Failed to parse date {}", (Object)var5, (Object)var6);
            }
        }
        return Optional.empty();
    }

    static class a {
        private final NameAndId nameAndId;
        final Date expirationDate;
        private volatile long lastAccess;

        a(NameAndId var0, Date var1) {
            this.nameAndId = var0;
            this.expirationDate = var1;
        }

        public NameAndId nameAndId() {
            return this.nameAndId;
        }

        public Date expirationDate() {
            return this.expirationDate;
        }

        public void setLastAccess(long var0) {
            this.lastAccess = var0;
        }

        public long lastAccess() {
            return this.lastAccess;
        }
    }
}

