/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutLogin;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRecipeUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.game.PacketPlayOutViewDistance;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.notifications.NotificationService;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.server.permissions.PermissionLevel;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.GameProfileBanList;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.UserNameToIdResolver;
import net.minecraft.server.players.WhiteList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.util.FileUtils;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class PlayerList {
    public static final File USERBANLIST_FILE = new File("banned-players.json");
    public static final File IPBANLIST_FILE = new File("banned-ips.json");
    public static final File OPLIST_FILE = new File("ops.json");
    public static final File WHITELIST_FILE = new File("whitelist.json");
    public static final IChatBaseComponent CHAT_FILTERED_FULL = IChatBaseComponent.translatable("chat.filtered_full");
    public static final IChatBaseComponent DUPLICATE_LOGIN_DISCONNECT_MESSAGE = IChatBaseComponent.translatable("multiplayer.disconnect.duplicate_login");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SEND_PLAYER_INFO_INTERVAL = 600;
    private static final SimpleDateFormat BAN_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z", Locale.ROOT);
    private final MinecraftServer server;
    public final List<EntityPlayer> players = Lists.newArrayList();
    private final Map<UUID, EntityPlayer> playersByUUID = Maps.newHashMap();
    private final GameProfileBanList bans;
    private final IpBanList ipBans;
    private final OpList ops;
    private final WhiteList whitelist;
    private final Map<UUID, ServerStatisticManager> stats = Maps.newHashMap();
    private final Map<UUID, AdvancementDataPlayer> advancements = Maps.newHashMap();
    public final WorldNBTStorage playerIo;
    private final LayeredRegistryAccess<RegistryLayer> registries;
    private int viewDistance;
    private int simulationDistance;
    private boolean allowCommandsForAllPlayers;
    private int sendAllPlayerInfoIn;

    public PlayerList(MinecraftServer var0, LayeredRegistryAccess<RegistryLayer> var1, WorldNBTStorage var2, NotificationService var3) {
        this.server = var0;
        this.registries = var1;
        this.playerIo = var2;
        this.whitelist = new WhiteList(WHITELIST_FILE, var3);
        this.ops = new OpList(OPLIST_FILE, var3);
        this.bans = new GameProfileBanList(USERBANLIST_FILE, var3);
        this.ipBans = new IpBanList(IPBANLIST_FILE, var3);
    }

    public void placeNewPlayer(NetworkManager var0, EntityPlayer var1, CommonListenerCookie var2) {
        NameAndId var3 = var1.nameAndId();
        UserNameToIdResolver var4 = this.server.services().nameToIdCache();
        Optional<NameAndId> var6 = var4.get(var3.id());
        String var5 = var6.map(NameAndId::name).orElse(var3.name());
        var4.add(var3);
        WorldServer var7 = var1.level();
        String var8 = var0.getLoggableAddress(this.server.logIPs());
        LOGGER.info("{}[{}] logged in with entity id {} at ({}, {}, {})", new Object[]{var1.getPlainTextName(), var8, var1.getId(), var1.getX(), var1.getY(), var1.getZ()});
        WorldData var9 = var7.getLevelData();
        PlayerConnection var10 = new PlayerConnection(this.server, var0, var1, var2);
        var0.setupInboundProtocol(GameProtocols.SERVERBOUND_TEMPLATE.bind(RegistryFriendlyByteBuf.decorator(this.server.registryAccess()), var10), var10);
        var10.suspendFlushing();
        GameRules var11 = var7.getGameRules();
        boolean var12 = var11.get(GameRules.IMMEDIATE_RESPAWN);
        boolean var13 = var11.get(GameRules.REDUCED_DEBUG_INFO);
        boolean var14 = var11.get(GameRules.LIMITED_CRAFTING);
        var10.send(new PacketPlayOutLogin(var1.getId(), var9.isHardcore(), this.server.levelKeys(), this.getMaxPlayers(), this.getViewDistance(), this.getSimulationDistance(), var13, !var12, var14, var1.createCommonSpawnInfo(var7), this.server.enforceSecureProfile()));
        var10.send(new PacketPlayOutServerDifficulty(var9.getDifficulty(), var9.isDifficultyLocked()));
        var10.send(new PacketPlayOutAbilities(var1.getAbilities()));
        var10.send(new PacketPlayOutHeldItemSlot(var1.getInventory().getSelectedSlot()));
        CraftingManager var15 = this.server.getRecipeManager();
        var10.send(new PacketPlayOutRecipeUpdate(var15.getSynchronizedItemProperties(), var15.getSynchronizedStonecutterRecipes()));
        this.sendPlayerPermissionLevel(var1);
        var1.getStats().markAllDirty();
        var1.getRecipeBook().sendInitialRecipeBook(var1);
        this.updateEntireScoreboard(var7.getScoreboard(), var1);
        this.server.invalidateStatus();
        IChatMutableComponent var16 = var1.getGameProfile().name().equalsIgnoreCase(var5) ? IChatBaseComponent.translatable("multiplayer.player.joined", var1.getDisplayName()) : IChatBaseComponent.translatable("multiplayer.player.joined.renamed", var1.getDisplayName(), var5);
        this.broadcastSystemMessage(var16.withStyle(EnumChatFormat.YELLOW), false);
        var10.teleport(var1.getX(), var1.getY(), var1.getZ(), var1.getYRot(), var1.getXRot());
        ServerPing var17 = this.server.getStatus();
        if (var17 != null && !var2.transferred()) {
            var1.sendServerStatus(var17);
        }
        var1.connection.send(ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(this.players));
        this.players.add(var1);
        this.playersByUUID.put(var1.getUUID(), var1);
        this.broadcastAll(ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(List.of(var1)));
        this.sendLevelInfo(var1, var7);
        var7.addNewPlayer(var1);
        this.server.getCustomBossEvents().onPlayerConnect(var1);
        this.sendActivePlayerEffects(var1);
        var1.initInventoryMenu();
        this.server.notificationManager().playerJoined(var1);
        var10.resumeFlushing();
    }

    public void updateEntireScoreboard(ScoreboardServer var0, EntityPlayer var1) {
        HashSet var2 = Sets.newHashSet();
        for (ScoreboardTeam var4 : var0.getPlayerTeams()) {
            var1.connection.send(PacketPlayOutScoreboardTeam.createAddOrModifyPacket(var4, true));
        }
        for (DisplaySlot var6 : DisplaySlot.values()) {
            ScoreboardObjective var7 = var0.getDisplayObjective(var6);
            if (var7 == null || var2.contains(var7)) continue;
            List<Packet<?>> var8 = var0.getStartTrackingPackets(var7);
            for (Packet<?> var10 : var8) {
                var1.connection.send(var10);
            }
            var2.add(var7);
        }
    }

    public void addWorldborderListener(final WorldServer var0) {
        var0.getWorldBorder().addListener(new IWorldBorderListener(){

            @Override
            public void onSetSize(WorldBorder var02, double var1) {
                PlayerList.this.broadcastAll(new ClientboundSetBorderSizePacket(var02), var0.dimension());
            }

            @Override
            public void onLerpSize(WorldBorder var02, double var1, double var3, long var5, long var7) {
                PlayerList.this.broadcastAll(new ClientboundSetBorderLerpSizePacket(var02), var0.dimension());
            }

            @Override
            public void onSetCenter(WorldBorder var02, double var1, double var3) {
                PlayerList.this.broadcastAll(new ClientboundSetBorderCenterPacket(var02), var0.dimension());
            }

            @Override
            public void onSetWarningTime(WorldBorder var02, int var1) {
                PlayerList.this.broadcastAll(new ClientboundSetBorderWarningDelayPacket(var02), var0.dimension());
            }

            @Override
            public void onSetWarningBlocks(WorldBorder var02, int var1) {
                PlayerList.this.broadcastAll(new ClientboundSetBorderWarningDistancePacket(var02), var0.dimension());
            }

            @Override
            public void onSetDamagePerBlock(WorldBorder var02, double var1) {
            }

            @Override
            public void onSetSafeZone(WorldBorder var02, double var1) {
            }
        });
    }

    public Optional<NBTTagCompound> loadPlayerData(NameAndId var0) {
        NBTTagCompound var1 = this.server.getWorldData().getLoadedPlayerTag();
        if (this.server.isSingleplayerOwner(var0) && var1 != null) {
            LOGGER.debug("loading single player");
            return Optional.of(var1);
        }
        return this.playerIo.load(var0);
    }

    protected void save(EntityPlayer var0) {
        AdvancementDataPlayer var2;
        this.playerIo.save(var0);
        ServerStatisticManager var1 = this.stats.get(var0.getUUID());
        if (var1 != null) {
            var1.save();
        }
        if ((var2 = this.advancements.get(var0.getUUID())) != null) {
            var2.save();
        }
    }

    public void remove(EntityPlayer var02) {
        Entity var32;
        Object var2;
        WorldServer var1 = var02.level();
        var02.awardStat(StatisticList.LEAVE_GAME);
        this.save(var02);
        if (var02.isPassenger() && ((Entity)(var2 = var02.getRootVehicle())).hasExactlyOnePlayerPassenger()) {
            LOGGER.debug("Removing player mount");
            var02.stopRiding();
            ((Entity)var2).getPassengersAndSelf().forEach(var0 -> var0.setRemoved(Entity.RemovalReason.UNLOADED_WITH_PLAYER));
        }
        var02.unRide();
        for (Entity var32 : var02.getEnderPearls()) {
            var32.setRemoved(Entity.RemovalReason.UNLOADED_WITH_PLAYER);
        }
        var1.removePlayerImmediately(var02, Entity.RemovalReason.UNLOADED_WITH_PLAYER);
        var02.getAdvancements().stopListening();
        this.players.remove(var02);
        this.server.getCustomBossEvents().onPlayerDisconnect(var02);
        var2 = var02.getUUID();
        var32 = this.playersByUUID.get(var2);
        if (var32 == var02) {
            this.playersByUUID.remove(var2);
            this.stats.remove(var2);
            this.advancements.remove(var2);
            this.server.notificationManager().playerLeft(var02);
        }
        this.broadcastAll(new ClientboundPlayerInfoRemovePacket(List.of(var02.getUUID())));
    }

    public @Nullable IChatBaseComponent canPlayerLogin(SocketAddress var0, NameAndId var1) {
        if (this.bans.isBanned(var1)) {
            GameProfileBanEntry var2 = (GameProfileBanEntry)this.bans.get(var1);
            IChatMutableComponent var3 = IChatBaseComponent.translatable("multiplayer.disconnect.banned.reason", var2.getReasonMessage());
            if (var2.getExpires() != null) {
                var3.append(IChatBaseComponent.translatable("multiplayer.disconnect.banned.expiration", BAN_DATE_FORMAT.format(var2.getExpires())));
            }
            return var3;
        }
        if (!this.isWhiteListed(var1)) {
            return IChatBaseComponent.translatable("multiplayer.disconnect.not_whitelisted");
        }
        if (this.ipBans.isBanned(var0)) {
            IpBanEntry var2 = this.ipBans.get(var0);
            IChatMutableComponent var3 = IChatBaseComponent.translatable("multiplayer.disconnect.banned_ip.reason", var2.getReasonMessage());
            if (var2.getExpires() != null) {
                var3.append(IChatBaseComponent.translatable("multiplayer.disconnect.banned_ip.expiration", BAN_DATE_FORMAT.format(var2.getExpires())));
            }
            return var3;
        }
        if (this.players.size() >= this.getMaxPlayers() && !this.canBypassPlayerLimit(var1)) {
            return IChatBaseComponent.translatable("multiplayer.disconnect.server_full");
        }
        return null;
    }

    public boolean disconnectAllPlayersWithProfile(UUID var0) {
        Set var1 = Sets.newIdentityHashSet();
        for (EntityPlayer var3 : this.players) {
            if (!var3.getUUID().equals(var0)) continue;
            var1.add(var3);
        }
        EntityPlayer var2 = this.playersByUUID.get(var0);
        if (var2 != null) {
            var1.add(var2);
        }
        for (EntityPlayer var4 : var1) {
            var4.connection.disconnect(DUPLICATE_LOGIN_DISCONNECT_MESSAGE);
        }
        return !var1.isEmpty();
    }

    public EntityPlayer respawn(EntityPlayer var0, boolean var1, Entity.RemovalReason var2) {
        BlockPosition var13;
        IBlockData var14;
        WorldData.a var11;
        WorldServer var12;
        TeleportTransition var3 = var0.findRespawnPositionAndUseSpawnBlock(!var1, TeleportTransition.DO_NOTHING);
        this.players.remove(var0);
        var0.level().removePlayerImmediately(var0, var2);
        WorldServer var4 = var3.newLevel();
        EntityPlayer var5 = new EntityPlayer(this.server, var4, var0.getGameProfile(), var0.clientInformation());
        var5.connection = var0.connection;
        var5.restoreFrom(var0, var1);
        var5.setId(var0.getId());
        var5.setMainArm(var0.getMainArm());
        if (!var3.missingRespawnBlock()) {
            var5.copyRespawnPosition(var0);
        }
        for (String var7 : var0.getTags()) {
            var5.addTag(var7);
        }
        Vec3D var6 = var3.position();
        var5.snapTo(var6.x, var6.y, var6.z, var3.yRot(), var3.xRot());
        if (var3.missingRespawnBlock()) {
            var5.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.NO_RESPAWN_BLOCK_AVAILABLE, 0.0f));
        }
        byte var7 = var1 ? (byte)1 : 0;
        WorldServer var8 = var5.level();
        WorldData var9 = var8.getLevelData();
        var5.connection.send(new PacketPlayOutRespawn(var5.createCommonSpawnInfo(var8), var7));
        var5.connection.teleport(var5.getX(), var5.getY(), var5.getZ(), var5.getYRot(), var5.getXRot());
        var5.connection.send(new PacketPlayOutSpawnPosition(var4.getRespawnData()));
        var5.connection.send(new PacketPlayOutServerDifficulty(var9.getDifficulty(), var9.isDifficultyLocked()));
        var5.connection.send(new PacketPlayOutExperience(var5.experienceProgress, var5.totalExperience, var5.experienceLevel));
        this.sendActivePlayerEffects(var5);
        this.sendLevelInfo(var5, var4);
        this.sendPlayerPermissionLevel(var5);
        var4.addRespawnedPlayer(var5);
        this.players.add(var5);
        this.playersByUUID.put(var5.getUUID(), var5);
        var5.initInventoryMenu();
        var5.setHealth(var5.getHealth());
        EntityPlayer.RespawnConfig var10 = var5.getRespawnConfig();
        if (!var1 && var10 != null && (var12 = this.server.getLevel((var11 = var10.respawnData()).dimension())) != null && (var14 = var12.getBlockState(var13 = var11.pos())).is(Blocks.RESPAWN_ANCHOR)) {
            var5.connection.send(new PacketPlayOutNamedSoundEffect(SoundEffects.RESPAWN_ANCHOR_DEPLETE, SoundCategory.BLOCKS, var13.getX(), var13.getY(), var13.getZ(), 1.0f, 1.0f, var4.getRandom().nextLong()));
        }
        return var5;
    }

    public void sendActivePlayerEffects(EntityPlayer var0) {
        this.sendActiveEffects(var0, var0.connection);
    }

    public void sendActiveEffects(EntityLiving var0, PlayerConnection var1) {
        for (MobEffect var3 : var0.getActiveEffects()) {
            var1.send(new PacketPlayOutEntityEffect(var0.getId(), var3, false));
        }
    }

    public void sendPlayerPermissionLevel(EntityPlayer var0) {
        LevelBasedPermissionSet var1 = this.server.getProfilePermissions(var0.nameAndId());
        this.sendPlayerPermissionLevel(var0, var1);
    }

    public void tick() {
        if (++this.sendAllPlayerInfoIn > 600) {
            this.broadcastAll(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.UPDATE_LATENCY), this.players));
            this.sendAllPlayerInfoIn = 0;
        }
    }

    public void broadcastAll(Packet<?> var0) {
        for (EntityPlayer var2 : this.players) {
            var2.connection.send(var0);
        }
    }

    public void broadcastAll(Packet<?> var0, ResourceKey<World> var1) {
        for (EntityPlayer var3 : this.players) {
            if (var3.level().dimension() != var1) continue;
            var3.connection.send(var0);
        }
    }

    public void broadcastSystemToTeam(EntityHuman var0, IChatBaseComponent var1) {
        ScoreboardTeam var2 = var0.getTeam();
        if (var2 == null) {
            return;
        }
        Collection<String> var3 = ((ScoreboardTeamBase)var2).getPlayers();
        for (String var5 : var3) {
            EntityPlayer var6 = this.getPlayerByName(var5);
            if (var6 == null || var6 == var0) continue;
            var6.sendSystemMessage(var1);
        }
    }

    public void broadcastSystemToAllExceptTeam(EntityHuman var0, IChatBaseComponent var1) {
        ScoreboardTeam var2 = var0.getTeam();
        if (var2 == null) {
            this.broadcastSystemMessage(var1, false);
            return;
        }
        for (int var3 = 0; var3 < this.players.size(); ++var3) {
            EntityPlayer var4 = this.players.get(var3);
            if (var4.getTeam() == var2) continue;
            var4.sendSystemMessage(var1);
        }
    }

    public String[] getPlayerNamesArray() {
        String[] var0 = new String[this.players.size()];
        for (int var1 = 0; var1 < this.players.size(); ++var1) {
            var0[var1] = this.players.get(var1).getGameProfile().name();
        }
        return var0;
    }

    public GameProfileBanList getBans() {
        return this.bans;
    }

    public IpBanList getIpBans() {
        return this.ipBans;
    }

    public void op(NameAndId var0) {
        this.op(var0, Optional.empty(), Optional.empty());
    }

    public void op(NameAndId var0, Optional<LevelBasedPermissionSet> var1, Optional<Boolean> var2) {
        this.ops.add(new OpListEntry(var0, var1.orElse(this.server.operatorUserPermissions()), var2.orElse(this.ops.canBypassPlayerLimit(var0))));
        EntityPlayer var3 = this.getPlayer(var0.id());
        if (var3 != null) {
            this.sendPlayerPermissionLevel(var3);
        }
    }

    public void deop(NameAndId var0) {
        EntityPlayer var1;
        if (this.ops.remove(var0) && (var1 = this.getPlayer(var0.id())) != null) {
            this.sendPlayerPermissionLevel(var1);
        }
    }

    private void sendPlayerPermissionLevel(EntityPlayer var0, LevelBasedPermissionSet var1) {
        if (var0.connection != null) {
            byte var2 = switch (var1.level()) {
                default -> throw new MatchException(null, null);
                case PermissionLevel.ALL -> 24;
                case PermissionLevel.MODERATORS -> 25;
                case PermissionLevel.GAMEMASTERS -> 26;
                case PermissionLevel.ADMINS -> 27;
                case PermissionLevel.OWNERS -> 28;
            };
            var0.connection.send(new PacketPlayOutEntityStatus(var0, var2));
        }
        this.server.getCommands().sendCommands(var0);
    }

    public boolean isWhiteListed(NameAndId var0) {
        return !this.isUsingWhitelist() || this.ops.contains(var0) || this.whitelist.contains(var0);
    }

    public boolean isOp(NameAndId var0) {
        return this.ops.contains(var0) || this.server.isSingleplayerOwner(var0) && this.server.getWorldData().isAllowCommands() || this.allowCommandsForAllPlayers;
    }

    public @Nullable EntityPlayer getPlayerByName(String var0) {
        int var1 = this.players.size();
        for (int var2 = 0; var2 < var1; ++var2) {
            EntityPlayer var3 = this.players.get(var2);
            if (!var3.getGameProfile().name().equalsIgnoreCase(var0)) continue;
            return var3;
        }
        return null;
    }

    public void broadcast(@Nullable EntityHuman var0, double var1, double var3, double var5, double var7, ResourceKey<World> var9, Packet<?> var10) {
        for (int var11 = 0; var11 < this.players.size(); ++var11) {
            double var17;
            double var15;
            double var13;
            EntityPlayer var12 = this.players.get(var11);
            if (var12 == var0 || var12.level().dimension() != var9 || !((var13 = var1 - var12.getX()) * var13 + (var15 = var3 - var12.getY()) * var15 + (var17 = var5 - var12.getZ()) * var17 < var7 * var7)) continue;
            var12.connection.send(var10);
        }
    }

    public void saveAll() {
        for (int var0 = 0; var0 < this.players.size(); ++var0) {
            this.save(this.players.get(var0));
        }
    }

    public WhiteList getWhiteList() {
        return this.whitelist;
    }

    public String[] getWhiteListNames() {
        return this.whitelist.getUserList();
    }

    public OpList getOps() {
        return this.ops;
    }

    public String[] getOpNames() {
        return this.ops.getUserList();
    }

    public void reloadWhiteList() {
    }

    public void sendLevelInfo(EntityPlayer var0, WorldServer var1) {
        WorldBorder var2 = var1.getWorldBorder();
        var0.connection.send(new ClientboundInitializeBorderPacket(var2));
        var0.connection.send(new PacketPlayOutUpdateTime(var1.getGameTime(), var1.getDayTime(), var1.getGameRules().get(GameRules.ADVANCE_TIME)));
        var0.connection.send(new PacketPlayOutSpawnPosition(var1.getRespawnData()));
        if (var1.isRaining()) {
            var0.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.START_RAINING, 0.0f));
            var0.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.RAIN_LEVEL_CHANGE, var1.getRainLevel(1.0f)));
            var0.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.THUNDER_LEVEL_CHANGE, var1.getThunderLevel(1.0f)));
        }
        var0.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.LEVEL_CHUNKS_LOAD_START, 0.0f));
        this.server.tickRateManager().updateJoiningPlayer(var0);
    }

    public void sendAllPlayerInfo(EntityPlayer var0) {
        var0.inventoryMenu.sendAllDataToRemote();
        var0.resetSentInfo();
        var0.connection.send(new PacketPlayOutHeldItemSlot(var0.getInventory().getSelectedSlot()));
    }

    public int getPlayerCount() {
        return this.players.size();
    }

    public int getMaxPlayers() {
        return this.server.getMaxPlayers();
    }

    public boolean isUsingWhitelist() {
        return this.server.isUsingWhitelist();
    }

    public List<EntityPlayer> getPlayersWithAddress(String var0) {
        ArrayList var1 = Lists.newArrayList();
        for (EntityPlayer var3 : this.players) {
            if (!var3.getIpAddress().equals(var0)) continue;
            var1.add(var3);
        }
        return var1;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public int getSimulationDistance() {
        return this.simulationDistance;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public @Nullable NBTTagCompound getSingleplayerData() {
        return null;
    }

    public void setAllowCommandsForAllPlayers(boolean var0) {
        this.allowCommandsForAllPlayers = var0;
    }

    public void removeAll() {
        for (int var0 = 0; var0 < this.players.size(); ++var0) {
            this.players.get((int)var0).connection.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.server_shutdown"));
        }
    }

    public void broadcastSystemMessage(IChatBaseComponent var0, boolean var12) {
        this.broadcastSystemMessage(var0, var1 -> var0, var12);
    }

    public void broadcastSystemMessage(IChatBaseComponent var0, Function<EntityPlayer, IChatBaseComponent> var1, boolean var2) {
        this.server.sendSystemMessage(var0);
        for (EntityPlayer var4 : this.players) {
            IChatBaseComponent var5 = var1.apply(var4);
            if (var5 == null) continue;
            var4.sendSystemMessage(var5, var2);
        }
    }

    public void broadcastChatMessage(PlayerChatMessage var0, CommandListenerWrapper var1, ChatMessageType.a var2) {
        this.broadcastChatMessage(var0, var1::shouldFilterMessageTo, var1.getPlayer(), var2);
    }

    public void broadcastChatMessage(PlayerChatMessage var0, EntityPlayer var1, ChatMessageType.a var2) {
        this.broadcastChatMessage(var0, var1::shouldFilterMessageTo, var1, var2);
    }

    private void broadcastChatMessage(PlayerChatMessage var0, Predicate<EntityPlayer> var1, @Nullable EntityPlayer var2, ChatMessageType.a var3) {
        boolean var4 = this.verifyChatTrusted(var0);
        this.server.logChatMessage(var0.decoratedContent(), var3, var4 ? null : "Not Secure");
        OutgoingChatMessage var5 = OutgoingChatMessage.create(var0);
        boolean var6 = false;
        for (EntityPlayer var8 : this.players) {
            boolean var9 = var1.test(var8);
            var8.sendChatMessage(var5, var9, var3);
            var6 |= var9 && var0.isFullyFiltered();
        }
        if (var6 && var2 != null) {
            var2.sendSystemMessage(CHAT_FILTERED_FULL);
        }
    }

    private boolean verifyChatTrusted(PlayerChatMessage var0) {
        return var0.hasSignature() && !var0.hasExpiredServer(Instant.now());
    }

    public ServerStatisticManager getPlayerStats(EntityHuman var0) {
        GameProfile var12 = var0.getGameProfile();
        return this.stats.computeIfAbsent(var12.id(), var1 -> {
            Path var2 = this.locateStatsFile(var12);
            return new ServerStatisticManager(this.server, var2);
        });
    }

    private Path locateStatsFile(GameProfile var0) {
        Path var4;
        Path var1 = this.server.getWorldPath(SavedFile.PLAYER_STATS_DIR);
        Path var2 = var1.resolve(String.valueOf(var0.id()) + ".json");
        if (Files.exists(var2, new LinkOption[0])) {
            return var2;
        }
        String var3 = var0.name() + ".json";
        if (FileUtils.isValidPathSegment(var3) && Files.isRegularFile(var4 = var1.resolve(var3), new LinkOption[0])) {
            try {
                return Files.move(var4, var2, new CopyOption[0]);
            }
            catch (IOException var5) {
                LOGGER.warn("Failed to copy file {} to {}", (Object)var3, (Object)var2);
                return var4;
            }
        }
        return var2;
    }

    public AdvancementDataPlayer getPlayerAdvancements(EntityPlayer var0) {
        UUID var1 = var0.getUUID();
        AdvancementDataPlayer var2 = this.advancements.get(var1);
        if (var2 == null) {
            Path var3 = this.server.getWorldPath(SavedFile.PLAYER_ADVANCEMENTS_DIR).resolve(String.valueOf(var1) + ".json");
            var2 = new AdvancementDataPlayer(this.server.getFixerUpper(), this, this.server.getAdvancements(), var3, var0);
            this.advancements.put(var1, var2);
        }
        var2.setPlayer(var0);
        return var2;
    }

    public void setViewDistance(int var0) {
        this.viewDistance = var0;
        this.broadcastAll(new PacketPlayOutViewDistance(var0));
        for (WorldServer var2 : this.server.getAllLevels()) {
            var2.getChunkSource().setViewDistance(var0);
        }
    }

    public void setSimulationDistance(int var0) {
        this.simulationDistance = var0;
        this.broadcastAll(new ClientboundSetSimulationDistancePacket(var0));
        for (WorldServer var2 : this.server.getAllLevels()) {
            var2.getChunkSource().setSimulationDistance(var0);
        }
    }

    public List<EntityPlayer> getPlayers() {
        return this.players;
    }

    public @Nullable EntityPlayer getPlayer(UUID var0) {
        return this.playersByUUID.get(var0);
    }

    public @Nullable EntityPlayer getPlayer(String var0) {
        for (EntityPlayer var2 : this.players) {
            if (!var2.getGameProfile().name().equalsIgnoreCase(var0)) continue;
            return var2;
        }
        return null;
    }

    public boolean canBypassPlayerLimit(NameAndId var0) {
        return false;
    }

    public void reloadResources() {
        for (AdvancementDataPlayer advancementDataPlayer : this.advancements.values()) {
            advancementDataPlayer.reload(this.server.getAdvancements());
        }
        this.broadcastAll(new ClientboundUpdateTagsPacket(TagNetworkSerialization.serializeTagsToNetwork(this.registries)));
        CraftingManager var0 = this.server.getRecipeManager();
        PacketPlayOutRecipeUpdate packetPlayOutRecipeUpdate = new PacketPlayOutRecipeUpdate(var0.getSynchronizedItemProperties(), var0.getSynchronizedStonecutterRecipes());
        for (EntityPlayer var3 : this.players) {
            var3.connection.send(packetPlayOutRecipeUpdate);
            var3.getRecipeBook().sendInitialRecipeBook(var3);
        }
    }

    public boolean isAllowCommandsForAllPlayers() {
        return this.allowCommandsForAllPlayers;
    }
}

