/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import java.util.List;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.player.EntityHuman;

public class SleepStatus {
    private int activePlayers;
    private int sleepingPlayers;

    public boolean areEnoughSleeping(int var0) {
        return this.sleepingPlayers >= this.sleepersNeeded(var0);
    }

    public boolean areEnoughDeepSleeping(int var0, List<EntityPlayer> var1) {
        int var2 = (int)var1.stream().filter(EntityHuman::isSleepingLongEnough).count();
        return var2 >= this.sleepersNeeded(var0);
    }

    public int sleepersNeeded(int var0) {
        return Math.max(1, MathHelper.ceil((float)(this.activePlayers * var0) / 100.0f));
    }

    public void removeAllSleepers() {
        this.sleepingPlayers = 0;
    }

    public int amountSleeping() {
        return this.sleepingPlayers;
    }

    public boolean update(List<EntityPlayer> var0) {
        int var1 = this.activePlayers;
        int var2 = this.sleepingPlayers;
        this.activePlayers = 0;
        this.sleepingPlayers = 0;
        for (EntityPlayer var4 : var0) {
            if (var4.isSpectator()) continue;
            ++this.activePlayers;
            if (!var4.isSleeping()) continue;
            ++this.sleepingPlayers;
        }
        return !(var2 <= 0 && this.sleepingPlayers <= 0 || var1 == this.activePlayers && var2 == this.sleepingPlayers);
    }
}

