/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.network.protocol.game.PacketPlayOutStatistic;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticManager;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.FileUtils;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.EntityHuman;
import org.slf4j.Logger;

public class ServerStatisticManager
extends StatisticManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Codec<Map<Statistic<?>, Integer>> STATS_CODEC = Codec.dispatchedMap(BuiltInRegistries.STAT_TYPE.byNameCodec(), SystemUtils.memoize(ServerStatisticManager::createTypedStatsCodec)).xmap(var0 -> {
        HashMap var12 = new HashMap();
        var0.forEach((var1, var2) -> var12.putAll(var2));
        return var12;
    }, var02 -> var02.entrySet().stream().collect(Collectors.groupingBy(var0 -> ((Statistic)var0.getKey()).getType(), SystemUtils.toMap())));
    private final Path file;
    private final Set<Statistic<?>> dirty = Sets.newHashSet();

    private static <T> Codec<Map<Statistic<?>, Integer>> createTypedStatsCodec(StatisticWrapper<T> var0) {
        Codec<T> var12 = var0.getRegistry().byNameCodec();
        Codec var2 = var12.flatComapMap(var0::get, var1 -> {
            if (var1.getType() == var0) {
                return DataResult.success(var1.getValue());
            }
            return DataResult.error(() -> "Expected type " + String.valueOf(var0) + ", but got " + String.valueOf(var1.getType()));
        });
        return Codec.unboundedMap((Codec)var2, (Codec)Codec.INT);
    }

    public ServerStatisticManager(MinecraftServer var0, Path var1) {
        this.file = var1;
        if (Files.isRegularFile(var1, new LinkOption[0])) {
            try (BufferedReader var2 = Files.newBufferedReader(var1, StandardCharsets.UTF_8);){
                JsonElement var3 = StrictJsonParser.parse(var2);
                this.parse(var0.getFixerUpper(), var3);
            }
            catch (IOException var22) {
                LOGGER.error("Couldn't read statistics file {}", (Object)var1, (Object)var22);
            }
            catch (JsonParseException var23) {
                LOGGER.error("Couldn't parse statistics file {}", (Object)var1, (Object)var23);
            }
        }
    }

    public void save() {
        try {
            FileUtils.createDirectoriesSafe(this.file.getParent());
            try (BufferedWriter var0 = Files.newBufferedWriter(this.file, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson(this.toJson(), GSON.newJsonWriter((Writer)var0));
            }
        }
        catch (JsonIOException | IOException var0) {
            LOGGER.error("Couldn't save stats to {}", (Object)this.file, (Object)var0);
        }
    }

    @Override
    public void setValue(EntityHuman var0, Statistic<?> var1, int var2) {
        super.setValue(var0, var1, var2);
        this.dirty.add(var1);
    }

    private Set<Statistic<?>> getDirty() {
        HashSet var0 = Sets.newHashSet(this.dirty);
        this.dirty.clear();
        return var0;
    }

    public void parse(DataFixer var02, JsonElement var1) {
        Dynamic var2 = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)var1);
        var2 = DataFixTypes.STATS.updateToCurrentVersion(var02, var2, GameProfileSerializer.getDataVersion(var2, 1343));
        this.stats.putAll(STATS_CODEC.parse(var2.get("stats").orElseEmptyMap()).resultOrPartial(var0 -> LOGGER.error("Failed to parse statistics for {}: {}", (Object)this.file, var0)).orElse(Map.of()));
    }

    protected JsonElement toJson() {
        JsonObject var0 = new JsonObject();
        var0.add("stats", (JsonElement)STATS_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.stats).getOrThrow());
        var0.addProperty("DataVersion", (Number)SharedConstants.getCurrentVersion().dataVersion().version());
        return var0;
    }

    public void markAllDirty() {
        this.dirty.addAll((Collection<Statistic<?>>)this.stats.keySet());
    }

    public void sendStats(EntityPlayer var0) {
        Object2IntOpenHashMap var1 = new Object2IntOpenHashMap();
        for (Statistic<?> var3 : this.getDirty()) {
            var1.put(var3, this.getValue(var3));
        }
        var0.connection.send(new PacketPlayOutStatistic((Object2IntMap<Statistic<?>>)var1));
    }
}

