/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;

public class ResourceLocationPattern {
    public static final Codec<ResourceLocationPattern> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)ExtraCodecs.PATTERN.optionalFieldOf("namespace").forGetter(var0 -> var0.namespacePattern), (App)ExtraCodecs.PATTERN.optionalFieldOf("path").forGetter(var0 -> var0.pathPattern)).apply((Applicative)var02, ResourceLocationPattern::new));
    private final Optional<Pattern> namespacePattern;
    private final Predicate<String> namespacePredicate;
    private final Optional<Pattern> pathPattern;
    private final Predicate<String> pathPredicate;
    private final Predicate<MinecraftKey> locationPredicate;

    private ResourceLocationPattern(Optional<Pattern> var02, Optional<Pattern> var1) {
        this.namespacePattern = var02;
        this.namespacePredicate = var02.map(Pattern::asPredicate).orElse(var0 -> true);
        this.pathPattern = var1;
        this.pathPredicate = var1.map(Pattern::asPredicate).orElse(var0 -> true);
        this.locationPredicate = var0 -> this.namespacePredicate.test(var0.getNamespace()) && this.pathPredicate.test(var0.getPath());
    }

    public Predicate<String> namespacePredicate() {
        return this.namespacePredicate;
    }

    public Predicate<String> pathPredicate() {
        return this.pathPredicate;
    }

    public Predicate<MinecraftKey> locationPredicate() {
        return this.locationPredicate;
    }
}

