/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.AbstractArrowPickupFix;
import net.minecraft.util.datafix.fixes.AddFieldFix;
import net.minecraft.util.datafix.fixes.AddFlagIfNotPresentFix;
import net.minecraft.util.datafix.fixes.AreaEffectCloudDurationScaleFix;
import net.minecraft.util.datafix.fixes.AreaEffectCloudPotionFix;
import net.minecraft.util.datafix.fixes.AttributeIdPrefixFix;
import net.minecraft.util.datafix.fixes.AttributeModifierIdFix;
import net.minecraft.util.datafix.fixes.BannerEntityCustomNameToOverrideComponentFix;
import net.minecraft.util.datafix.fixes.BannerPatternFormatFix;
import net.minecraft.util.datafix.fixes.BeehiveFieldRenameFix;
import net.minecraft.util.datafix.fixes.BlendingDataFix;
import net.minecraft.util.datafix.fixes.BlendingDataRemoveFromNetherEndFix;
import net.minecraft.util.datafix.fixes.BlockEntityFurnaceBurnTimeFix;
import net.minecraft.util.datafix.fixes.BlockEntityRenameFix;
import net.minecraft.util.datafix.fixes.BlockEntitySignDoubleSidedEditableTextFix;
import net.minecraft.util.datafix.fixes.BlockPosFormatAndRenamesFix;
import net.minecraft.util.datafix.fixes.BlockPropertyRenameAndFix;
import net.minecraft.util.datafix.fixes.BoatSplitFix;
import net.minecraft.util.datafix.fixes.CarvingStepRemoveFix;
import net.minecraft.util.datafix.fixes.CauldronRenameFix;
import net.minecraft.util.datafix.fixes.CavesAndCliffsRenames;
import net.minecraft.util.datafix.fixes.ChestedHorsesInventoryZeroIndexingFix;
import net.minecraft.util.datafix.fixes.ChunkConverterPalette;
import net.minecraft.util.datafix.fixes.ChunkDeleteIgnoredLightDataFix;
import net.minecraft.util.datafix.fixes.ChunkDeleteLightFix;
import net.minecraft.util.datafix.fixes.ChunkHeightAndBiomeFix;
import net.minecraft.util.datafix.fixes.ChunkProtoTickListFix;
import net.minecraft.util.datafix.fixes.ChunkRenamesFix;
import net.minecraft.util.datafix.fixes.ChunkTicketUnpackPosFix;
import net.minecraft.util.datafix.fixes.ContainerBlockEntityLockPredicateFix;
import net.minecraft.util.datafix.fixes.CopperGolemWeatherStateFix;
import net.minecraft.util.datafix.fixes.CriteriaRenameFix;
import net.minecraft.util.datafix.fixes.CustomModelDataExpandFix;
import net.minecraft.util.datafix.fixes.DataConverterAddChoices;
import net.minecraft.util.datafix.fixes.DataConverterAdvancement;
import net.minecraft.util.datafix.fixes.DataConverterAdvancementBase;
import net.minecraft.util.datafix.fixes.DataConverterArmorStand;
import net.minecraft.util.datafix.fixes.DataConverterAttributes;
import net.minecraft.util.datafix.fixes.DataConverterBanner;
import net.minecraft.util.datafix.fixes.DataConverterBannerColour;
import net.minecraft.util.datafix.fixes.DataConverterBedBlock;
import net.minecraft.util.datafix.fixes.DataConverterBedItem;
import net.minecraft.util.datafix.fixes.DataConverterBiome;
import net.minecraft.util.datafix.fixes.DataConverterBitStorageAlign;
import net.minecraft.util.datafix.fixes.DataConverterBlockEntityKeepPacked;
import net.minecraft.util.datafix.fixes.DataConverterBlockEntityUUID;
import net.minecraft.util.datafix.fixes.DataConverterBlockName;
import net.minecraft.util.datafix.fixes.DataConverterBlockRename;
import net.minecraft.util.datafix.fixes.DataConverterCatType;
import net.minecraft.util.datafix.fixes.DataConverterChunkLightRemove;
import net.minecraft.util.datafix.fixes.DataConverterChunkStatus;
import net.minecraft.util.datafix.fixes.DataConverterChunkStatus2;
import net.minecraft.util.datafix.fixes.DataConverterChunkStructuresTemplateRename;
import net.minecraft.util.datafix.fixes.DataConverterColorlessShulkerEntity;
import net.minecraft.util.datafix.fixes.DataConverterCoral;
import net.minecraft.util.datafix.fixes.DataConverterCoralFan;
import net.minecraft.util.datafix.fixes.DataConverterCustomNameEntity;
import net.minecraft.util.datafix.fixes.DataConverterCustomNameItem;
import net.minecraft.util.datafix.fixes.DataConverterCustomNameTile;
import net.minecraft.util.datafix.fixes.DataConverterDropChances;
import net.minecraft.util.datafix.fixes.DataConverterDye;
import net.minecraft.util.datafix.fixes.DataConverterEntity;
import net.minecraft.util.datafix.fixes.DataConverterEntityBlockState;
import net.minecraft.util.datafix.fixes.DataConverterEntityCatSplit;
import net.minecraft.util.datafix.fixes.DataConverterEntityCodSalmon;
import net.minecraft.util.datafix.fixes.DataConverterEntityProjectileOwner;
import net.minecraft.util.datafix.fixes.DataConverterEntityPufferfish;
import net.minecraft.util.datafix.fixes.DataConverterEntityRavagerRename;
import net.minecraft.util.datafix.fixes.DataConverterEntityRename;
import net.minecraft.util.datafix.fixes.DataConverterEntityShulkerRotation;
import net.minecraft.util.datafix.fixes.DataConverterEntityTippedArrow;
import net.minecraft.util.datafix.fixes.DataConverterEntityUUID;
import net.minecraft.util.datafix.fixes.DataConverterEntityZombifiedPiglinRename;
import net.minecraft.util.datafix.fixes.DataConverterEquipment;
import net.minecraft.util.datafix.fixes.DataConverterFlatten;
import net.minecraft.util.datafix.fixes.DataConverterFlattenSpawnEgg;
import net.minecraft.util.datafix.fixes.DataConverterFlattenState;
import net.minecraft.util.datafix.fixes.DataConverterFurnaceRecipesUsed;
import net.minecraft.util.datafix.fixes.DataConverterGossip;
import net.minecraft.util.datafix.fixes.DataConverterGuardian;
import net.minecraft.util.datafix.fixes.DataConverterHanging;
import net.minecraft.util.datafix.fixes.DataConverterHealth;
import net.minecraft.util.datafix.fixes.DataConverterHeightmapRenaming;
import net.minecraft.util.datafix.fixes.DataConverterHorse;
import net.minecraft.util.datafix.fixes.DataConverterIglooMetadataRemoval;
import net.minecraft.util.datafix.fixes.DataConverterItemFrame;
import net.minecraft.util.datafix.fixes.DataConverterItemLoreComponentize;
import net.minecraft.util.datafix.fixes.DataConverterItemName;
import net.minecraft.util.datafix.fixes.DataConverterItemStackEnchantment;
import net.minecraft.util.datafix.fixes.DataConverterItemStackUUID;
import net.minecraft.util.datafix.fixes.DataConverterJigsawProperties;
import net.minecraft.util.datafix.fixes.DataConverterJigsawRotation;
import net.minecraft.util.datafix.fixes.DataConverterJukeBox;
import net.minecraft.util.datafix.fixes.DataConverterKeybind;
import net.minecraft.util.datafix.fixes.DataConverterKeybind2;
import net.minecraft.util.datafix.fixes.DataConverterLang;
import net.minecraft.util.datafix.fixes.DataConverterLeaves;
import net.minecraft.util.datafix.fixes.DataConverterLeavesBiome;
import net.minecraft.util.datafix.fixes.DataConverterLevelDataGeneratorOptions;
import net.minecraft.util.datafix.fixes.DataConverterMap;
import net.minecraft.util.datafix.fixes.DataConverterMapId;
import net.minecraft.util.datafix.fixes.DataConverterMaterialId;
import net.minecraft.util.datafix.fixes.DataConverterMemoryExpiry;
import net.minecraft.util.datafix.fixes.DataConverterMinecart;
import net.minecraft.util.datafix.fixes.DataConverterMiscUUID;
import net.minecraft.util.datafix.fixes.DataConverterMissingDimension;
import net.minecraft.util.datafix.fixes.DataConverterMobSpawner;
import net.minecraft.util.datafix.fixes.DataConverterNewVillage;
import net.minecraft.util.datafix.fixes.DataConverterObjectiveRenderType;
import net.minecraft.util.datafix.fixes.DataConverterOminousBannerBlockEntityRename;
import net.minecraft.util.datafix.fixes.DataConverterOminousBannerRename;
import net.minecraft.util.datafix.fixes.DataConverterOptionsAddTextBackground;
import net.minecraft.util.datafix.fixes.DataConverterPOI;
import net.minecraft.util.datafix.fixes.DataConverterPOIRebuild;
import net.minecraft.util.datafix.fixes.DataConverterPainting;
import net.minecraft.util.datafix.fixes.DataConverterPiston;
import net.minecraft.util.datafix.fixes.DataConverterPlayerUUID;
import net.minecraft.util.datafix.fixes.DataConverterPotionId;
import net.minecraft.util.datafix.fixes.DataConverterPotionWater;
import net.minecraft.util.datafix.fixes.DataConverterProtoChunk;
import net.minecraft.util.datafix.fixes.DataConverterRecipeRename;
import net.minecraft.util.datafix.fixes.DataConverterRecipes;
import net.minecraft.util.datafix.fixes.DataConverterRedstoneConnections;
import net.minecraft.util.datafix.fixes.DataConverterRemoveGolemGossip;
import net.minecraft.util.datafix.fixes.DataConverterRiding;
import net.minecraft.util.datafix.fixes.DataConverterSaddle;
import net.minecraft.util.datafix.fixes.DataConverterSavedDataUUID;
import net.minecraft.util.datafix.fixes.DataConverterSettingRename;
import net.minecraft.util.datafix.fixes.DataConverterShoulderEntity;
import net.minecraft.util.datafix.fixes.DataConverterShulker;
import net.minecraft.util.datafix.fixes.DataConverterShulkerBoxBlock;
import net.minecraft.util.datafix.fixes.DataConverterShulkerBoxItem;
import net.minecraft.util.datafix.fixes.DataConverterSkeleton;
import net.minecraft.util.datafix.fixes.DataConverterSpawnEgg;
import net.minecraft.util.datafix.fixes.DataConverterStatistic;
import net.minecraft.util.datafix.fixes.DataConverterStriderGravity;
import net.minecraft.util.datafix.fixes.DataConverterStructureReference;
import net.minecraft.util.datafix.fixes.DataConverterTileEntity;
import net.minecraft.util.datafix.fixes.DataConverterTrappedChest;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.fixes.DataConverterUUID;
import net.minecraft.util.datafix.fixes.DataConverterVBO;
import net.minecraft.util.datafix.fixes.DataConverterVillagerFollowRange;
import net.minecraft.util.datafix.fixes.DataConverterVillagerLevelXp;
import net.minecraft.util.datafix.fixes.DataConverterVillagerProfession;
import net.minecraft.util.datafix.fixes.DataConverterVillagerTrade;
import net.minecraft.util.datafix.fixes.DataConverterWallProperty;
import net.minecraft.util.datafix.fixes.DataConverterWolf;
import net.minecraft.util.datafix.fixes.DataConverterWorldGenSettings;
import net.minecraft.util.datafix.fixes.DataConverterWorldGenSettingsBuilding;
import net.minecraft.util.datafix.fixes.DataConverterZombie;
import net.minecraft.util.datafix.fixes.DataConverterZombieType;
import net.minecraft.util.datafix.fixes.DataConverterZombieVillagerLevelXp;
import net.minecraft.util.datafix.fixes.DebugProfileOverlayReferenceFix;
import net.minecraft.util.datafix.fixes.DecoratedPotFieldRenameFix;
import net.minecraft.util.datafix.fixes.DropChancesFormatFix;
import net.minecraft.util.datafix.fixes.DropInvalidSignDataFix;
import net.minecraft.util.datafix.fixes.EffectDurationFix;
import net.minecraft.util.datafix.fixes.EmptyItemInHotbarFix;
import net.minecraft.util.datafix.fixes.EmptyItemInVillagerTradeFix;
import net.minecraft.util.datafix.fixes.EntityAttributeBaseValueFix;
import net.minecraft.util.datafix.fixes.EntityBrushableBlockFieldsRenameFix;
import net.minecraft.util.datafix.fixes.EntityFallDistanceFloatToDoubleFix;
import net.minecraft.util.datafix.fixes.EntityFieldsRenameFix;
import net.minecraft.util.datafix.fixes.EntityGoatMissingStateFix;
import net.minecraft.util.datafix.fixes.EntitySalmonSizeFix;
import net.minecraft.util.datafix.fixes.EntitySpawnerItemVariantComponentFix;
import net.minecraft.util.datafix.fixes.EntityVariantFix;
import net.minecraft.util.datafix.fixes.EquipmentFormatFix;
import net.minecraft.util.datafix.fixes.EquippableAssetRenameFix;
import net.minecraft.util.datafix.fixes.FeatureFlagRemoveFix;
import net.minecraft.util.datafix.fixes.FilteredBooksFix;
import net.minecraft.util.datafix.fixes.FilteredSignsFix;
import net.minecraft.util.datafix.fixes.FireResistantToDamageResistantComponentFix;
import net.minecraft.util.datafix.fixes.FixProjectileStoredItem;
import net.minecraft.util.datafix.fixes.FixWolfHealth;
import net.minecraft.util.datafix.fixes.FoodToConsumableFix;
import net.minecraft.util.datafix.fixes.ForcedChunkToTicketFix;
import net.minecraft.util.datafix.fixes.GameRuleRegistryFix;
import net.minecraft.util.datafix.fixes.GoatHornIdFix;
import net.minecraft.util.datafix.fixes.HorseBodyArmorItemFix;
import net.minecraft.util.datafix.fixes.InlineBlockPosFormatFix;
import net.minecraft.util.datafix.fixes.InvalidBlockEntityLockFix;
import net.minecraft.util.datafix.fixes.InvalidLockComponentFix;
import net.minecraft.util.datafix.fixes.ItemStackComponentizationFix;
import net.minecraft.util.datafix.fixes.ItemStackCustomNameToOverrideComponentFix;
import net.minecraft.util.datafix.fixes.JukeboxTicksSinceSongStartedFix;
import net.minecraft.util.datafix.fixes.LegacyDimensionIdFix;
import net.minecraft.util.datafix.fixes.LegacyDragonFightFix;
import net.minecraft.util.datafix.fixes.LegacyHoverEventFix;
import net.minecraft.util.datafix.fixes.LegacyWorldBorderFix;
import net.minecraft.util.datafix.fixes.LevelLegacyWorldGenSettingsFix;
import net.minecraft.util.datafix.fixes.LockComponentPredicateFix;
import net.minecraft.util.datafix.fixes.LodestoneCompassComponentFix;
import net.minecraft.util.datafix.fixes.MapBannerBlockPosFormatFix;
import net.minecraft.util.datafix.fixes.MobEffectIdFix;
import net.minecraft.util.datafix.fixes.NamedEntityConvertUncheckedFix;
import net.minecraft.util.datafix.fixes.NamedEntityWriteReadFix;
import net.minecraft.util.datafix.fixes.NamespacedTypeRenameFix;
import net.minecraft.util.datafix.fixes.OminousBannerRarityFix;
import net.minecraft.util.datafix.fixes.OptionsAccessibilityOnboardFix;
import net.minecraft.util.datafix.fixes.OptionsAmbientOcclusionFix;
import net.minecraft.util.datafix.fixes.OptionsFancyGraphicsToGraphicsModeFix;
import net.minecraft.util.datafix.fixes.OptionsGraphicsModeSplitFix;
import net.minecraft.util.datafix.fixes.OptionsMenuBlurrinessFix;
import net.minecraft.util.datafix.fixes.OptionsMusicToastFix;
import net.minecraft.util.datafix.fixes.OptionsProgrammerArtFix;
import net.minecraft.util.datafix.fixes.OptionsSetGraphicsPresetToCustomFix;
import net.minecraft.util.datafix.fixes.OverreachingTickFix;
import net.minecraft.util.datafix.fixes.ParticleUnflatteningFix;
import net.minecraft.util.datafix.fixes.PlayerEquipmentFix;
import net.minecraft.util.datafix.fixes.PlayerHeadBlockProfileFix;
import net.minecraft.util.datafix.fixes.PlayerRespawnDataFix;
import net.minecraft.util.datafix.fixes.PoiTypeRemoveFix;
import net.minecraft.util.datafix.fixes.PoiTypeRenameFix;
import net.minecraft.util.datafix.fixes.PrimedTntBlockStateFixer;
import net.minecraft.util.datafix.fixes.ProjectileStoredWeaponFix;
import net.minecraft.util.datafix.fixes.RaidRenamesDataFix;
import net.minecraft.util.datafix.fixes.RandomSequenceSettingsFix;
import net.minecraft.util.datafix.fixes.RemapChunkStatusFix;
import net.minecraft.util.datafix.fixes.RemoveBlockEntityTagFix;
import net.minecraft.util.datafix.fixes.RemoveEmptyItemInBrushableBlockFix;
import net.minecraft.util.datafix.fixes.RenameEnchantmentsFix;
import net.minecraft.util.datafix.fixes.SaddleEquipmentSlotFix;
import net.minecraft.util.datafix.fixes.SavedDataFeaturePoolElementFix;
import net.minecraft.util.datafix.fixes.ScoreboardDisplayNameFix;
import net.minecraft.util.datafix.fixes.ScoreboardDisplaySlotFix;
import net.minecraft.util.datafix.fixes.SignTextStrictJsonFix;
import net.minecraft.util.datafix.fixes.SpawnerDataFix;
import net.minecraft.util.datafix.fixes.StatsRenameFix;
import net.minecraft.util.datafix.fixes.StructureSettingsFlattenFix;
import net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix;
import net.minecraft.util.datafix.fixes.TextComponentHoverAndClickEventFix;
import net.minecraft.util.datafix.fixes.TextComponentStringifiedFlagsFix;
import net.minecraft.util.datafix.fixes.ThrownPotionSplitFix;
import net.minecraft.util.datafix.fixes.TippedArrowPotionToItemFix;
import net.minecraft.util.datafix.fixes.TooltipDisplayComponentFix;
import net.minecraft.util.datafix.fixes.TrialSpawnerConfigFix;
import net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix;
import net.minecraft.util.datafix.fixes.TridentAnimationFix;
import net.minecraft.util.datafix.fixes.UnflattenTextComponentFix;
import net.minecraft.util.datafix.fixes.VariantRenameFix;
import net.minecraft.util.datafix.fixes.VillagerSetCanPickUpLootFix;
import net.minecraft.util.datafix.fixes.WeaponSmithChestLootTableFix;
import net.minecraft.util.datafix.fixes.WorldBorderWarningTimeFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsDisallowOldCustomWorldsFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsHeightAndBiomeFix;
import net.minecraft.util.datafix.fixes.WorldSpawnDataFix;
import net.minecraft.util.datafix.fixes.WrittenBookPagesStrictJsonFix;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV100;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV102;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1022;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV106;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV107;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1125;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV135;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV143;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_1;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_2;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_3;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_4;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_5;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1451_6;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1460;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1466;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1470;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1481;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1483;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1486;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1510;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1800;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1801;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1904;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1906;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1909;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1920;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1928;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1929;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV1931;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2100;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2501;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2502;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2505;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2509;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2519;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2522;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2551;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV2568;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV501;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV700;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV701;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV702;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV703;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV704;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV705;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV808;
import net.minecraft.util.datafix.schemas.DataConverterSchemaV99;
import net.minecraft.util.datafix.schemas.V1458;
import net.minecraft.util.datafix.schemas.V1488;
import net.minecraft.util.datafix.schemas.V2511_1;
import net.minecraft.util.datafix.schemas.V2571;
import net.minecraft.util.datafix.schemas.V2684;
import net.minecraft.util.datafix.schemas.V2686;
import net.minecraft.util.datafix.schemas.V2688;
import net.minecraft.util.datafix.schemas.V2704;
import net.minecraft.util.datafix.schemas.V2707;
import net.minecraft.util.datafix.schemas.V2831;
import net.minecraft.util.datafix.schemas.V2832;
import net.minecraft.util.datafix.schemas.V2842;
import net.minecraft.util.datafix.schemas.V3076;
import net.minecraft.util.datafix.schemas.V3078;
import net.minecraft.util.datafix.schemas.V3081;
import net.minecraft.util.datafix.schemas.V3082;
import net.minecraft.util.datafix.schemas.V3083;
import net.minecraft.util.datafix.schemas.V3202;
import net.minecraft.util.datafix.schemas.V3203;
import net.minecraft.util.datafix.schemas.V3204;
import net.minecraft.util.datafix.schemas.V3325;
import net.minecraft.util.datafix.schemas.V3326;
import net.minecraft.util.datafix.schemas.V3327;
import net.minecraft.util.datafix.schemas.V3328;
import net.minecraft.util.datafix.schemas.V3438;
import net.minecraft.util.datafix.schemas.V3439;
import net.minecraft.util.datafix.schemas.V3439_1;
import net.minecraft.util.datafix.schemas.V3448;
import net.minecraft.util.datafix.schemas.V3682;
import net.minecraft.util.datafix.schemas.V3683;
import net.minecraft.util.datafix.schemas.V3685;
import net.minecraft.util.datafix.schemas.V3689;
import net.minecraft.util.datafix.schemas.V3799;
import net.minecraft.util.datafix.schemas.V3807;
import net.minecraft.util.datafix.schemas.V3808;
import net.minecraft.util.datafix.schemas.V3808_1;
import net.minecraft.util.datafix.schemas.V3808_2;
import net.minecraft.util.datafix.schemas.V3813;
import net.minecraft.util.datafix.schemas.V3816;
import net.minecraft.util.datafix.schemas.V3818;
import net.minecraft.util.datafix.schemas.V3818_3;
import net.minecraft.util.datafix.schemas.V3818_4;
import net.minecraft.util.datafix.schemas.V3818_5;
import net.minecraft.util.datafix.schemas.V3825;
import net.minecraft.util.datafix.schemas.V3938;
import net.minecraft.util.datafix.schemas.V4059;
import net.minecraft.util.datafix.schemas.V4067;
import net.minecraft.util.datafix.schemas.V4070;
import net.minecraft.util.datafix.schemas.V4071;
import net.minecraft.util.datafix.schemas.V4290;
import net.minecraft.util.datafix.schemas.V4292;
import net.minecraft.util.datafix.schemas.V4300;
import net.minecraft.util.datafix.schemas.V4301;
import net.minecraft.util.datafix.schemas.V4302;
import net.minecraft.util.datafix.schemas.V4306;
import net.minecraft.util.datafix.schemas.V4307;
import net.minecraft.util.datafix.schemas.V4312;
import net.minecraft.util.datafix.schemas.V4420;
import net.minecraft.util.datafix.schemas.V4421;
import net.minecraft.util.datafix.schemas.V4531;
import net.minecraft.util.datafix.schemas.V4532;
import net.minecraft.util.datafix.schemas.V4533;
import net.minecraft.util.datafix.schemas.V4543;
import net.minecraft.util.datafix.schemas.V4648;
import net.minecraft.util.datafix.schemas.V4656;

public class DataConverterRegistry {
    private static final BiFunction<Integer, Schema, Schema> SAME = Schema::new;
    private static final BiFunction<Integer, Schema, Schema> SAME_NAMESPACED = DataConverterSchemaNamed::new;
    private static final DataFixerBuilder.Result DATA_FIXER = DataConverterRegistry.createFixerUpper();
    public static final int BLENDING_VERSION = 4295;

    private DataConverterRegistry() {
    }

    public static DataFixer getDataFixer() {
        return DATA_FIXER.fixer();
    }

    private static DataFixerBuilder.Result createFixerUpper() {
        DataFixerBuilder var0 = new DataFixerBuilder(SharedConstants.getCurrentVersion().dataVersion().version());
        DataConverterRegistry.addFixers(var0);
        return var0.build();
    }

    public static CompletableFuture<?> optimize(Set<DSL.TypeReference> var0) {
        if (var0.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        ExecutorService var1 = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Datafixer Bootstrap").setDaemon(true).setPriority(1).build());
        return DATA_FIXER.optimize(var0, (Executor)var1);
    }

    /*
     * WARNING - void declaration
     */
    private static void addFixers(DataFixerBuilder var02) {
        void var295;
        void var294;
        void var293;
        void var292;
        void var291;
        void var290;
        void var289;
        void var288;
        void var287;
        void var286;
        void var285;
        void var284;
        void var283;
        void var282;
        void var281;
        void var280;
        void var279;
        void var278;
        void var277;
        void var276;
        void var275;
        void var274;
        void var273;
        void var272;
        void var271;
        void var270;
        void var269;
        void var268;
        void var267;
        void var266;
        void var265;
        void var264;
        void var263;
        void var262;
        void var261;
        void var260;
        void var259;
        void var258;
        void var257;
        void var256;
        var02.addSchema(99, DataConverterSchemaV99::new);
        Schema var12 = var02.addSchema(100, DataConverterSchemaV100::new);
        var02.addFixer((DataFix)new DataConverterEquipment(var12));
        Schema var2 = var02.addSchema(101, SAME);
        var02.addFixer((DataFix)new VillagerSetCanPickUpLootFix(var2));
        Schema var3 = var02.addSchema(102, DataConverterSchemaV102::new);
        var02.addFixer((DataFix)new DataConverterMaterialId(var3, true));
        var02.addFixer((DataFix)new DataConverterPotionId(var3, false));
        Schema var4 = var02.addSchema(105, SAME);
        var02.addFixer((DataFix)new DataConverterSpawnEgg(var4, true));
        Schema var5 = var02.addSchema(106, DataConverterSchemaV106::new);
        var02.addFixer((DataFix)new DataConverterMobSpawner(var5, true));
        Schema var6 = var02.addSchema(107, DataConverterSchemaV107::new);
        var02.addFixer((DataFix)new DataConverterMinecart(var6));
        Schema var7 = var02.addSchema(108, SAME);
        var02.addFixer((DataFix)new DataConverterUUID(var7, true));
        Schema var8 = var02.addSchema(109, SAME);
        var02.addFixer((DataFix)new DataConverterHealth(var8, true));
        Schema var9 = var02.addSchema(110, SAME);
        var02.addFixer((DataFix)new DataConverterSaddle(var9, true));
        Schema var10 = var02.addSchema(111, SAME);
        var02.addFixer((DataFix)new DataConverterHanging(var10, true));
        Schema var11 = var02.addSchema(113, SAME);
        var02.addFixer((DataFix)new DataConverterDropChances(var11, true));
        Schema var122 = var02.addSchema(135, DataConverterSchemaV135::new);
        var02.addFixer((DataFix)new DataConverterRiding(var122, true));
        Schema var13 = var02.addSchema(143, DataConverterSchemaV143::new);
        var02.addFixer((DataFix)new DataConverterEntityTippedArrow(var13, true));
        Schema var14 = var02.addSchema(147, SAME);
        var02.addFixer((DataFix)new DataConverterArmorStand(var14, true));
        Schema var15 = var02.addSchema(165, SAME);
        var02.addFixer((DataFix)new SignTextStrictJsonFix(var15));
        var02.addFixer((DataFix)new WrittenBookPagesStrictJsonFix(var15));
        Schema var16 = var02.addSchema(501, DataConverterSchemaV501::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var16, "Add 1.10 entities fix", DataConverterTypes.ENTITY));
        Schema var17 = var02.addSchema(502, SAME);
        var02.addFixer(DataConverterItemName.create(var17, "cooked_fished item renamer", var0 -> Objects.equals(DataConverterSchemaNamed.ensureNamespaced(var0), "minecraft:cooked_fished") ? "minecraft:cooked_fish" : var0));
        var02.addFixer((DataFix)new DataConverterZombie(var17, false));
        Schema var18 = var02.addSchema(505, SAME);
        var02.addFixer((DataFix)new DataConverterVBO(var18, false));
        Schema var19 = var02.addSchema(700, DataConverterSchemaV700::new);
        var02.addFixer((DataFix)new DataConverterGuardian(var19, true));
        Schema var20 = var02.addSchema(701, DataConverterSchemaV701::new);
        var02.addFixer((DataFix)new DataConverterSkeleton(var20, true));
        Schema var21 = var02.addSchema(702, DataConverterSchemaV702::new);
        var02.addFixer((DataFix)new DataConverterZombieType(var21));
        Schema var22 = var02.addSchema(703, DataConverterSchemaV703::new);
        var02.addFixer((DataFix)new DataConverterHorse(var22, true));
        Schema var23 = var02.addSchema(704, DataConverterSchemaV704::new);
        var02.addFixer((DataFix)new DataConverterTileEntity(var23, true));
        Schema var24 = var02.addSchema(705, DataConverterSchemaV705::new);
        var02.addFixer((DataFix)new DataConverterEntity(var24, true));
        Schema var25 = var02.addSchema(804, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterBanner(var25, true));
        Schema var26 = var02.addSchema(806, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterPotionWater(var26, false));
        Schema var27 = var02.addSchema(808, DataConverterSchemaV808::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var27, "added shulker box", DataConverterTypes.BLOCK_ENTITY));
        Schema var28 = var02.addSchema(808, 1, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterShulker(var28, false));
        Schema var29 = var02.addSchema(813, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterShulkerBoxItem(var29, false));
        var02.addFixer((DataFix)new DataConverterShulkerBoxBlock(var29, false));
        Schema var30 = var02.addSchema(816, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterLang(var30, false));
        Schema var31 = var02.addSchema(820, SAME_NAMESPACED);
        var02.addFixer(DataConverterItemName.create(var31, "totem item renamer", DataConverterRegistry.createRenamer("minecraft:totem", "minecraft:totem_of_undying")));
        Schema var32 = var02.addSchema(1022, DataConverterSchemaV1022::new);
        var02.addFixer((DataFix)new DataConverterShoulderEntity(var32, "added shoulder entities to players", DataConverterTypes.PLAYER));
        Schema var33 = var02.addSchema(1125, DataConverterSchemaV1125::new);
        var02.addFixer((DataFix)new DataConverterBedBlock(var33, true));
        var02.addFixer((DataFix)new DataConverterBedItem(var33, false));
        Schema var34 = var02.addSchema(1344, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterKeybind(var34, false));
        Schema var35 = var02.addSchema(1446, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterKeybind2(var35, false));
        Schema var36 = var02.addSchema(1450, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterFlattenState(var36, false));
        Schema var37 = var02.addSchema(1451, DataConverterSchemaV1451::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var37, "AddTrappedChestFix", DataConverterTypes.BLOCK_ENTITY));
        Schema var38 = var02.addSchema(1451, 1, DataConverterSchemaV1451_1::new);
        var02.addFixer((DataFix)new ChunkConverterPalette(var38, true));
        Schema var39 = var02.addSchema(1451, 2, DataConverterSchemaV1451_2::new);
        var02.addFixer((DataFix)new DataConverterPiston(var39, true));
        Schema var40 = var02.addSchema(1451, 3, DataConverterSchemaV1451_3::new);
        var02.addFixer((DataFix)new DataConverterEntityBlockState(var40, true));
        var02.addFixer((DataFix)new DataConverterMap(var40, false));
        Schema var41 = var02.addSchema(1451, 4, DataConverterSchemaV1451_4::new);
        var02.addFixer((DataFix)new DataConverterBlockName(var41, true));
        var02.addFixer((DataFix)new DataConverterFlatten(var41, false));
        Schema var42 = var02.addSchema(1451, 5, DataConverterSchemaV1451_5::new);
        var02.addFixer((DataFix)new RemoveBlockEntityTagFix(var42, Set.of("minecraft:noteblock", "minecraft:flower_pot")));
        var02.addFixer((DataFix)new DataConverterFlattenSpawnEgg(var42, false, "minecraft:spawn_egg"));
        var02.addFixer((DataFix)new DataConverterWolf(var42, false));
        var02.addFixer((DataFix)new DataConverterBannerColour(var42, false));
        var02.addFixer((DataFix)new DataConverterWorldGenSettings(var42, false));
        Schema var43 = var02.addSchema(1451, 6, DataConverterSchemaV1451_6::new);
        var02.addFixer((DataFix)new DataConverterStatistic(var43, true));
        var02.addFixer((DataFix)new DataConverterJukeBox(var43, false));
        Schema var44 = var02.addSchema(1451, 7, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterVillagerTrade(var44));
        Schema var45 = var02.addSchema(1456, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterItemFrame(var45, false));
        Schema var46 = var02.addSchema(1458, V1458::new);
        var02.addFixer((DataFix)new DataConverterCustomNameEntity(var46));
        var02.addFixer((DataFix)new DataConverterCustomNameItem(var46));
        var02.addFixer((DataFix)new DataConverterCustomNameTile(var46));
        Schema var47 = var02.addSchema(1460, DataConverterSchemaV1460::new);
        var02.addFixer((DataFix)new DataConverterPainting(var47, false));
        Schema var48 = var02.addSchema(1466, DataConverterSchemaV1466::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var48, "Add DUMMY block entity", DataConverterTypes.BLOCK_ENTITY));
        var02.addFixer((DataFix)new DataConverterProtoChunk(var48, true));
        Schema var49 = var02.addSchema(1470, DataConverterSchemaV1470::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var49, "Add 1.13 entities fix", DataConverterTypes.ENTITY));
        Schema var50 = var02.addSchema(1474, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterColorlessShulkerEntity(var50, false));
        var02.addFixer(DataConverterBlockRename.create(var50, "Colorless shulker block fixer", var0 -> Objects.equals(DataConverterSchemaNamed.ensureNamespaced(var0), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : var0));
        var02.addFixer(DataConverterItemName.create(var50, "Colorless shulker item fixer", var0 -> Objects.equals(DataConverterSchemaNamed.ensureNamespaced(var0), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : var0));
        Schema var51 = var02.addSchema(1475, SAME_NAMESPACED);
        var02.addFixer(DataConverterBlockRename.create(var51, "Flowing fixer", DataConverterRegistry.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:flowing_water", (Object)"minecraft:water", (Object)"minecraft:flowing_lava", (Object)"minecraft:lava"))));
        Schema var52 = var02.addSchema(1480, SAME_NAMESPACED);
        var02.addFixer(DataConverterBlockRename.create(var52, "Rename coral blocks", DataConverterRegistry.createRenamer(DataConverterCoral.RENAMED_IDS)));
        var02.addFixer(DataConverterItemName.create(var52, "Rename coral items", DataConverterRegistry.createRenamer(DataConverterCoral.RENAMED_IDS)));
        Schema var53 = var02.addSchema(1481, DataConverterSchemaV1481::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var53, "Add conduit", DataConverterTypes.BLOCK_ENTITY));
        Schema var54 = var02.addSchema(1483, DataConverterSchemaV1483::new);
        var02.addFixer((DataFix)new DataConverterEntityPufferfish(var54, true));
        var02.addFixer(DataConverterItemName.create(var54, "Rename pufferfish egg item", DataConverterRegistry.createRenamer(DataConverterEntityPufferfish.RENAMED_IDS)));
        Schema var55 = var02.addSchema(1484, SAME_NAMESPACED);
        var02.addFixer(DataConverterItemName.create(var55, "Rename seagrass items", DataConverterRegistry.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"))));
        var02.addFixer(DataConverterBlockRename.create(var55, "Rename seagrass blocks", DataConverterRegistry.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"))));
        var02.addFixer((DataFix)new DataConverterHeightmapRenaming(var55, false));
        Schema var56 = var02.addSchema(1486, DataConverterSchemaV1486::new);
        var02.addFixer((DataFix)new DataConverterEntityCodSalmon(var56, true));
        var02.addFixer(DataConverterItemName.create(var56, "Rename cod/salmon egg items", DataConverterRegistry.createRenamer(DataConverterEntityCodSalmon.RENAMED_EGG_IDS)));
        Schema var57 = var02.addSchema(1487, SAME_NAMESPACED);
        var02.addFixer(DataConverterItemName.create(var57, "Rename prismarine_brick(s)_* blocks", DataConverterRegistry.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab", (Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs"))));
        var02.addFixer(DataConverterBlockRename.create(var57, "Rename prismarine_brick(s)_* items", DataConverterRegistry.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab", (Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs"))));
        Schema var58 = var02.addSchema(1488, V1488::new);
        var02.addFixer(DataConverterBlockRename.create(var58, "Rename kelp/kelptop", DataConverterRegistry.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:kelp_top", (Object)"minecraft:kelp", (Object)"minecraft:kelp", (Object)"minecraft:kelp_plant"))));
        var02.addFixer(DataConverterItemName.create(var58, "Rename kelptop", DataConverterRegistry.createRenamer("minecraft:kelp_top", "minecraft:kelp")));
        var02.addFixer((DataFix)new NamedEntityWriteReadFix(var58, true, "Command block block entity custom name fix", DataConverterTypes.BLOCK_ENTITY, "minecraft:command_block"){

            @Override
            protected <T> Dynamic<T> fix(Dynamic<T> var0) {
                return DataConverterCustomNameTile.fixTagCustomName(var0);
            }
        });
        var02.addFixer(new DataFix(var58, false){

            protected TypeRewriteRule makeRule() {
                Type var0 = this.getInputSchema().getType(DataConverterTypes.ENTITY);
                OpticFinder var1 = DSL.fieldFinder((String)"id", DataConverterSchemaNamed.namespacedString());
                OpticFinder var2 = var0.findField("CustomName");
                OpticFinder var32 = DSL.typeFinder((Type)this.getInputSchema().getType(DataConverterTypes.TEXT_COMPONENT));
                return this.fixTypeEverywhereTyped("Command block minecart custom name fix", var0, var3 -> {
                    String var4 = var3.getOptional(var1).orElse("");
                    if (!"minecraft:commandblock_minecart".equals(var4)) {
                        return var3;
                    }
                    return var3.updateTyped(var2, var1 -> var1.update(var32, var0 -> var0.mapSecond(LegacyComponentDataFixUtils::createTextComponentJson)));
                });
            }
        });
        var02.addFixer((DataFix)new DataConverterIglooMetadataRemoval(var58, false));
        Schema var59 = var02.addSchema(1490, SAME_NAMESPACED);
        var02.addFixer(DataConverterBlockRename.create(var59, "Rename melon_block", DataConverterRegistry.createRenamer("minecraft:melon_block", "minecraft:melon")));
        var02.addFixer(DataConverterItemName.create(var59, "Rename melon_block/melon/speckled_melon", DataConverterRegistry.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:melon_block", (Object)"minecraft:melon", (Object)"minecraft:melon", (Object)"minecraft:melon_slice", (Object)"minecraft:speckled_melon", (Object)"minecraft:glistering_melon_slice"))));
        Schema var60 = var02.addSchema(1492, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterChunkStructuresTemplateRename(var60, false));
        Schema var61 = var02.addSchema(1494, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterItemStackEnchantment(var61, false));
        Schema var62 = var02.addSchema(1496, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterLeaves(var62, false));
        Schema var63 = var02.addSchema(1500, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterBlockEntityKeepPacked(var63, false));
        Schema var64 = var02.addSchema(1501, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterAdvancement(var64, false));
        Schema var65 = var02.addSchema(1502, SAME_NAMESPACED);
        var02.addFixer((DataFix)new NamespacedTypeRenameFix(var65, "Recipes fix", DataConverterTypes.RECIPE, DataConverterRegistry.createRenamer(DataConverterRecipes.RECIPES)));
        Schema var66 = var02.addSchema(1506, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterLevelDataGeneratorOptions(var66, false));
        Schema var67 = var02.addSchema(1510, DataConverterSchemaV1510::new);
        var02.addFixer(DataConverterBlockRename.create(var67, "Block renamening fix", DataConverterRegistry.createRenamer(DataConverterEntityRename.RENAMED_BLOCKS)));
        var02.addFixer(DataConverterItemName.create(var67, "Item renamening fix", DataConverterRegistry.createRenamer(DataConverterEntityRename.RENAMED_ITEMS)));
        var02.addFixer((DataFix)new NamespacedTypeRenameFix(var67, "Recipes renamening fix", DataConverterTypes.RECIPE, DataConverterRegistry.createRenamer(DataConverterRecipeRename.RECIPES)));
        var02.addFixer((DataFix)new DataConverterEntityRename(var67, true));
        var02.addFixer((DataFix)new StatsRenameFix(var67, "SwimStatsRenameFix", (Map<String, String>)ImmutableMap.of((Object)"minecraft:swim_one_cm", (Object)"minecraft:walk_on_water_one_cm", (Object)"minecraft:dive_one_cm", (Object)"minecraft:walk_under_water_one_cm")));
        Schema var68 = var02.addSchema(1514, SAME_NAMESPACED);
        var02.addFixer((DataFix)new ScoreboardDisplayNameFix(var68, "ObjectiveDisplayNameFix", DataConverterTypes.OBJECTIVE));
        var02.addFixer((DataFix)new ScoreboardDisplayNameFix(var68, "TeamDisplayNameFix", DataConverterTypes.TEAM));
        var02.addFixer((DataFix)new DataConverterObjectiveRenderType(var68));
        Schema var69 = var02.addSchema(1515, SAME_NAMESPACED);
        var02.addFixer(DataConverterBlockRename.create(var69, "Rename coral fan blocks", DataConverterRegistry.createRenamer(DataConverterCoralFan.RENAMED_IDS)));
        Schema var70 = var02.addSchema(1624, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterTrappedChest(var70, false));
        Schema var71 = var02.addSchema(1800, DataConverterSchemaV1800::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var71, "Added 1.14 mobs fix", DataConverterTypes.ENTITY));
        var02.addFixer(DataConverterItemName.create(var71, "Rename dye items", DataConverterRegistry.createRenamer(DataConverterDye.RENAMED_IDS)));
        Schema var72 = var02.addSchema(1801, DataConverterSchemaV1801::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var72, "Added Illager Beast", DataConverterTypes.ENTITY));
        Schema var73 = var02.addSchema(1802, SAME_NAMESPACED);
        var02.addFixer(DataConverterBlockRename.create(var73, "Rename sign blocks & stone slabs", DataConverterRegistry.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign", (Object)"minecraft:wall_sign", (Object)"minecraft:oak_wall_sign"))));
        var02.addFixer(DataConverterItemName.create(var73, "Rename sign item & stone slabs", DataConverterRegistry.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign"))));
        Schema var74 = var02.addSchema(1803, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterItemLoreComponentize(var74));
        Schema var75 = var02.addSchema(1904, DataConverterSchemaV1904::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var75, "Added Cats", DataConverterTypes.ENTITY));
        var02.addFixer((DataFix)new DataConverterEntityCatSplit(var75, false));
        Schema var76 = var02.addSchema(1905, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterChunkStatus(var76, false));
        Schema var77 = var02.addSchema(1906, DataConverterSchemaV1906::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var77, "Add POI Blocks", DataConverterTypes.BLOCK_ENTITY));
        Schema var78 = var02.addSchema(1909, DataConverterSchemaV1909::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var78, "Add jigsaw", DataConverterTypes.BLOCK_ENTITY));
        Schema var79 = var02.addSchema(1911, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterChunkStatus2(var79, false));
        Schema var80 = var02.addSchema(1914, SAME_NAMESPACED);
        var02.addFixer((DataFix)new WeaponSmithChestLootTableFix(var80, false));
        Schema var81 = var02.addSchema(1917, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterCatType(var81, false));
        Schema var82 = var02.addSchema(1918, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterVillagerProfession(var82, "minecraft:villager"));
        var02.addFixer((DataFix)new DataConverterVillagerProfession(var82, "minecraft:zombie_villager"));
        Schema var83 = var02.addSchema(1920, DataConverterSchemaV1920::new);
        var02.addFixer((DataFix)new DataConverterNewVillage(var83, false));
        var02.addFixer((DataFix)new DataConverterAddChoices(var83, "Add campfire", DataConverterTypes.BLOCK_ENTITY));
        Schema var84 = var02.addSchema(1925, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterMapId(var84));
        Schema var85 = var02.addSchema(1928, DataConverterSchemaV1928::new);
        var02.addFixer((DataFix)new DataConverterEntityRavagerRename(var85, true));
        var02.addFixer(DataConverterItemName.create(var85, "Rename ravager egg item", DataConverterRegistry.createRenamer(DataConverterEntityRavagerRename.RENAMED_IDS)));
        Schema var86 = var02.addSchema(1929, DataConverterSchemaV1929::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var86, "Add Wandering Trader and Trader Llama", DataConverterTypes.ENTITY));
        Schema var87 = var02.addSchema(1931, DataConverterSchemaV1931::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var87, "Added Fox", DataConverterTypes.ENTITY));
        Schema var88 = var02.addSchema(1936, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterOptionsAddTextBackground(var88, false));
        Schema var89 = var02.addSchema(1946, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterPOI(var89, false));
        Schema var90 = var02.addSchema(1948, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterOminousBannerRename(var90));
        Schema var91 = var02.addSchema(1953, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterOminousBannerBlockEntityRename(var91, false));
        Schema var92 = var02.addSchema(1955, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterVillagerLevelXp(var92, false));
        var02.addFixer((DataFix)new DataConverterZombieVillagerLevelXp(var92, false));
        Schema var93 = var02.addSchema(1961, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterChunkLightRemove(var93, false));
        Schema var94 = var02.addSchema(1963, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterRemoveGolemGossip(var94, false));
        Schema var95 = var02.addSchema(2100, DataConverterSchemaV2100::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var95, "Added Bee and Bee Stinger", DataConverterTypes.ENTITY));
        var02.addFixer((DataFix)new DataConverterAddChoices(var95, "Add beehive", DataConverterTypes.BLOCK_ENTITY));
        var02.addFixer((DataFix)new NamespacedTypeRenameFix(var95, "Rename sugar recipe", DataConverterTypes.RECIPE, DataConverterRegistry.createRenamer("minecraft:sugar", "minecraft:sugar_from_sugar_cane")));
        var02.addFixer((DataFix)new DataConverterAdvancementBase(var95, false, "Rename sugar recipe advancement", DataConverterRegistry.createRenamer("minecraft:recipes/misc/sugar", "minecraft:recipes/misc/sugar_from_sugar_cane")));
        Schema var96 = var02.addSchema(2202, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterLeavesBiome(var96, false));
        Schema var97 = var02.addSchema(2209, SAME_NAMESPACED);
        UnaryOperator<String> var98 = DataConverterRegistry.createRenamer("minecraft:bee_hive", "minecraft:beehive");
        var02.addFixer(DataConverterItemName.create(var97, "Rename bee_hive item to beehive", var98));
        var02.addFixer((DataFix)new PoiTypeRenameFix(var97, "Rename bee_hive poi to beehive", var98));
        var02.addFixer(DataConverterBlockRename.create(var97, "Rename bee_hive block to beehive", var98));
        Schema var99 = var02.addSchema(2211, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterStructureReference(var99, false));
        Schema var100 = var02.addSchema(2218, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterPOIRebuild(var100, false));
        Schema var101 = var02.addSchema(2501, DataConverterSchemaV2501::new);
        var02.addFixer((DataFix)new DataConverterFurnaceRecipesUsed(var101, true));
        Schema var102 = var02.addSchema(2502, DataConverterSchemaV2502::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var102, "Added Hoglin", DataConverterTypes.ENTITY));
        Schema var103 = var02.addSchema(2503, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterWallProperty(var103, false));
        var02.addFixer((DataFix)new DataConverterAdvancementBase(var103, false, "Composter category change", DataConverterRegistry.createRenamer("minecraft:recipes/misc/composter", "minecraft:recipes/decorations/composter")));
        Schema var104 = var02.addSchema(2505, DataConverterSchemaV2505::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var104, "Added Piglin", DataConverterTypes.ENTITY));
        var02.addFixer((DataFix)new DataConverterMemoryExpiry(var104, "minecraft:villager"));
        Schema var105 = var02.addSchema(2508, SAME_NAMESPACED);
        var02.addFixer(DataConverterItemName.create(var105, "Renamed fungi items to fungus", DataConverterRegistry.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:warped_fungi", (Object)"minecraft:warped_fungus", (Object)"minecraft:crimson_fungi", (Object)"minecraft:crimson_fungus"))));
        var02.addFixer(DataConverterBlockRename.create(var105, "Renamed fungi blocks to fungus", DataConverterRegistry.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:warped_fungi", (Object)"minecraft:warped_fungus", (Object)"minecraft:crimson_fungi", (Object)"minecraft:crimson_fungus"))));
        Schema var106 = var02.addSchema(2509, DataConverterSchemaV2509::new);
        var02.addFixer((DataFix)new DataConverterEntityZombifiedPiglinRename(var106));
        var02.addFixer(DataConverterItemName.create(var106, "Rename zombie pigman egg item", DataConverterRegistry.createRenamer(DataConverterEntityZombifiedPiglinRename.RENAMED_IDS)));
        Schema var107 = var02.addSchema(2511, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterEntityProjectileOwner(var107));
        Schema var108 = var02.addSchema(2511, 1, V2511_1::new);
        var02.addFixer((DataFix)new NamedEntityConvertUncheckedFix(var108, "SplashPotionItemFieldRenameFix", DataConverterTypes.ENTITY, "minecraft:potion"));
        Schema var109 = var02.addSchema(2514, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterEntityUUID(var109));
        var02.addFixer((DataFix)new DataConverterBlockEntityUUID(var109));
        var02.addFixer((DataFix)new DataConverterPlayerUUID(var109));
        var02.addFixer((DataFix)new DataConverterMiscUUID(var109));
        var02.addFixer((DataFix)new DataConverterSavedDataUUID(var109));
        var02.addFixer((DataFix)new DataConverterItemStackUUID(var109));
        Schema var110 = var02.addSchema(2516, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterGossip(var110, "minecraft:villager"));
        var02.addFixer((DataFix)new DataConverterGossip(var110, "minecraft:zombie_villager"));
        Schema var111 = var02.addSchema(2518, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterJigsawProperties(var111, false));
        var02.addFixer((DataFix)new DataConverterJigsawRotation(var111));
        Schema var112 = var02.addSchema(2519, DataConverterSchemaV2519::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var112, "Added Strider", DataConverterTypes.ENTITY));
        Schema var113 = var02.addSchema(2522, DataConverterSchemaV2522::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var113, "Added Zoglin", DataConverterTypes.ENTITY));
        Schema var114 = var02.addSchema(2523, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterAttributes(var114, "Attribute renames", DataConverterRegistry.createRenamerNoNamespace((Map<String, String>)ImmutableMap.builder().put((Object)"generic.maxHealth", (Object)"minecraft:generic.max_health").put((Object)"Max Health", (Object)"minecraft:generic.max_health").put((Object)"zombie.spawnReinforcements", (Object)"minecraft:zombie.spawn_reinforcements").put((Object)"Spawn Reinforcements Chance", (Object)"minecraft:zombie.spawn_reinforcements").put((Object)"horse.jumpStrength", (Object)"minecraft:horse.jump_strength").put((Object)"Jump Strength", (Object)"minecraft:horse.jump_strength").put((Object)"generic.followRange", (Object)"minecraft:generic.follow_range").put((Object)"Follow Range", (Object)"minecraft:generic.follow_range").put((Object)"generic.knockbackResistance", (Object)"minecraft:generic.knockback_resistance").put((Object)"Knockback Resistance", (Object)"minecraft:generic.knockback_resistance").put((Object)"generic.movementSpeed", (Object)"minecraft:generic.movement_speed").put((Object)"Movement Speed", (Object)"minecraft:generic.movement_speed").put((Object)"generic.flyingSpeed", (Object)"minecraft:generic.flying_speed").put((Object)"Flying Speed", (Object)"minecraft:generic.flying_speed").put((Object)"generic.attackDamage", (Object)"minecraft:generic.attack_damage").put((Object)"generic.attackKnockback", (Object)"minecraft:generic.attack_knockback").put((Object)"generic.attackSpeed", (Object)"minecraft:generic.attack_speed").put((Object)"generic.armorToughness", (Object)"minecraft:generic.armor_toughness").build())));
        Schema var115 = var02.addSchema(2527, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterBitStorageAlign(var115));
        Schema var116 = var02.addSchema(2528, SAME_NAMESPACED);
        var02.addFixer(DataConverterItemName.create(var116, "Rename soul fire torch and soul fire lantern", DataConverterRegistry.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:soul_fire_torch", (Object)"minecraft:soul_torch", (Object)"minecraft:soul_fire_lantern", (Object)"minecraft:soul_lantern"))));
        var02.addFixer(DataConverterBlockRename.create(var116, "Rename soul fire torch and soul fire lantern", DataConverterRegistry.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:soul_fire_torch", (Object)"minecraft:soul_torch", (Object)"minecraft:soul_fire_wall_torch", (Object)"minecraft:soul_wall_torch", (Object)"minecraft:soul_fire_lantern", (Object)"minecraft:soul_lantern"))));
        Schema var117 = var02.addSchema(2529, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterStriderGravity(var117, false));
        Schema var118 = var02.addSchema(2531, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterRedstoneConnections(var118));
        Schema var119 = var02.addSchema(2533, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterVillagerFollowRange(var119));
        Schema var120 = var02.addSchema(2535, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterEntityShulkerRotation(var120));
        Schema var121 = var02.addSchema(2537, SAME_NAMESPACED);
        var02.addFixer((DataFix)new LegacyDimensionIdFix(var121));
        Schema var1222 = var02.addSchema(2538, SAME_NAMESPACED);
        var02.addFixer((DataFix)new LevelLegacyWorldGenSettingsFix(var1222));
        Schema var123 = var02.addSchema(2550, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterWorldGenSettingsBuilding(var123));
        Schema var124 = var02.addSchema(2551, DataConverterSchemaV2551::new);
        var02.addFixer((DataFix)new DataConverterShoulderEntity(var124, "add types to WorldGenData", DataConverterTypes.WORLD_GEN_SETTINGS));
        Schema var125 = var02.addSchema(2552, SAME_NAMESPACED);
        var02.addFixer((DataFix)new NamespacedTypeRenameFix(var125, "Nether biome rename", DataConverterTypes.BIOME, DataConverterRegistry.createRenamer("minecraft:nether", "minecraft:nether_wastes")));
        Schema var126 = var02.addSchema(2553, SAME_NAMESPACED);
        var02.addFixer((DataFix)new NamespacedTypeRenameFix(var126, "Biomes fix", DataConverterTypes.BIOME, DataConverterRegistry.createRenamer(DataConverterBiome.BIOMES)));
        Schema var127 = var02.addSchema(2556, SAME_NAMESPACED);
        var02.addFixer((DataFix)new OptionsFancyGraphicsToGraphicsModeFix(var127));
        Schema var128 = var02.addSchema(2558, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterMissingDimension(var128, false));
        var02.addFixer((DataFix)new DataConverterSettingRename(var128, false, "Rename swapHands setting", "key_key.swapHands", "key_key.swapOffhand"));
        Schema var129 = var02.addSchema(2568, DataConverterSchemaV2568::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var129, "Added Piglin Brute", DataConverterTypes.ENTITY));
        Schema var130 = var02.addSchema(2571, V2571::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var130, "Added Goat", DataConverterTypes.ENTITY));
        Schema var131 = var02.addSchema(2679, SAME_NAMESPACED);
        var02.addFixer((DataFix)new CauldronRenameFix(var131, false));
        Schema var132 = var02.addSchema(2680, SAME_NAMESPACED);
        var02.addFixer(DataConverterItemName.create(var132, "Renamed grass path item to dirt path", DataConverterRegistry.createRenamer("minecraft:grass_path", "minecraft:dirt_path")));
        var02.addFixer(DataConverterBlockRename.create(var132, "Renamed grass path block to dirt path", DataConverterRegistry.createRenamer("minecraft:grass_path", "minecraft:dirt_path")));
        Schema var133 = var02.addSchema(2684, V2684::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var133, "Added Sculk Sensor", DataConverterTypes.BLOCK_ENTITY));
        Schema var134 = var02.addSchema(2686, V2686::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var134, "Added Axolotl", DataConverterTypes.ENTITY));
        Schema var135 = var02.addSchema(2688, V2688::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var135, "Added Glow Squid", DataConverterTypes.ENTITY));
        var02.addFixer((DataFix)new DataConverterAddChoices(var135, "Added Glow Item Frame", DataConverterTypes.ENTITY));
        Schema var136 = var02.addSchema(2690, SAME_NAMESPACED);
        ImmutableMap var137 = ImmutableMap.builder().put((Object)"minecraft:weathered_copper_block", (Object)"minecraft:oxidized_copper_block").put((Object)"minecraft:semi_weathered_copper_block", (Object)"minecraft:weathered_copper_block").put((Object)"minecraft:lightly_weathered_copper_block", (Object)"minecraft:exposed_copper_block").put((Object)"minecraft:weathered_cut_copper", (Object)"minecraft:oxidized_cut_copper").put((Object)"minecraft:semi_weathered_cut_copper", (Object)"minecraft:weathered_cut_copper").put((Object)"minecraft:lightly_weathered_cut_copper", (Object)"minecraft:exposed_cut_copper").put((Object)"minecraft:weathered_cut_copper_stairs", (Object)"minecraft:oxidized_cut_copper_stairs").put((Object)"minecraft:semi_weathered_cut_copper_stairs", (Object)"minecraft:weathered_cut_copper_stairs").put((Object)"minecraft:lightly_weathered_cut_copper_stairs", (Object)"minecraft:exposed_cut_copper_stairs").put((Object)"minecraft:weathered_cut_copper_slab", (Object)"minecraft:oxidized_cut_copper_slab").put((Object)"minecraft:semi_weathered_cut_copper_slab", (Object)"minecraft:weathered_cut_copper_slab").put((Object)"minecraft:lightly_weathered_cut_copper_slab", (Object)"minecraft:exposed_cut_copper_slab").put((Object)"minecraft:waxed_semi_weathered_copper", (Object)"minecraft:waxed_weathered_copper").put((Object)"minecraft:waxed_lightly_weathered_copper", (Object)"minecraft:waxed_exposed_copper").put((Object)"minecraft:waxed_semi_weathered_cut_copper", (Object)"minecraft:waxed_weathered_cut_copper").put((Object)"minecraft:waxed_lightly_weathered_cut_copper", (Object)"minecraft:waxed_exposed_cut_copper").put((Object)"minecraft:waxed_semi_weathered_cut_copper_stairs", (Object)"minecraft:waxed_weathered_cut_copper_stairs").put((Object)"minecraft:waxed_lightly_weathered_cut_copper_stairs", (Object)"minecraft:waxed_exposed_cut_copper_stairs").put((Object)"minecraft:waxed_semi_weathered_cut_copper_slab", (Object)"minecraft:waxed_weathered_cut_copper_slab").put((Object)"minecraft:waxed_lightly_weathered_cut_copper_slab", (Object)"minecraft:waxed_exposed_cut_copper_slab").build();
        var02.addFixer(DataConverterItemName.create(var136, "Renamed copper block items to new oxidized terms", DataConverterRegistry.createRenamer((Map<String, String>)var137)));
        var02.addFixer(DataConverterBlockRename.create(var136, "Renamed copper blocks to new oxidized terms", DataConverterRegistry.createRenamer((Map<String, String>)var137)));
        Schema var138 = var02.addSchema(2691, SAME_NAMESPACED);
        ImmutableMap var139 = ImmutableMap.builder().put((Object)"minecraft:waxed_copper", (Object)"minecraft:waxed_copper_block").put((Object)"minecraft:oxidized_copper_block", (Object)"minecraft:oxidized_copper").put((Object)"minecraft:weathered_copper_block", (Object)"minecraft:weathered_copper").put((Object)"minecraft:exposed_copper_block", (Object)"minecraft:exposed_copper").build();
        var02.addFixer(DataConverterItemName.create(var138, "Rename copper item suffixes", DataConverterRegistry.createRenamer((Map<String, String>)var139)));
        var02.addFixer(DataConverterBlockRename.create(var138, "Rename copper blocks suffixes", DataConverterRegistry.createRenamer((Map<String, String>)var139)));
        Schema var140 = var02.addSchema(2693, SAME_NAMESPACED);
        var02.addFixer((DataFix)new AddFlagIfNotPresentFix(var140, DataConverterTypes.WORLD_GEN_SETTINGS, "has_increased_height_already", false));
        Schema var141 = var02.addSchema(2696, SAME_NAMESPACED);
        ImmutableMap var142 = ImmutableMap.builder().put((Object)"minecraft:grimstone", (Object)"minecraft:deepslate").put((Object)"minecraft:grimstone_slab", (Object)"minecraft:cobbled_deepslate_slab").put((Object)"minecraft:grimstone_stairs", (Object)"minecraft:cobbled_deepslate_stairs").put((Object)"minecraft:grimstone_wall", (Object)"minecraft:cobbled_deepslate_wall").put((Object)"minecraft:polished_grimstone", (Object)"minecraft:polished_deepslate").put((Object)"minecraft:polished_grimstone_slab", (Object)"minecraft:polished_deepslate_slab").put((Object)"minecraft:polished_grimstone_stairs", (Object)"minecraft:polished_deepslate_stairs").put((Object)"minecraft:polished_grimstone_wall", (Object)"minecraft:polished_deepslate_wall").put((Object)"minecraft:grimstone_tiles", (Object)"minecraft:deepslate_tiles").put((Object)"minecraft:grimstone_tile_slab", (Object)"minecraft:deepslate_tile_slab").put((Object)"minecraft:grimstone_tile_stairs", (Object)"minecraft:deepslate_tile_stairs").put((Object)"minecraft:grimstone_tile_wall", (Object)"minecraft:deepslate_tile_wall").put((Object)"minecraft:grimstone_bricks", (Object)"minecraft:deepslate_bricks").put((Object)"minecraft:grimstone_brick_slab", (Object)"minecraft:deepslate_brick_slab").put((Object)"minecraft:grimstone_brick_stairs", (Object)"minecraft:deepslate_brick_stairs").put((Object)"minecraft:grimstone_brick_wall", (Object)"minecraft:deepslate_brick_wall").put((Object)"minecraft:chiseled_grimstone", (Object)"minecraft:chiseled_deepslate").build();
        var02.addFixer(DataConverterItemName.create(var141, "Renamed grimstone block items to deepslate", DataConverterRegistry.createRenamer((Map<String, String>)var142)));
        var02.addFixer(DataConverterBlockRename.create(var141, "Renamed grimstone blocks to deepslate", DataConverterRegistry.createRenamer((Map<String, String>)var142)));
        Schema var143 = var02.addSchema(2700, SAME_NAMESPACED);
        var02.addFixer(DataConverterBlockRename.create(var143, "Renamed cave vines blocks", DataConverterRegistry.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:cave_vines_head", (Object)"minecraft:cave_vines", (Object)"minecraft:cave_vines_body", (Object)"minecraft:cave_vines_plant"))));
        Schema var144 = var02.addSchema(2701, SAME_NAMESPACED);
        var02.addFixer((DataFix)new SavedDataFeaturePoolElementFix(var144));
        Schema var145 = var02.addSchema(2702, SAME_NAMESPACED);
        var02.addFixer((DataFix)new AbstractArrowPickupFix(var145));
        Schema var146 = var02.addSchema(2704, V2704::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var146, "Added Goat", DataConverterTypes.ENTITY));
        Schema var147 = var02.addSchema(2707, V2707::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var147, "Added Marker", DataConverterTypes.ENTITY));
        var02.addFixer((DataFix)new AddFlagIfNotPresentFix(var147, DataConverterTypes.WORLD_GEN_SETTINGS, "has_increased_height_already", true));
        Schema var148 = var02.addSchema(2710, SAME_NAMESPACED);
        var02.addFixer((DataFix)new StatsRenameFix(var148, "Renamed play_one_minute stat to play_time", (Map<String, String>)ImmutableMap.of((Object)"minecraft:play_one_minute", (Object)"minecraft:play_time")));
        Schema var149 = var02.addSchema(2717, SAME_NAMESPACED);
        var02.addFixer(DataConverterItemName.create(var149, "Rename azalea_leaves_flowers", DataConverterRegistry.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:azalea_leaves_flowers", (Object)"minecraft:flowering_azalea_leaves"))));
        var02.addFixer(DataConverterBlockRename.create(var149, "Rename azalea_leaves_flowers items", DataConverterRegistry.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:azalea_leaves_flowers", (Object)"minecraft:flowering_azalea_leaves"))));
        Schema var150 = var02.addSchema(2825, SAME_NAMESPACED);
        var02.addFixer((DataFix)new AddFlagIfNotPresentFix(var150, DataConverterTypes.WORLD_GEN_SETTINGS, "has_increased_height_already", false));
        Schema var151 = var02.addSchema(2831, V2831::new);
        var02.addFixer((DataFix)new SpawnerDataFix(var151));
        Schema var152 = var02.addSchema(2832, V2832::new);
        var02.addFixer((DataFix)new WorldGenSettingsHeightAndBiomeFix(var152));
        var02.addFixer((DataFix)new ChunkHeightAndBiomeFix(var152));
        Schema var153 = var02.addSchema(2833, SAME_NAMESPACED);
        var02.addFixer((DataFix)new WorldGenSettingsDisallowOldCustomWorldsFix(var153));
        Schema var154 = var02.addSchema(2838, SAME_NAMESPACED);
        var02.addFixer((DataFix)new NamespacedTypeRenameFix(var154, "Caves and Cliffs biome renames", DataConverterTypes.BIOME, DataConverterRegistry.createRenamer(CavesAndCliffsRenames.RENAMES)));
        Schema var155 = var02.addSchema(2841, SAME_NAMESPACED);
        var02.addFixer((DataFix)new ChunkProtoTickListFix(var155));
        Schema var156 = var02.addSchema(2842, V2842::new);
        var02.addFixer((DataFix)new ChunkRenamesFix(var156));
        Schema var157 = var02.addSchema(2843, SAME_NAMESPACED);
        var02.addFixer((DataFix)new OverreachingTickFix(var157));
        var02.addFixer((DataFix)new NamespacedTypeRenameFix(var157, "Remove Deep Warm Ocean", DataConverterTypes.BIOME, DataConverterRegistry.createRenamer("minecraft:deep_warm_ocean", "minecraft:warm_ocean")));
        Schema var158 = var02.addSchema(2846, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterAdvancementBase(var158, false, "Rename some C&C part 2 advancements", DataConverterRegistry.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:husbandry/play_jukebox_in_meadows", (Object)"minecraft:adventure/play_jukebox_in_meadows", (Object)"minecraft:adventure/caves_and_cliff", (Object)"minecraft:adventure/fall_from_world_height", (Object)"minecraft:adventure/ride_strider_in_overworld_lava", (Object)"minecraft:nether/ride_strider_in_overworld_lava"))));
        Schema var159 = var02.addSchema(2852, SAME_NAMESPACED);
        var02.addFixer((DataFix)new WorldGenSettingsDisallowOldCustomWorldsFix(var159));
        Schema var160 = var02.addSchema(2967, SAME_NAMESPACED);
        var02.addFixer((DataFix)new StructureSettingsFlattenFix(var160));
        Schema var161 = var02.addSchema(2970, SAME_NAMESPACED);
        var02.addFixer((DataFix)new StructuresBecomeConfiguredFix(var161));
        Schema var162 = var02.addSchema(3076, V3076::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var162, "Added Sculk Catalyst", DataConverterTypes.BLOCK_ENTITY));
        Schema var163 = var02.addSchema(3077, SAME_NAMESPACED);
        var02.addFixer((DataFix)new ChunkDeleteIgnoredLightDataFix(var163));
        Schema var164 = var02.addSchema(3078, V3078::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var164, "Added Frog", DataConverterTypes.ENTITY));
        var02.addFixer((DataFix)new DataConverterAddChoices(var164, "Added Tadpole", DataConverterTypes.ENTITY));
        var02.addFixer((DataFix)new DataConverterAddChoices(var164, "Added Sculk Shrieker", DataConverterTypes.BLOCK_ENTITY));
        Schema var165 = var02.addSchema(3081, V3081::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var165, "Added Warden", DataConverterTypes.ENTITY));
        Schema var166 = var02.addSchema(3082, V3082::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var166, "Added Chest Boat", DataConverterTypes.ENTITY));
        Schema var167 = var02.addSchema(3083, V3083::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var167, "Added Allay", DataConverterTypes.ENTITY));
        Schema var168 = var02.addSchema(3084, SAME_NAMESPACED);
        var02.addFixer((DataFix)new NamespacedTypeRenameFix(var168, "game_event_renames_3084", DataConverterTypes.GAME_EVENT_NAME, DataConverterRegistry.createRenamer((Map<String, String>)ImmutableMap.builder().put((Object)"minecraft:block_press", (Object)"minecraft:block_activate").put((Object)"minecraft:block_switch", (Object)"minecraft:block_activate").put((Object)"minecraft:block_unpress", (Object)"minecraft:block_deactivate").put((Object)"minecraft:block_unswitch", (Object)"minecraft:block_deactivate").put((Object)"minecraft:drinking_finish", (Object)"minecraft:drink").put((Object)"minecraft:elytra_free_fall", (Object)"minecraft:elytra_glide").put((Object)"minecraft:entity_damaged", (Object)"minecraft:entity_damage").put((Object)"minecraft:entity_dying", (Object)"minecraft:entity_die").put((Object)"minecraft:entity_killed", (Object)"minecraft:entity_die").put((Object)"minecraft:mob_interact", (Object)"minecraft:entity_interact").put((Object)"minecraft:ravager_roar", (Object)"minecraft:entity_roar").put((Object)"minecraft:ring_bell", (Object)"minecraft:block_change").put((Object)"minecraft:shulker_close", (Object)"minecraft:container_close").put((Object)"minecraft:shulker_open", (Object)"minecraft:container_open").put((Object)"minecraft:wolf_shaking", (Object)"minecraft:entity_shake").build())));
        Schema var169 = var02.addSchema(3086, SAME_NAMESPACED);
        var02.addFixer((DataFix)new EntityVariantFix(var169, "Change cat variant type", DataConverterTypes.ENTITY, "minecraft:cat", "CatType", arg_0 -> ((Int2ObjectOpenHashMap)SystemUtils.make(new Int2ObjectOpenHashMap(), var0 -> {
            var0.defaultReturnValue((Object)"minecraft:tabby");
            var0.put(0, (Object)"minecraft:tabby");
            var0.put(1, (Object)"minecraft:black");
            var0.put(2, (Object)"minecraft:red");
            var0.put(3, (Object)"minecraft:siamese");
            var0.put(4, (Object)"minecraft:british");
            var0.put(5, (Object)"minecraft:calico");
            var0.put(6, (Object)"minecraft:persian");
            var0.put(7, (Object)"minecraft:ragdoll");
            var0.put(8, (Object)"minecraft:white");
            var0.put(9, (Object)"minecraft:jellie");
            var0.put(10, (Object)"minecraft:all_black");
        })).get(arg_0)));
        ImmutableMap var170 = ImmutableMap.builder().put((Object)"textures/entity/cat/tabby.png", (Object)"minecraft:tabby").put((Object)"textures/entity/cat/black.png", (Object)"minecraft:black").put((Object)"textures/entity/cat/red.png", (Object)"minecraft:red").put((Object)"textures/entity/cat/siamese.png", (Object)"minecraft:siamese").put((Object)"textures/entity/cat/british_shorthair.png", (Object)"minecraft:british").put((Object)"textures/entity/cat/calico.png", (Object)"minecraft:calico").put((Object)"textures/entity/cat/persian.png", (Object)"minecraft:persian").put((Object)"textures/entity/cat/ragdoll.png", (Object)"minecraft:ragdoll").put((Object)"textures/entity/cat/white.png", (Object)"minecraft:white").put((Object)"textures/entity/cat/jellie.png", (Object)"minecraft:jellie").put((Object)"textures/entity/cat/all_black.png", (Object)"minecraft:all_black").build();
        var02.addFixer((DataFix)new CriteriaRenameFix(var169, "Migrate cat variant advancement", "minecraft:husbandry/complete_catalogue", var1 -> (String)var170.getOrDefault(var1, var1)));
        Schema var171 = var02.addSchema(3087, SAME_NAMESPACED);
        var02.addFixer((DataFix)new EntityVariantFix(var171, "Change frog variant type", DataConverterTypes.ENTITY, "minecraft:frog", "Variant", arg_0 -> ((Int2ObjectOpenHashMap)SystemUtils.make(new Int2ObjectOpenHashMap(), var0 -> {
            var0.put(0, (Object)"minecraft:temperate");
            var0.put(1, (Object)"minecraft:warm");
            var0.put(2, (Object)"minecraft:cold");
        })).get(arg_0)));
        Schema var172 = var02.addSchema(3090, SAME_NAMESPACED);
        var02.addFixer((DataFix)new EntityFieldsRenameFix(var172, "EntityPaintingFieldsRenameFix", "minecraft:painting", Map.of("Motive", "variant", "Facing", "facing")));
        Schema var173 = var02.addSchema(3093, SAME_NAMESPACED);
        var02.addFixer((DataFix)new EntityGoatMissingStateFix(var173));
        Schema var174 = var02.addSchema(3094, SAME_NAMESPACED);
        var02.addFixer((DataFix)new GoatHornIdFix(var174));
        Schema var175 = var02.addSchema(3097, SAME_NAMESPACED);
        var02.addFixer((DataFix)new FilteredBooksFix(var175));
        var02.addFixer((DataFix)new FilteredSignsFix(var175));
        Map<String, String> var176 = Map.of("minecraft:british", "minecraft:british_shorthair");
        var02.addFixer((DataFix)new VariantRenameFix(var175, "Rename british shorthair", DataConverterTypes.ENTITY, "minecraft:cat", var176));
        var02.addFixer((DataFix)new CriteriaRenameFix(var175, "Migrate cat variant advancement for british shorthair", "minecraft:husbandry/complete_catalogue", var1 -> var176.getOrDefault(var1, (String)var1)));
        var02.addFixer((DataFix)new PoiTypeRemoveFix(var175, "Remove unpopulated villager PoI types", Set.of("minecraft:unemployed", "minecraft:nitwit")::contains));
        Schema var177 = var02.addSchema(3108, SAME_NAMESPACED);
        var02.addFixer((DataFix)new BlendingDataRemoveFromNetherEndFix(var177));
        Schema var178 = var02.addSchema(3201, SAME_NAMESPACED);
        var02.addFixer((DataFix)new OptionsProgrammerArtFix(var178));
        Schema var179 = var02.addSchema(3202, V3202::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var179, "Added Hanging Sign", DataConverterTypes.BLOCK_ENTITY));
        Schema var180 = var02.addSchema(3203, V3203::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var180, "Added Camel", DataConverterTypes.ENTITY));
        Schema var181 = var02.addSchema(3204, V3204::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var181, "Added Chiseled Bookshelf", DataConverterTypes.BLOCK_ENTITY));
        Schema var182 = var02.addSchema(3209, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterFlattenSpawnEgg(var182, false, "minecraft:pig_spawn_egg"));
        Schema var183 = var02.addSchema(3214, SAME_NAMESPACED);
        var02.addFixer((DataFix)new OptionsAmbientOcclusionFix(var183));
        Schema var184 = var02.addSchema(3319, SAME_NAMESPACED);
        var02.addFixer((DataFix)new OptionsAccessibilityOnboardFix(var184));
        Schema var185 = var02.addSchema(3322, SAME_NAMESPACED);
        var02.addFixer((DataFix)new EffectDurationFix(var185));
        Schema var186 = var02.addSchema(3325, V3325::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var186, "Added displays", DataConverterTypes.ENTITY));
        Schema var187 = var02.addSchema(3326, V3326::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var187, "Added Sniffer", DataConverterTypes.ENTITY));
        Schema var188 = var02.addSchema(3327, V3327::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var188, "Archaeology", DataConverterTypes.BLOCK_ENTITY));
        Schema var189 = var02.addSchema(3328, V3328::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var189, "Added interaction", DataConverterTypes.ENTITY));
        Schema var190 = var02.addSchema(3438, V3438::new);
        var02.addFixer(BlockEntityRenameFix.create(var190, "Rename Suspicious Sand to Brushable Block", DataConverterRegistry.createRenamer("minecraft:suspicious_sand", "minecraft:brushable_block")));
        var02.addFixer((DataFix)new EntityBrushableBlockFieldsRenameFix(var190));
        var02.addFixer(DataConverterItemName.create(var190, "Pottery shard renaming", DataConverterRegistry.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:pottery_shard_archer", (Object)"minecraft:archer_pottery_shard", (Object)"minecraft:pottery_shard_prize", (Object)"minecraft:prize_pottery_shard", (Object)"minecraft:pottery_shard_arms_up", (Object)"minecraft:arms_up_pottery_shard", (Object)"minecraft:pottery_shard_skull", (Object)"minecraft:skull_pottery_shard"))));
        var02.addFixer((DataFix)new DataConverterAddChoices(var190, "Added calibrated sculk sensor", DataConverterTypes.BLOCK_ENTITY));
        Schema var191 = var02.addSchema(3439, V3439::new);
        var02.addFixer((DataFix)new BlockEntitySignDoubleSidedEditableTextFix(var191, "Updated sign text format for Signs", "minecraft:sign"));
        Schema var192 = var02.addSchema(3439, 1, V3439_1::new);
        var02.addFixer((DataFix)new BlockEntitySignDoubleSidedEditableTextFix(var192, "Updated sign text format for Hanging Signs", "minecraft:hanging_sign"));
        Schema var193 = var02.addSchema(3440, SAME_NAMESPACED);
        var02.addFixer((DataFix)new NamespacedTypeRenameFix(var193, "Replace experimental 1.20 overworld", DataConverterTypes.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST, DataConverterRegistry.createRenamer("minecraft:overworld_update_1_20", "minecraft:overworld")));
        var02.addFixer((DataFix)new FeatureFlagRemoveFix(var193, "Remove 1.20 feature toggle", Set.of("minecraft:update_1_20")));
        Schema var194 = var02.addSchema(3447, SAME_NAMESPACED);
        var02.addFixer(DataConverterItemName.create(var194, "Pottery shard item renaming to Pottery sherd", DataConverterRegistry.createRenamer(Stream.of("minecraft:angler_pottery_shard", "minecraft:archer_pottery_shard", "minecraft:arms_up_pottery_shard", "minecraft:blade_pottery_shard", "minecraft:brewer_pottery_shard", "minecraft:burn_pottery_shard", "minecraft:danger_pottery_shard", "minecraft:explorer_pottery_shard", "minecraft:friend_pottery_shard", "minecraft:heart_pottery_shard", "minecraft:heartbreak_pottery_shard", "minecraft:howl_pottery_shard", "minecraft:miner_pottery_shard", "minecraft:mourner_pottery_shard", "minecraft:plenty_pottery_shard", "minecraft:prize_pottery_shard", "minecraft:sheaf_pottery_shard", "minecraft:shelter_pottery_shard", "minecraft:skull_pottery_shard", "minecraft:snort_pottery_shard").collect(Collectors.toMap(Function.identity(), var0 -> var0.replace("_pottery_shard", "_pottery_sherd"))))));
        Schema var195 = var02.addSchema(3448, V3448::new);
        var02.addFixer((DataFix)new DecoratedPotFieldRenameFix(var195));
        Schema var196 = var02.addSchema(3450, SAME_NAMESPACED);
        var02.addFixer((DataFix)new RemapChunkStatusFix(var196, "Remove liquid_carvers and heightmap chunk statuses", DataConverterRegistry.createRenamer(Map.of("minecraft:liquid_carvers", "minecraft:carvers", "minecraft:heightmaps", "minecraft:spawn"))));
        Schema var197 = var02.addSchema(3451, SAME_NAMESPACED);
        var02.addFixer((DataFix)new ChunkDeleteLightFix(var197));
        Schema var198 = var02.addSchema(3459, SAME_NAMESPACED);
        var02.addFixer((DataFix)new LegacyDragonFightFix(var198));
        Schema var199 = var02.addSchema(3564, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DropInvalidSignDataFix(var199, "minecraft:sign"));
        Schema var200 = var02.addSchema(3564, 1, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DropInvalidSignDataFix(var200, "minecraft:hanging_sign"));
        Schema var201 = var02.addSchema(3565, SAME_NAMESPACED);
        var02.addFixer((DataFix)new RandomSequenceSettingsFix(var201));
        Schema var202 = var02.addSchema(3566, SAME_NAMESPACED);
        var02.addFixer((DataFix)new ScoreboardDisplaySlotFix(var202));
        Schema var203 = var02.addSchema(3568, SAME_NAMESPACED);
        var02.addFixer((DataFix)new MobEffectIdFix(var203));
        Schema var204 = var02.addSchema(3682, V3682::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var204, "Added Crafter", DataConverterTypes.BLOCK_ENTITY));
        Schema var205 = var02.addSchema(3683, V3683::new);
        var02.addFixer((DataFix)new PrimedTntBlockStateFixer(var205));
        Schema var206 = var02.addSchema(3685, V3685::new);
        var02.addFixer((DataFix)new FixProjectileStoredItem(var206));
        Schema var207 = var02.addSchema(3689, V3689::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var207, "Added Breeze", DataConverterTypes.ENTITY));
        var02.addFixer((DataFix)new DataConverterAddChoices(var207, "Added Trial Spawner", DataConverterTypes.BLOCK_ENTITY));
        Schema var208 = var02.addSchema(3692, SAME_NAMESPACED);
        UnaryOperator<String> var209 = DataConverterRegistry.createRenamer(Map.of("minecraft:grass", "minecraft:short_grass"));
        var02.addFixer(DataConverterBlockRename.create(var208, "Rename grass block to short_grass", var209));
        var02.addFixer(DataConverterItemName.create(var208, "Rename grass item to short_grass", var209));
        Schema var210 = var02.addSchema(3799, V3799::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var210, "Added Armadillo", DataConverterTypes.ENTITY));
        Schema var211 = var02.addSchema(3800, SAME_NAMESPACED);
        UnaryOperator<String> var212 = DataConverterRegistry.createRenamer(Map.of("minecraft:scute", "minecraft:turtle_scute"));
        var02.addFixer(DataConverterItemName.create(var211, "Rename scute item to turtle_scute", var212));
        Schema var213 = var02.addSchema(3803, SAME_NAMESPACED);
        var02.addFixer((DataFix)new RenameEnchantmentsFix(var213, "Rename sweeping enchant to sweeping_edge", Map.of("minecraft:sweeping", "minecraft:sweeping_edge")));
        Schema var214 = var02.addSchema(3807, V3807::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var214, "Added Vault", DataConverterTypes.BLOCK_ENTITY));
        Schema var215 = var02.addSchema(3807, 1, SAME_NAMESPACED);
        var02.addFixer((DataFix)new MapBannerBlockPosFormatFix(var215));
        Schema var216 = var02.addSchema(3808, V3808::new);
        var02.addFixer((DataFix)new HorseBodyArmorItemFix(var216, "minecraft:horse", "ArmorItem", true));
        Schema var217 = var02.addSchema(3808, 1, V3808_1::new);
        var02.addFixer((DataFix)new HorseBodyArmorItemFix(var217, "minecraft:llama", "DecorItem", false));
        Schema var218 = var02.addSchema(3808, 2, V3808_2::new);
        var02.addFixer((DataFix)new HorseBodyArmorItemFix(var218, "minecraft:trader_llama", "DecorItem", false));
        Schema var219 = var02.addSchema(3809, SAME_NAMESPACED);
        var02.addFixer((DataFix)new ChestedHorsesInventoryZeroIndexingFix(var219));
        Schema var220 = var02.addSchema(3812, SAME_NAMESPACED);
        var02.addFixer((DataFix)new FixWolfHealth(var220));
        Schema var221 = var02.addSchema(3813, V3813::new);
        var02.addFixer((DataFix)new BlockPosFormatAndRenamesFix(var221));
        Schema var222 = var02.addSchema(3814, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterAttributes(var222, "Rename jump strength attribute", DataConverterRegistry.createRenamer("minecraft:horse.jump_strength", "minecraft:generic.jump_strength")));
        Schema var223 = var02.addSchema(3816, V3816::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var223, "Added Bogged", DataConverterTypes.ENTITY));
        Schema var224 = var02.addSchema(3818, V3818::new);
        var02.addFixer((DataFix)new BeehiveFieldRenameFix(var224));
        var02.addFixer((DataFix)new EmptyItemInHotbarFix(var224));
        Schema var225 = var02.addSchema(3818, 1, SAME_NAMESPACED);
        var02.addFixer((DataFix)new BannerPatternFormatFix(var225));
        Schema var226 = var02.addSchema(3818, 2, SAME_NAMESPACED);
        var02.addFixer((DataFix)new TippedArrowPotionToItemFix(var226));
        Schema var227 = var02.addSchema(3818, 3, V3818_3::new);
        var02.addFixer((DataFix)new DataConverterShoulderEntity(var227, "Inject data component types", DataConverterTypes.DATA_COMPONENTS));
        Schema var228 = var02.addSchema(3818, 4, V3818_4::new);
        var02.addFixer((DataFix)new ParticleUnflatteningFix(var228));
        Schema var229 = var02.addSchema(3818, 5, V3818_5::new);
        var02.addFixer((DataFix)new ItemStackComponentizationFix(var229));
        Schema var230 = var02.addSchema(3818, 6, SAME_NAMESPACED);
        var02.addFixer((DataFix)new AreaEffectCloudPotionFix(var230));
        Schema var231 = var02.addSchema(3820, SAME_NAMESPACED);
        var02.addFixer((DataFix)new PlayerHeadBlockProfileFix(var231));
        var02.addFixer((DataFix)new LodestoneCompassComponentFix(var231));
        Schema var232 = var02.addSchema(3825, V3825::new);
        var02.addFixer((DataFix)new ItemStackCustomNameToOverrideComponentFix(var232));
        var02.addFixer((DataFix)new BannerEntityCustomNameToOverrideComponentFix(var232));
        var02.addFixer((DataFix)new TrialSpawnerConfigFix(var232));
        var02.addFixer((DataFix)new DataConverterAddChoices(var232, "Added Ominous Item Spawner", DataConverterTypes.ENTITY));
        Schema var233 = var02.addSchema(3828, SAME_NAMESPACED);
        var02.addFixer((DataFix)new EmptyItemInVillagerTradeFix(var233));
        Schema var234 = var02.addSchema(3833, SAME_NAMESPACED);
        var02.addFixer((DataFix)new RemoveEmptyItemInBrushableBlockFix(var234));
        Schema var235 = var02.addSchema(3938, V3938::new);
        var02.addFixer((DataFix)new ProjectileStoredWeaponFix(var235));
        Schema var236 = var02.addSchema(3939, SAME_NAMESPACED);
        var02.addFixer((DataFix)new FeatureFlagRemoveFix(var236, "Remove 1.21 feature toggle", Set.of("minecraft:update_1_21")));
        Schema var237 = var02.addSchema(3943, SAME_NAMESPACED);
        var02.addFixer((DataFix)new OptionsMenuBlurrinessFix(var237));
        Schema var238 = var02.addSchema(3945, SAME_NAMESPACED);
        var02.addFixer((DataFix)new AttributeModifierIdFix(var238));
        var02.addFixer((DataFix)new JukeboxTicksSinceSongStartedFix(var238));
        Schema var239 = var02.addSchema(4054, SAME_NAMESPACED);
        var02.addFixer((DataFix)new OminousBannerRarityFix(var239));
        Schema var240 = var02.addSchema(4055, SAME_NAMESPACED);
        var02.addFixer((DataFix)new AttributeIdPrefixFix(var240));
        Schema var241 = var02.addSchema(4057, SAME_NAMESPACED);
        var02.addFixer((DataFix)new CarvingStepRemoveFix(var241));
        Schema var242 = var02.addSchema(4059, V4059::new);
        var02.addFixer((DataFix)new FoodToConsumableFix(var242));
        Schema var243 = var02.addSchema(4061, SAME_NAMESPACED);
        var02.addFixer((DataFix)new TrialSpawnerConfigInRegistryFix(var243));
        Schema var244 = var02.addSchema(4064, SAME_NAMESPACED);
        var02.addFixer((DataFix)new FireResistantToDamageResistantComponentFix(var244));
        Schema var245 = var02.addSchema(4067, V4067::new);
        var02.addFixer((DataFix)new BoatSplitFix(var245));
        var02.addFixer((DataFix)new FeatureFlagRemoveFix(var245, "Remove Bundle experimental feature flag", Set.of("minecraft:bundle")));
        Schema var246 = var02.addSchema(4068, SAME_NAMESPACED);
        var02.addFixer((DataFix)new LockComponentPredicateFix(var246));
        var02.addFixer((DataFix)new ContainerBlockEntityLockPredicateFix(var246));
        Schema var247 = var02.addSchema(4070, V4070::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var247, "Added Pale Oak Boat and Pale Oak Chest Boat", DataConverterTypes.ENTITY));
        Schema var248 = var02.addSchema(4071, V4071::new);
        var02.addFixer((DataFix)new DataConverterAddChoices(var248, "Added Creaking", DataConverterTypes.ENTITY));
        var02.addFixer((DataFix)new DataConverterAddChoices(var248, "Added Creaking Heart", DataConverterTypes.BLOCK_ENTITY));
        Schema var249 = var02.addSchema(4081, SAME_NAMESPACED);
        var02.addFixer((DataFix)new EntitySalmonSizeFix(var249));
        Schema var250 = var02.addSchema(4173, SAME_NAMESPACED);
        var02.addFixer((DataFix)new EntityFieldsRenameFix(var250, "Rename TNT Minecart fuse", "minecraft:tnt_minecart", Map.of("TNTFuse", "fuse")));
        Schema var251 = var02.addSchema(4175, SAME_NAMESPACED);
        var02.addFixer((DataFix)new EquippableAssetRenameFix(var251));
        var02.addFixer((DataFix)new CustomModelDataExpandFix(var251));
        Schema var252 = var02.addSchema(4176, SAME_NAMESPACED);
        var02.addFixer((DataFix)new InvalidBlockEntityLockFix(var252));
        var02.addFixer((DataFix)new InvalidLockComponentFix(var252));
        Schema var253 = var02.addSchema(4180, SAME_NAMESPACED);
        var02.addFixer((DataFix)new FeatureFlagRemoveFix(var253, "Remove Winter Drop toggle", Set.of("minecraft:winter_drop")));
        Schema var254 = var02.addSchema(4181, SAME_NAMESPACED);
        var02.addFixer((DataFix)new BlockEntityFurnaceBurnTimeFix(var254, "minecraft:furnace"));
        var02.addFixer((DataFix)new BlockEntityFurnaceBurnTimeFix(var254, "minecraft:smoker"));
        var02.addFixer((DataFix)new BlockEntityFurnaceBurnTimeFix(var254, "minecraft:blast_furnace"));
        Schema var255 = var02.addSchema(4187, SAME_NAMESPACED);
        var02.addFixer((DataFix)new EntityAttributeBaseValueFix(var255, "Villager follow range fix undo", "minecraft:villager", "minecraft:follow_range", var0 -> var0 == 48.0 ? 16.0 : var0));
        var02.addFixer((DataFix)new EntityAttributeBaseValueFix(var255, "Bee follow range fix", "minecraft:bee", "minecraft:follow_range", var0 -> var0 == 48.0 ? 16.0 : var0));
        var02.addFixer((DataFix)new EntityAttributeBaseValueFix(var255, "Allay follow range fix", "minecraft:allay", "minecraft:follow_range", var0 -> var0 == 48.0 ? 16.0 : var0));
        var02.addFixer((DataFix)new EntityAttributeBaseValueFix(var255, "Llama follow range fix", "minecraft:llama", "minecraft:follow_range", var0 -> var0 == 40.0 ? 16.0 : var0));
        var02.addFixer((DataFix)new EntityAttributeBaseValueFix(var255, "Piglin Brute follow range fix", "minecraft:piglin_brute", "minecraft:follow_range", var0 -> var0 == 16.0 ? 12.0 : var0));
        var02.addFixer((DataFix)new EntityAttributeBaseValueFix(var255, "Warden follow range fix", "minecraft:warden", "minecraft:follow_range", var0 -> var0 == 16.0 ? 24.0 : var0));
        Schema schema = var02.addSchema(4290, V4290::new);
        var02.addFixer((DataFix)new UnflattenTextComponentFix((Schema)var256));
        Schema schema2 = var02.addSchema(4291, SAME_NAMESPACED);
        var02.addFixer((DataFix)new LegacyHoverEventFix((Schema)var257));
        var02.addFixer((DataFix)new TextComponentStringifiedFlagsFix((Schema)var257));
        Schema schema3 = var02.addSchema(4292, V4292::new);
        var02.addFixer((DataFix)new TextComponentHoverAndClickEventFix((Schema)var258));
        Schema schema4 = var02.addSchema(4293, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DropChancesFormatFix((Schema)var259));
        Schema schema5 = var02.addSchema(4294, SAME_NAMESPACED);
        var02.addFixer((DataFix)new BlockPropertyRenameAndFix((Schema)var260, "CreakingHeartBlockStateFix", "minecraft:creaking_heart", "active", "creaking_heart_state", var0 -> var0.equals("true") ? "awake" : "uprooted"));
        Schema schema6 = var02.addSchema(4295, SAME_NAMESPACED);
        var02.addFixer((DataFix)new BlendingDataFix((Schema)var261));
        Schema schema7 = var02.addSchema(4296, SAME_NAMESPACED);
        var02.addFixer((DataFix)new AreaEffectCloudDurationScaleFix((Schema)var262));
        Schema schema8 = var02.addSchema(4297, SAME_NAMESPACED);
        var02.addFixer((DataFix)new ForcedChunkToTicketFix((Schema)var263));
        Schema schema9 = var02.addSchema(4299, SAME_NAMESPACED);
        var02.addFixer((DataFix)new EntitySpawnerItemVariantComponentFix((Schema)var264));
        Schema schema10 = var02.addSchema(4300, V4300::new);
        var02.addFixer((DataFix)new SaddleEquipmentSlotFix((Schema)var265));
        Schema schema11 = var02.addSchema(4301, V4301::new);
        var02.addFixer((DataFix)new EquipmentFormatFix((Schema)var266));
        Schema schema12 = var02.addSchema(4302, V4302::new);
        var02.addFixer((DataFix)new DataConverterAddChoices((Schema)var267, "Added Test and Test Instance Block Entities", DataConverterTypes.BLOCK_ENTITY));
        Schema schema13 = var02.addSchema(4303, SAME_NAMESPACED);
        var02.addFixer((DataFix)new EntityFallDistanceFloatToDoubleFix((Schema)var268, DataConverterTypes.ENTITY));
        var02.addFixer((DataFix)new EntityFallDistanceFloatToDoubleFix((Schema)var268, DataConverterTypes.PLAYER));
        Schema schema14 = var02.addSchema(4305, SAME_NAMESPACED);
        var02.addFixer((DataFix)new BlockPropertyRenameAndFix((Schema)var269, "rename test block mode", "minecraft:test_block", "test_block_mode", "mode", var0 -> var0));
        Schema schema15 = var02.addSchema(4306, V4306::new);
        var02.addFixer((DataFix)new ThrownPotionSplitFix((Schema)var270));
        Schema schema16 = var02.addSchema(4307, V4307::new);
        var02.addFixer((DataFix)new TooltipDisplayComponentFix((Schema)var271));
        Schema schema17 = var02.addSchema(4309, SAME_NAMESPACED);
        var02.addFixer((DataFix)new RaidRenamesDataFix((Schema)var272));
        var02.addFixer((DataFix)new ChunkTicketUnpackPosFix((Schema)var272));
        Schema schema18 = var02.addSchema(4311, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DataConverterAdvancementBase((Schema)var273, false, "Use lodestone category change", DataConverterRegistry.createRenamer("minecraft:nether/use_lodestone", "minecraft:adventure/use_lodestone")));
        Schema schema19 = var02.addSchema(4312, V4312::new);
        var02.addFixer((DataFix)new PlayerEquipmentFix((Schema)var274));
        Schema schema20 = var02.addSchema(4314, SAME_NAMESPACED);
        var02.addFixer((DataFix)new InlineBlockPosFormatFix((Schema)var275));
        Schema schema21 = var02.addSchema(4420, V4420::new);
        var02.addFixer((DataFix)new NamedEntityConvertUncheckedFix((Schema)var276, "AreaEffectCloudCustomParticleFix", DataConverterTypes.ENTITY, "minecraft:area_effect_cloud"));
        Schema schema22 = var02.addSchema(4421, V4421::new);
        var02.addFixer((DataFix)new DataConverterAddChoices((Schema)var277, "Added Happy Ghast", DataConverterTypes.ENTITY));
        Schema schema23 = var02.addSchema(4424, SAME_NAMESPACED);
        var02.addFixer((DataFix)new FeatureFlagRemoveFix((Schema)var278, "Remove Locator Bar experimental feature flag", Set.of("minecraft:locator_bar")));
        var02.addFixer((DataFix)new AddFieldFix((Schema)var278, DataConverterTypes.PLAYER, "style", var0 -> var0.createString("minecraft:default"), "locator_bar_icon"));
        var02.addFixer((DataFix)new AddFieldFix((Schema)var278, DataConverterTypes.ENTITY, "style", var0 -> var0.createString("minecraft:default"), "locator_bar_icon"));
        Schema schema24 = var02.addSchema(4531, V4531::new);
        var02.addFixer((DataFix)new DataConverterAddChoices((Schema)var279, "Added Copper Golem", DataConverterTypes.ENTITY));
        Schema schema25 = var02.addSchema(4532, V4532::new);
        var02.addFixer((DataFix)new DataConverterAddChoices((Schema)var280, "Added Copper Golem Statue Block Entity", DataConverterTypes.BLOCK_ENTITY));
        Schema schema26 = var02.addSchema(4533, V4533::new);
        var02.addFixer((DataFix)new DataConverterAddChoices((Schema)var281, "Added Shelf", DataConverterTypes.BLOCK_ENTITY));
        Schema schema27 = var02.addSchema(4535, SAME_NAMESPACED);
        var02.addFixer((DataFix)new CopperGolemWeatherStateFix((Schema)var282));
        Schema schema28 = var02.addSchema(4537, SAME_NAMESPACED);
        var02.addFixer((DataFix)new ChunkDeleteLightFix((Schema)var283));
        Schema schema29 = var02.addSchema(4541, SAME_NAMESPACED);
        var02.addFixer(DataConverterBlockRename.create((Schema)var284, "Rename chain to iron_chain", DataConverterRegistry.createRenamer("minecraft:chain", "minecraft:iron_chain")));
        var02.addFixer(DataConverterItemName.create((Schema)var284, "Rename chain to iron_chain", DataConverterRegistry.createRenamer("minecraft:chain", "minecraft:iron_chain")));
        Schema schema30 = var02.addSchema(4543, V4543::new);
        var02.addFixer((DataFix)new DataConverterAddChoices((Schema)var285, "Added Mannequin", DataConverterTypes.ENTITY));
        Schema schema31 = var02.addSchema(4544, SAME_NAMESPACED);
        var02.addFixer((DataFix)new LegacyWorldBorderFix((Schema)var286));
        Schema schema32 = var02.addSchema(4548, SAME_NAMESPACED);
        var02.addFixer((DataFix)new WorldSpawnDataFix((Schema)var287));
        var02.addFixer((DataFix)new PlayerRespawnDataFix((Schema)var287));
        Schema schema33 = var02.addSchema(4648, V4648::new);
        var02.addFixer((DataFix)new DataConverterAddChoices((Schema)var288, "Added Nautilus and Zombie Nautilus", DataConverterTypes.ENTITY));
        Schema schema34 = var02.addSchema(4649, SAME_NAMESPACED);
        var02.addFixer((DataFix)new TridentAnimationFix((Schema)var289));
        Schema schema35 = var02.addSchema(4650, SAME_NAMESPACED);
        var02.addFixer((DataFix)new DebugProfileOverlayReferenceFix((Schema)var290));
        Schema schema36 = var02.addSchema(4651, SAME_NAMESPACED);
        var02.addFixer((DataFix)new OptionsGraphicsModeSplitFix((Schema)var291, "cutoutLeaves", "false", "true", "true"));
        var02.addFixer((DataFix)new OptionsGraphicsModeSplitFix((Schema)var291, "weatherRadius", "5", "10", "10"));
        var02.addFixer((DataFix)new OptionsGraphicsModeSplitFix((Schema)var291, "vignette", "false", "true", "true"));
        var02.addFixer((DataFix)new OptionsGraphicsModeSplitFix((Schema)var291, "improvedTransparency", "false", "false", "true"));
        var02.addFixer((DataFix)new OptionsSetGraphicsPresetToCustomFix((Schema)var291));
        Schema schema37 = var02.addSchema(4656, V4656::new);
        var02.addFixer((DataFix)new DataConverterAddChoices((Schema)var292, "Added Parched and Camel Husk", DataConverterTypes.ENTITY));
        Schema schema38 = var02.addSchema(4657, SAME_NAMESPACED);
        var02.addFixer((DataFix)new WorldBorderWarningTimeFix((Schema)var293));
        Schema schema39 = var02.addSchema(4658, SAME_NAMESPACED);
        var02.addFixer((DataFix)new GameRuleRegistryFix((Schema)var294));
        Schema schema40 = var02.addSchema(4661, SAME_NAMESPACED);
        var02.addFixer((DataFix)new OptionsMusicToastFix((Schema)var295, false));
    }

    private static UnaryOperator<String> createRenamerNoNamespace(Map<String, String> var0) {
        return var1 -> var0.getOrDefault(var1, (String)var1);
    }

    private static UnaryOperator<String> createRenamer(Map<String, String> var0) {
        return var1 -> var0.getOrDefault(DataConverterSchemaNamed.ensureNamespaced(var1), (String)var1);
    }

    private static UnaryOperator<String> createRenamer(String var0, String var1) {
        return var2 -> Objects.equals(DataConverterSchemaNamed.ensureNamespaced(var2), var0) ? var1 : var2;
    }
}

