/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.function.DoubleUnaryOperator;
import net.minecraft.util.datafix.fixes.DataConverterNamedEntity;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class EntityAttributeBaseValueFix
extends DataConverterNamedEntity {
    private final String attributeId;
    private final DoubleUnaryOperator valueFixer;

    public EntityAttributeBaseValueFix(Schema var0, String var1, String var2, String var3, DoubleUnaryOperator var4) {
        super(var0, false, var1, DataConverterTypes.ENTITY, var2);
        this.attributeId = var3;
        this.valueFixer = var4;
    }

    @Override
    protected Typed<?> fix(Typed<?> var0) {
        return var0.update(DSL.remainderFinder(), this::fixValue);
    }

    private Dynamic<?> fixValue(Dynamic<?> var0) {
        return var0.update("attributes", var1 -> var0.createList(var1.asStream().map(var0 -> {
            Object var1 = DataConverterSchemaNamed.ensureNamespaced(var0.get("id").asString(""));
            if (!var1.equals(this.attributeId)) {
                return var0;
            }
            double var2 = var0.get("base").asDouble(0.0);
            return var0.set("base", var0.createDouble(this.valueFixer.applyAsDouble(var2)));
        })));
    }
}

