/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.util.datafix.fixes.DataComponentRemainderFix;
import org.jspecify.annotations.Nullable;

public class InvalidLockComponentFix
extends DataComponentRemainderFix {
    private static final Optional<String> INVALID_LOCK_CUSTOM_NAME = Optional.of("\"\"");

    public InvalidLockComponentFix(Schema var0) {
        super(var0, "InvalidLockComponentPredicateFix", "minecraft:lock");
    }

    @Override
    protected <T> @Nullable Dynamic<T> fixComponent(Dynamic<T> var0) {
        return InvalidLockComponentFix.fixLock(var0);
    }

    public static <T> @Nullable Dynamic<T> fixLock(Dynamic<T> var0) {
        return InvalidLockComponentFix.isBrokenLock(var0) ? null : var0;
    }

    private static <T> boolean isBrokenLock(Dynamic<T> var0) {
        return InvalidLockComponentFix.isMapWithOneField(var0, "components", var02 -> InvalidLockComponentFix.isMapWithOneField(var02, "minecraft:custom_name", var0 -> var0.asString().result().equals(INVALID_LOCK_CUSTOM_NAME)));
    }

    private static <T> boolean isMapWithOneField(Dynamic<T> var0, String var1, Predicate<Dynamic<T>> var2) {
        Optional var3 = var0.getMapValues().result();
        if (var3.isEmpty() || ((Map)var3.get()).size() != 1) {
            return false;
        }
        return var0.get(var1).result().filter(var2).isPresent();
    }
}

