/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.base.Splitter;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;
import org.jspecify.annotations.Nullable;

public class ItemStackComponentizationFix
extends DataFix {
    private static final int HIDE_ENCHANTMENTS = 1;
    private static final int HIDE_MODIFIERS = 2;
    private static final int HIDE_UNBREAKABLE = 4;
    private static final int HIDE_CAN_DESTROY = 8;
    private static final int HIDE_CAN_PLACE = 16;
    private static final int HIDE_ADDITIONAL = 32;
    private static final int HIDE_DYE = 64;
    private static final int HIDE_UPGRADES = 128;
    private static final Set<String> POTION_HOLDER_IDS = Set.of("minecraft:potion", "minecraft:splash_potion", "minecraft:lingering_potion", "minecraft:tipped_arrow");
    private static final Set<String> BUCKETED_MOB_IDS = Set.of("minecraft:pufferfish_bucket", "minecraft:salmon_bucket", "minecraft:cod_bucket", "minecraft:tropical_fish_bucket", "minecraft:axolotl_bucket", "minecraft:tadpole_bucket");
    private static final List<String> BUCKETED_MOB_TAGS = List.of("NoAI", "Silent", "NoGravity", "Glowing", "Invulnerable", "Health", "Age", "Variant", "HuntingCooldown", "BucketVariantTag");
    private static final Set<String> BOOLEAN_BLOCK_STATE_PROPERTIES = Set.of("attached", "bottom", "conditional", "disarmed", "drag", "enabled", "extended", "eye", "falling", "hanging", "has_bottle_0", "has_bottle_1", "has_bottle_2", "has_record", "has_book", "inverted", "in_wall", "lit", "locked", "occupied", "open", "persistent", "powered", "short", "signal_fire", "snowy", "triggered", "unstable", "waterlogged", "berries", "bloom", "shrieking", "can_summon", "up", "down", "north", "east", "south", "west", "slot_0_occupied", "slot_1_occupied", "slot_2_occupied", "slot_3_occupied", "slot_4_occupied", "slot_5_occupied", "cracked", "crafting");
    private static final Splitter PROPERTY_SPLITTER = Splitter.on((char)',');

    public ItemStackComponentizationFix(Schema var0) {
        super(var0, true);
    }

    private static void fixItemStack(a var02, Dynamic<?> var12) {
        Object var4;
        Object var3;
        int var22 = var02.removeTag("HideFlags").asInt(0);
        var02.moveTagToComponent("Damage", "minecraft:damage", var12.createInt(0));
        var02.moveTagToComponent("RepairCost", "minecraft:repair_cost", var12.createInt(0));
        var02.moveTagToComponent("CustomModelData", "minecraft:custom_model_data");
        var02.removeTag("BlockStateTag").result().ifPresent(var1 -> var02.setComponent("minecraft:block_state", ItemStackComponentizationFix.fixBlockStateTag(var1)));
        var02.moveTagToComponent("EntityTag", "minecraft:entity_data");
        var02.fixSubTag("BlockEntityTag", false, var1 -> {
            String var2 = DataConverterSchemaNamed.ensureNamespaced(var1.get("id").asString(""));
            Dynamic var3 = (var1 = ItemStackComponentizationFix.fixBlockEntityTag(var02, var1, var2)).remove("id");
            if (var3.equals((Object)var1.emptyMap())) {
                return var3;
            }
            return var1;
        });
        var02.moveTagToComponent("BlockEntityTag", "minecraft:block_entity_data");
        if (var02.removeTag("Unbreakable").asBoolean(false)) {
            var3 = var12.emptyMap();
            if ((var22 & 4) != 0) {
                var3 = var3.set("show_in_tooltip", var12.createBoolean(false));
            }
            var02.setComponent("minecraft:unbreakable", (Dynamic<?>)var3);
        }
        ItemStackComponentizationFix.fixEnchantments(var02, var12, "Enchantments", "minecraft:enchantments", (var22 & 1) != 0);
        if (var02.is("minecraft:enchanted_book")) {
            ItemStackComponentizationFix.fixEnchantments(var02, var12, "StoredEnchantments", "minecraft:stored_enchantments", (var22 & 0x20) != 0);
        }
        var02.fixSubTag("display", false, var2 -> ItemStackComponentizationFix.fixDisplay(var02, var2, var22));
        ItemStackComponentizationFix.fixAdventureModeChecks(var02, var12, var22);
        ItemStackComponentizationFix.fixAttributeModifiers(var02, var12, var22);
        var3 = var02.removeTag("Trim").result();
        if (((Optional)var3).isPresent()) {
            var4 = (Dynamic)((Optional)var3).get();
            if ((var22 & 0x80) != 0) {
                var4 = var4.set("show_in_tooltip", var4.createBoolean(false));
            }
            var02.setComponent("minecraft:trim", (Dynamic<?>)var4);
        }
        if ((var22 & 0x20) != 0) {
            var02.setComponent("minecraft:hide_additional_tooltip", var12.emptyMap());
        }
        if (var02.is("minecraft:crossbow")) {
            var02.removeTag("Charged");
            var02.moveTagToComponent("ChargedProjectiles", "minecraft:charged_projectiles", var12.createList(Stream.empty()));
        }
        if (var02.is("minecraft:bundle")) {
            var02.moveTagToComponent("Items", "minecraft:bundle_contents", var12.createList(Stream.empty()));
        }
        if (var02.is("minecraft:filled_map")) {
            var02.moveTagToComponent("map", "minecraft:map_id");
            var4 = var02.removeTag("Decorations").asStream().map(ItemStackComponentizationFix::fixMapDecoration).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (var0, var1) -> var0));
            if (!var4.isEmpty()) {
                var02.setComponent("minecraft:map_decorations", var12.createMap((Map)var4));
            }
        }
        if (var02.is(POTION_HOLDER_IDS)) {
            ItemStackComponentizationFix.fixPotionContents(var02, var12);
        }
        if (var02.is("minecraft:writable_book")) {
            ItemStackComponentizationFix.fixWritableBook(var02, var12);
        }
        if (var02.is("minecraft:written_book")) {
            ItemStackComponentizationFix.fixWrittenBook(var02, var12);
        }
        if (var02.is("minecraft:suspicious_stew")) {
            var02.moveTagToComponent("effects", "minecraft:suspicious_stew_effects");
        }
        if (var02.is("minecraft:debug_stick")) {
            var02.moveTagToComponent("DebugProperty", "minecraft:debug_stick_state");
        }
        if (var02.is(BUCKETED_MOB_IDS)) {
            ItemStackComponentizationFix.fixBucketedMobData(var02, var12);
        }
        if (var02.is("minecraft:goat_horn")) {
            var02.moveTagToComponent("instrument", "minecraft:instrument");
        }
        if (var02.is("minecraft:knowledge_book")) {
            var02.moveTagToComponent("Recipes", "minecraft:recipes");
        }
        if (var02.is("minecraft:compass")) {
            ItemStackComponentizationFix.fixLodestoneTracker(var02, var12);
        }
        if (var02.is("minecraft:firework_rocket")) {
            ItemStackComponentizationFix.fixFireworkRocket(var02);
        }
        if (var02.is("minecraft:firework_star")) {
            ItemStackComponentizationFix.fixFireworkStar(var02);
        }
        if (var02.is("minecraft:player_head")) {
            var02.removeTag("SkullOwner").result().ifPresent(var1 -> var02.setComponent("minecraft:profile", ItemStackComponentizationFix.fixProfile(var1)));
        }
    }

    private static Dynamic<?> fixBlockStateTag(Dynamic<?> var0) {
        return (Dynamic)DataFixUtils.orElse(var0.asMapOpt().result().map(var02 -> var02.collect(Collectors.toMap(Pair::getFirst, var0 -> {
            Optional var3;
            String var1 = ((Dynamic)var0.getFirst()).asString("");
            Dynamic var2 = (Dynamic)var0.getSecond();
            if (BOOLEAN_BLOCK_STATE_PROPERTIES.contains(var1) && (var3 = var2.asBoolean().result()).isPresent()) {
                return var2.createString(String.valueOf(var3.get()));
            }
            var3 = var2.asNumber().result();
            if (var3.isPresent()) {
                return var2.createString(((Number)var3.get()).toString());
            }
            return var2;
        }))).map(arg_0 -> var0.createMap(arg_0)), var0);
    }

    private static Dynamic<?> fixDisplay(a var0, Dynamic<?> var12, int var2) {
        Optional var6;
        boolean var5;
        var12.get("Name").result().filter(LegacyComponentDataFixUtils::isStrictlyValidJson).ifPresent(var1 -> var0.setComponent("minecraft:custom_name", (Dynamic<?>)var1));
        OptionalDynamic var3 = var12.get("Lore");
        if (var3.result().isPresent()) {
            var0.setComponent("minecraft:lore", var12.createList(var12.get("Lore").asStream().filter(LegacyComponentDataFixUtils::isStrictlyValidJson)));
        }
        Optional<Integer> var4 = var12.get("color").asNumber().result().map(Number::intValue);
        boolean bl = var5 = (var2 & 0x40) != 0;
        if (var4.isPresent() || var5) {
            var6 = var12.emptyMap().set("rgb", var12.createInt(var4.orElse(10511680).intValue()));
            if (var5) {
                var6 = var6.set("show_in_tooltip", var12.createBoolean(false));
            }
            var0.setComponent("minecraft:dyed_color", (Dynamic<?>)var6);
        }
        if ((var6 = var12.get("LocName").asString().result()).isPresent()) {
            var0.setComponent("minecraft:item_name", LegacyComponentDataFixUtils.createTranslatableComponent(var12.getOps(), (String)var6.get()));
        }
        if (var0.is("minecraft:filled_map")) {
            var0.setComponent("minecraft:map_color", var12.get("MapColor"));
            var12 = var12.remove("MapColor");
        }
        return var12.remove("Name").remove("Lore").remove("color").remove("LocName");
    }

    private static <T> Dynamic<T> fixBlockEntityTag(a var02, Dynamic<T> var1, String var2) {
        var02.setComponent("minecraft:lock", var1.get("Lock"));
        var1 = var1.remove("Lock");
        Optional var3 = var1.get("LootTable").result();
        if (var3.isPresent()) {
            Dynamic var4 = var1.emptyMap().set("loot_table", (Dynamic)var3.get());
            long var5 = var1.get("LootTableSeed").asLong(0L);
            if (var5 != 0L) {
                var4 = var4.set("seed", var1.createLong(var5));
            }
            var02.setComponent("minecraft:container_loot", var4);
            var1 = var1.remove("LootTable").remove("LootTableSeed");
        }
        return switch (var2) {
            case "minecraft:skull" -> {
                var02.setComponent("minecraft:note_block_sound", var1.get("note_block_sound"));
                yield var1.remove("note_block_sound");
            }
            case "minecraft:decorated_pot" -> {
                var02.setComponent("minecraft:pot_decorations", var1.get("sherds"));
                Optional var6 = var1.get("item").result();
                if (var6.isPresent()) {
                    var02.setComponent("minecraft:container", var1.createList(Stream.of(var1.emptyMap().set("slot", var1.createInt(0)).set("item", (Dynamic)var6.get()))));
                }
                yield var1.remove("sherds").remove("item");
            }
            case "minecraft:banner" -> {
                var02.setComponent("minecraft:banner_patterns", var1.get("patterns"));
                Optional var6 = var1.get("Base").asNumber().result();
                if (var6.isPresent()) {
                    var02.setComponent("minecraft:base_color", var1.createString(ExtraDataFixUtils.dyeColorIdToName(((Number)var6.get()).intValue())));
                }
                yield var1.remove("patterns").remove("Base");
            }
            case "minecraft:shulker_box", "minecraft:chest", "minecraft:trapped_chest", "minecraft:furnace", "minecraft:ender_chest", "minecraft:dispenser", "minecraft:dropper", "minecraft:brewing_stand", "minecraft:hopper", "minecraft:barrel", "minecraft:smoker", "minecraft:blast_furnace", "minecraft:campfire", "minecraft:chiseled_bookshelf", "minecraft:crafter" -> {
                List var6 = var1.get("Items").asList(var0 -> var0.emptyMap().set("slot", var0.createInt(var0.get("Slot").asByte((byte)0) & 0xFF)).set("item", var0.remove("Slot")));
                if (!var6.isEmpty()) {
                    var02.setComponent("minecraft:container", var1.createList(var6.stream()));
                }
                yield var1.remove("Items");
            }
            case "minecraft:beehive" -> {
                var02.setComponent("minecraft:bees", var1.get("bees"));
                yield var1.remove("bees");
            }
            default -> var1;
        };
    }

    private static void fixEnchantments(a var02, Dynamic<?> var1, String var2, String var3, boolean var4) {
        OptionalDynamic<?> var5 = var02.removeTag(var2);
        List<Pair> var6 = var5.asList(Function.identity()).stream().flatMap(var0 -> ItemStackComponentizationFix.parseEnchantment(var0).stream()).filter(var0 -> (Integer)var0.getSecond() > 0).toList();
        if (!var6.isEmpty() || var4) {
            Dynamic var7 = var1.emptyMap();
            Dynamic var8 = var1.emptyMap();
            for (Pair var10 : var6) {
                var8 = var8.set((String)var10.getFirst(), var1.createInt(((Integer)var10.getSecond()).intValue()));
            }
            var7 = var7.set("levels", var8);
            if (var4) {
                var7 = var7.set("show_in_tooltip", var1.createBoolean(false));
            }
            var02.setComponent(var3, var7);
        }
        if (var5.result().isPresent() && var6.isEmpty()) {
            var02.setComponent("minecraft:enchantment_glint_override", var1.createBoolean(true));
        }
    }

    private static Optional<Pair<String, Integer>> parseEnchantment(Dynamic<?> var02) {
        return var02.get("id").asString().apply2stable((var0, var1) -> Pair.of((Object)var0, (Object)MathHelper.clamp(var1.intValue(), 0, 255)), var02.get("lvl").asNumber()).result();
    }

    private static void fixAdventureModeChecks(a var0, Dynamic<?> var1, int var2) {
        ItemStackComponentizationFix.fixBlockStatePredicates(var0, var1, "CanDestroy", "minecraft:can_break", (var2 & 8) != 0);
        ItemStackComponentizationFix.fixBlockStatePredicates(var0, var1, "CanPlaceOn", "minecraft:can_place_on", (var2 & 0x10) != 0);
    }

    private static void fixBlockStatePredicates(a var02, Dynamic<?> var1, String var2, String var3, boolean var4) {
        Optional var5 = var02.removeTag(var2).result();
        if (var5.isEmpty()) {
            return;
        }
        Dynamic var6 = var1.emptyMap().set("predicates", var1.createList(((Dynamic)var5.get()).asStream().map(var0 -> (Dynamic)DataFixUtils.orElse((Optional)var0.asString().map(var1 -> ItemStackComponentizationFix.fixBlockStatePredicate(var0, var1)).result(), (Object)var0))));
        if (var4) {
            var6 = var6.set("show_in_tooltip", var1.createBoolean(false));
        }
        var02.setComponent(var3, var6);
    }

    private static Dynamic<?> fixBlockStatePredicate(Dynamic<?> var0, String var1) {
        int var2 = var1.indexOf(91);
        int var3 = var1.indexOf(123);
        int var4 = var1.length();
        if (var2 != -1) {
            var4 = var2;
        }
        if (var3 != -1) {
            var4 = Math.min(var4, var3);
        }
        String var5 = var1.substring(0, var4);
        Dynamic var6 = var0.emptyMap().set("blocks", var0.createString(var5.trim()));
        int var7 = var1.indexOf(93);
        if (var2 != -1 && var7 != -1) {
            Dynamic var8 = var0.emptyMap();
            Iterable var9 = PROPERTY_SPLITTER.split((CharSequence)var1.substring(var2 + 1, var7));
            for (String var11 : var9) {
                int var12 = var11.indexOf(61);
                if (var12 == -1) continue;
                String var13 = var11.substring(0, var12).trim();
                String var14 = var11.substring(var12 + 1).trim();
                var8 = var8.set(var13, var0.createString(var14));
            }
            var6 = var6.set("state", var8);
        }
        int var8 = var1.indexOf(125);
        if (var3 != -1 && var8 != -1) {
            var6 = var6.set("nbt", var0.createString(var1.substring(var3, var8 + 1)));
        }
        return var6;
    }

    private static void fixAttributeModifiers(a var0, Dynamic<?> var1, int var2) {
        OptionalDynamic<?> var3 = var0.removeTag("AttributeModifiers");
        if (var3.result().isEmpty()) {
            return;
        }
        boolean var4 = (var2 & 2) != 0;
        List var5 = var3.asList(ItemStackComponentizationFix::fixAttributeModifier);
        Dynamic var6 = var1.emptyMap().set("modifiers", var1.createList(var5.stream()));
        if (var4) {
            var6 = var6.set("show_in_tooltip", var1.createBoolean(false));
        }
        var0.setComponent("minecraft:attribute_modifiers", var6);
    }

    private static Dynamic<?> fixAttributeModifier(Dynamic<?> var02) {
        Dynamic var1 = var02.emptyMap().set("name", var02.createString("")).set("amount", var02.createDouble(0.0)).set("operation", var02.createString("add_value"));
        var1 = Dynamic.copyField(var02, (String)"AttributeName", (Dynamic)var1, (String)"type");
        var1 = Dynamic.copyField(var02, (String)"Slot", (Dynamic)var1, (String)"slot");
        var1 = Dynamic.copyField(var02, (String)"UUID", (Dynamic)var1, (String)"uuid");
        var1 = Dynamic.copyField(var02, (String)"Name", (Dynamic)var1, (String)"name");
        var1 = Dynamic.copyField(var02, (String)"Amount", (Dynamic)var1, (String)"amount");
        var1 = Dynamic.copyAndFixField(var02, (String)"Operation", (Dynamic)var1, (String)"operation", var0 -> var0.createString(switch (var0.asInt(0)) {
            default -> "add_value";
            case 1 -> "add_multiplied_base";
            case 2 -> "add_multiplied_total";
        }));
        return var1;
    }

    private static Pair<Dynamic<?>, Dynamic<?>> fixMapDecoration(Dynamic<?> var0) {
        Dynamic var1 = (Dynamic)DataFixUtils.orElseGet((Optional)var0.get("id").result(), () -> var0.createString(""));
        Dynamic var2 = var0.emptyMap().set("type", var0.createString(ItemStackComponentizationFix.fixMapDecorationType(var0.get("type").asInt(0)))).set("x", var0.createDouble(var0.get("x").asDouble(0.0))).set("z", var0.createDouble(var0.get("z").asDouble(0.0))).set("rotation", var0.createFloat((float)var0.get("rot").asDouble(0.0)));
        return Pair.of((Object)var1, (Object)var2);
    }

    private static String fixMapDecorationType(int var0) {
        return switch (var0) {
            default -> "player";
            case 1 -> "frame";
            case 2 -> "red_marker";
            case 3 -> "blue_marker";
            case 4 -> "target_x";
            case 5 -> "target_point";
            case 6 -> "player_off_map";
            case 7 -> "player_off_limits";
            case 8 -> "mansion";
            case 9 -> "monument";
            case 10 -> "banner_white";
            case 11 -> "banner_orange";
            case 12 -> "banner_magenta";
            case 13 -> "banner_light_blue";
            case 14 -> "banner_yellow";
            case 15 -> "banner_lime";
            case 16 -> "banner_pink";
            case 17 -> "banner_gray";
            case 18 -> "banner_light_gray";
            case 19 -> "banner_cyan";
            case 20 -> "banner_purple";
            case 21 -> "banner_blue";
            case 22 -> "banner_brown";
            case 23 -> "banner_green";
            case 24 -> "banner_red";
            case 25 -> "banner_black";
            case 26 -> "red_x";
            case 27 -> "village_desert";
            case 28 -> "village_plains";
            case 29 -> "village_savanna";
            case 30 -> "village_snowy";
            case 31 -> "village_taiga";
            case 32 -> "jungle_temple";
            case 33 -> "swamp_hut";
        };
    }

    private static void fixPotionContents(a var02, Dynamic<?> var1) {
        Dynamic<?> var2 = var1.emptyMap();
        Optional<String> var3 = var02.removeTag("Potion").asString().result().filter(var0 -> !var0.equals("minecraft:empty"));
        if (var3.isPresent()) {
            var2 = var2.set("potion", var1.createString(var3.get()));
        }
        var2 = var02.moveTagInto("CustomPotionColor", var2, "custom_color");
        if (!(var2 = var02.moveTagInto("custom_potion_effects", var2, "custom_effects")).equals((Object)var1.emptyMap())) {
            var02.setComponent("minecraft:potion_contents", var2);
        }
    }

    private static void fixWritableBook(a var0, Dynamic<?> var1) {
        Dynamic<?> var2 = ItemStackComponentizationFix.fixBookPages(var0, var1);
        if (var2 != null) {
            var0.setComponent("minecraft:writable_book_content", var1.emptyMap().set("pages", var2));
        }
    }

    private static void fixWrittenBook(a var0, Dynamic<?> var1) {
        Dynamic<?> var2 = ItemStackComponentizationFix.fixBookPages(var0, var1);
        String var3 = var0.removeTag("title").asString("");
        Optional var4 = var0.removeTag("filtered_title").asString().result();
        Dynamic var5 = var1.emptyMap();
        var5 = var5.set("title", ItemStackComponentizationFix.createFilteredText(var1, var3, var4));
        var5 = var0.moveTagInto("author", var5, "author");
        var5 = var0.moveTagInto("resolved", var5, "resolved");
        var5 = var0.moveTagInto("generation", var5, "generation");
        if (var2 != null) {
            var5 = var5.set("pages", var2);
        }
        var0.setComponent("minecraft:written_book_content", var5);
    }

    private static @Nullable Dynamic<?> fixBookPages(a var02, Dynamic<?> var1) {
        List var2 = var02.removeTag("pages").asList(var0 -> var0.asString(""));
        Map var3 = var02.removeTag("filtered_pages").asMap(var0 -> var0.asString("0"), var0 -> var0.asString(""));
        if (var2.isEmpty()) {
            return null;
        }
        ArrayList var4 = new ArrayList(var2.size());
        for (int var5 = 0; var5 < var2.size(); ++var5) {
            String var6 = (String)var2.get(var5);
            String var7 = (String)var3.get(String.valueOf(var5));
            var4.add(ItemStackComponentizationFix.createFilteredText(var1, var6, Optional.ofNullable(var7)));
        }
        return var1.createList(var4.stream());
    }

    private static Dynamic<?> createFilteredText(Dynamic<?> var0, String var1, Optional<String> var2) {
        Dynamic var3 = var0.emptyMap().set("raw", var0.createString(var1));
        if (var2.isPresent()) {
            var3 = var3.set("filtered", var0.createString(var2.get()));
        }
        return var3;
    }

    private static void fixBucketedMobData(a var0, Dynamic<?> var1) {
        Dynamic<?> var2 = var1.emptyMap();
        for (String var4 : BUCKETED_MOB_TAGS) {
            var2 = var0.moveTagInto(var4, var2, var4);
        }
        if (!var2.equals((Object)var1.emptyMap())) {
            var0.setComponent("minecraft:bucket_entity_data", var2);
        }
    }

    private static void fixLodestoneTracker(a var0, Dynamic<?> var1) {
        Optional var2 = var0.removeTag("LodestonePos").result();
        Optional var3 = var0.removeTag("LodestoneDimension").result();
        if (var2.isEmpty() && var3.isEmpty()) {
            return;
        }
        boolean var4 = var0.removeTag("LodestoneTracked").asBoolean(true);
        Dynamic var5 = var1.emptyMap();
        if (var2.isPresent() && var3.isPresent()) {
            var5 = var5.set("target", var1.emptyMap().set("pos", (Dynamic)var2.get()).set("dimension", (Dynamic)var3.get()));
        }
        if (!var4) {
            var5 = var5.set("tracked", var1.createBoolean(false));
        }
        var0.setComponent("minecraft:lodestone_tracker", var5);
    }

    private static void fixFireworkStar(a var0) {
        var0.fixSubTag("Explosion", true, var1 -> {
            var0.setComponent("minecraft:firework_explosion", ItemStackComponentizationFix.fixFireworkExplosion(var1));
            return var1.remove("Type").remove("Colors").remove("FadeColors").remove("Trail").remove("Flicker");
        });
    }

    private static void fixFireworkRocket(a var0) {
        var0.fixSubTag("Fireworks", true, var1 -> {
            Stream<Dynamic> var2 = var1.get("Explosions").asStream().map(ItemStackComponentizationFix::fixFireworkExplosion);
            int var3 = var1.get("Flight").asInt(0);
            var0.setComponent("minecraft:fireworks", var1.emptyMap().set("explosions", var1.createList(var2)).set("flight_duration", var1.createByte((byte)var3)));
            return var1.remove("Explosions").remove("Flight");
        });
    }

    private static Dynamic<?> fixFireworkExplosion(Dynamic<?> var0) {
        var0 = var0.set("shape", var0.createString(switch (var0.get("Type").asInt(0)) {
            default -> "small_ball";
            case 1 -> "large_ball";
            case 2 -> "star";
            case 3 -> "creeper";
            case 4 -> "burst";
        })).remove("Type");
        var0 = var0.renameField("Colors", "colors");
        var0 = var0.renameField("FadeColors", "fade_colors");
        var0 = var0.renameField("Trail", "has_trail");
        var0 = var0.renameField("Flicker", "has_twinkle");
        return var0;
    }

    public static Dynamic<?> fixProfile(Dynamic<?> var0) {
        Optional var1 = var0.asString().result();
        if (var1.isPresent()) {
            if (ItemStackComponentizationFix.isValidPlayerName((String)var1.get())) {
                return var0.emptyMap().set("name", var0.createString((String)var1.get()));
            }
            return var0.emptyMap();
        }
        String var2 = var0.get("Name").asString("");
        Optional var3 = var0.get("Id").result();
        Dynamic<?> var4 = ItemStackComponentizationFix.fixProfileProperties(var0.get("Properties"));
        Dynamic var5 = var0.emptyMap();
        if (ItemStackComponentizationFix.isValidPlayerName(var2)) {
            var5 = var5.set("name", var0.createString(var2));
        }
        if (var3.isPresent()) {
            var5 = var5.set("id", (Dynamic)var3.get());
        }
        if (var4 != null) {
            var5 = var5.set("properties", var4);
        }
        return var5;
    }

    private static boolean isValidPlayerName(String var02) {
        if (var02.length() > 16) {
            return false;
        }
        return var02.chars().filter(var0 -> var0 <= 32 || var0 >= 127).findAny().isEmpty();
    }

    private static @Nullable Dynamic<?> fixProfileProperties(OptionalDynamic<?> var03) {
        Map var12 = var03.asMap(var0 -> var0.asString(""), var02 -> var02.asList(var0 -> {
            String var1 = var0.get("Value").asString("");
            Optional var2 = var0.get("Signature").asString().result();
            return Pair.of((Object)var1, (Object)var2);
        }));
        if (var12.isEmpty()) {
            return null;
        }
        return var03.createList(var12.entrySet().stream().flatMap(var1 -> ((List)var1.getValue()).stream().map(var2 -> {
            Dynamic var3 = var03.emptyMap().set("name", var03.createString((String)var1.getKey())).set("value", var03.createString((String)var2.getFirst()));
            Optional var4 = (Optional)var2.getSecond();
            if (var4.isPresent()) {
                return var3.set("signature", var03.createString((String)var4.get()));
            }
            return var3;
        })));
    }

    protected TypeRewriteRule makeRule() {
        return this.writeFixAndRead("ItemStack componentization", this.getInputSchema().getType(DataConverterTypes.ITEM_STACK), this.getOutputSchema().getType(DataConverterTypes.ITEM_STACK), var02 -> {
            Optional<Dynamic> var1 = a.read(var02).map(var0 -> {
                ItemStackComponentizationFix.fixItemStack(var0, var0.tag);
                return var0.write();
            });
            return (Dynamic)DataFixUtils.orElse(var1, (Object)var02);
        });
    }

    static class a {
        private final String item;
        private final int count;
        private Dynamic<?> components;
        private final Dynamic<?> remainder;
        Dynamic<?> tag;

        private a(String var0, int var1, Dynamic<?> var2) {
            this.item = DataConverterSchemaNamed.ensureNamespaced(var0);
            this.count = var1;
            this.components = var2.emptyMap();
            this.tag = var2.get("tag").orElseEmptyMap();
            this.remainder = var2.remove("tag");
        }

        public static Optional<a> read(Dynamic<?> var0) {
            return var0.get("id").asString().apply2stable((var1, var2) -> new a((String)var1, var2.intValue(), (Dynamic<?>)var0.remove("id").remove("Count")), var0.get("Count").asNumber()).result();
        }

        public OptionalDynamic<?> removeTag(String var0) {
            OptionalDynamic var1 = this.tag.get(var0);
            this.tag = this.tag.remove(var0);
            return var1;
        }

        public void setComponent(String var0, Dynamic<?> var1) {
            this.components = this.components.set(var0, var1);
        }

        public void setComponent(String var0, OptionalDynamic<?> var12) {
            var12.result().ifPresent(var1 -> {
                this.components = this.components.set(var0, var1);
            });
        }

        public Dynamic<?> moveTagInto(String var0, Dynamic<?> var1, String var2) {
            Optional var3 = this.removeTag(var0).result();
            if (var3.isPresent()) {
                return var1.set(var2, (Dynamic)var3.get());
            }
            return var1;
        }

        public void moveTagToComponent(String var0, String var1, Dynamic<?> var2) {
            Optional var3 = this.removeTag(var0).result();
            if (var3.isPresent() && !((Dynamic)var3.get()).equals(var2)) {
                this.setComponent(var1, (Dynamic)var3.get());
            }
        }

        public void moveTagToComponent(String var0, String var12) {
            this.removeTag(var0).result().ifPresent(var1 -> this.setComponent(var12, (Dynamic<?>)var1));
        }

        public void fixSubTag(String var0, boolean var1, UnaryOperator<Dynamic<?>> var2) {
            OptionalDynamic var3 = this.tag.get(var0);
            if (var1 && var3.result().isEmpty()) {
                return;
            }
            Dynamic var4 = var3.orElseEmptyMap();
            this.tag = (var4 = (Dynamic)var2.apply(var4)).equals((Object)var4.emptyMap()) ? this.tag.remove(var0) : this.tag.set(var0, var4);
        }

        public Dynamic<?> write() {
            Dynamic var0 = this.tag.emptyMap().set("id", this.tag.createString(this.item)).set("count", this.tag.createInt(this.count));
            if (!this.tag.equals((Object)this.tag.emptyMap())) {
                this.components = this.components.set("minecraft:custom_data", this.tag);
            }
            if (!this.components.equals((Object)this.tag.emptyMap())) {
                var0 = var0.set("components", this.components);
            }
            return a.mergeRemainder(var0, this.remainder);
        }

        private static <T> Dynamic<T> mergeRemainder(Dynamic<T> var0, Dynamic<?> var12) {
            DynamicOps var22 = var0.getOps();
            return var22.getMap(var0.getValue()).flatMap(var2 -> var22.mergeToMap(var12.convert(var22).getValue(), var2)).map(var1 -> new Dynamic(var22, var1)).result().orElse(var0);
        }

        public boolean is(String var0) {
            return this.item.equals(var0);
        }

        public boolean is(Set<String> var0) {
            return var0.contains(this.item);
        }

        public boolean hasComponent(String var0) {
            return this.components.get(var0).result().isPresent();
        }
    }
}

