/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.schemas;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.Const;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import net.minecraft.resources.MinecraftKey;

public class DataConverterSchemaNamed
extends Schema {
    public static final PrimitiveCodec<String> NAMESPACED_STRING_CODEC = new PrimitiveCodec<String>(){

        public <T> DataResult<String> read(DynamicOps<T> var0, T var1) {
            return var0.getStringValue(var1).map(DataConverterSchemaNamed::ensureNamespaced);
        }

        public <T> T write(DynamicOps<T> var0, String var1) {
            return (T)var0.createString(var1);
        }

        public String toString() {
            return "NamespacedString";
        }

        public /* synthetic */ Object write(DynamicOps dynamicOps, Object object) {
            return this.write(dynamicOps, (String)object);
        }
    };
    private static final Type<String> NAMESPACED_STRING = new Const.PrimitiveType(NAMESPACED_STRING_CODEC);

    public DataConverterSchemaNamed(int var0, Schema var1) {
        super(var0, var1);
    }

    public static String ensureNamespaced(String var0) {
        MinecraftKey var1 = MinecraftKey.tryParse(var0);
        if (var1 != null) {
            return var1.toString();
        }
        return var0;
    }

    public static Type<String> namespacedString() {
        return NAMESPACED_STRING;
    }

    public Type<?> getChoiceType(DSL.TypeReference var0, String var1) {
        return super.getChoiceType(var0, DataConverterSchemaNamed.ensureNamespaced(var1));
    }
}

