/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.debug.DebugSubscription;

public class ServerDebugSubscribers {
    private final MinecraftServer server;
    private final Map<DebugSubscription<?>, List<EntityPlayer>> enabledSubscriptions = new HashMap();

    public ServerDebugSubscribers(MinecraftServer var0) {
        this.server = var0;
    }

    private List<EntityPlayer> getSubscribersFor(DebugSubscription<?> var0) {
        return this.enabledSubscriptions.getOrDefault(var0, List.of());
    }

    public void tick() {
        this.enabledSubscriptions.values().forEach(List::clear);
        for (EntityPlayer var1 : this.server.getPlayerList().getPlayers()) {
            for (DebugSubscription<?> var3 : var1.debugSubscriptions()) {
                this.enabledSubscriptions.computeIfAbsent(var3, var0 -> new ArrayList()).add(var1);
            }
        }
        this.enabledSubscriptions.values().removeIf(List::isEmpty);
    }

    public void broadcastToAll(DebugSubscription<?> var0, Packet<?> var1) {
        for (EntityPlayer var3 : this.getSubscribersFor(var0)) {
            var3.connection.send(var1);
        }
    }

    public Set<DebugSubscription<?>> enabledSubscriptions() {
        return Set.copyOf(this.enabledSubscriptions.keySet());
    }

    public boolean hasAnySubscriberFor(DebugSubscription<?> var0) {
        return !this.getSubscribersFor(var0).isEmpty();
    }

    public boolean hasRequiredPermissions(EntityPlayer var0) {
        NameAndId var1 = var0.nameAndId();
        if (SharedConstants.IS_RUNNING_IN_IDE && this.server.isSingleplayerOwner(var1)) {
            return true;
        }
        return this.server.getPlayerList().isOp(var1);
    }
}

