/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.parsing.packrat.ErrorEntry;
import net.minecraft.util.parsing.packrat.SuggestionSupplier;
import org.jspecify.annotations.Nullable;

public interface ErrorCollector<S> {
    public void store(int var1, SuggestionSupplier<S> var2, Object var3);

    default public void store(int var0, Object var1) {
        this.store(var0, SuggestionSupplier.empty(), var1);
    }

    public void finish(int var1);

    public static class net.minecraft.util.parsing.packrat.ErrorCollector$a<S>
    implements ErrorCollector<S> {
        private @Nullable a<S>[] entries = new a[16];
        private int nextErrorEntry;
        private int lastCursor = -1;

        private void discardErrorsFromShorterParse(int var0) {
            if (var0 > this.lastCursor) {
                this.lastCursor = var0;
                this.nextErrorEntry = 0;
            }
        }

        @Override
        public void finish(int var0) {
            this.discardErrorsFromShorterParse(var0);
        }

        @Override
        public void store(int var0, SuggestionSupplier<S> var1, Object var2) {
            this.discardErrorsFromShorterParse(var0);
            if (var0 == this.lastCursor) {
                this.addErrorEntry(var1, var2);
            }
        }

        private void addErrorEntry(SuggestionSupplier<S> var0, Object var1) {
            Object var4;
            int var3;
            int var2 = this.entries.length;
            if (this.nextErrorEntry >= var2) {
                var3 = SystemUtils.growByHalf(var2, this.nextErrorEntry + 1);
                var4 = new a[var3];
                System.arraycopy(this.entries, 0, var4, 0, var2);
                this.entries = var4;
            }
            if ((var4 = this.entries[var3 = this.nextErrorEntry++]) == null) {
                this.entries[var3] = var4 = new a();
            }
            var4.suggestions = var0;
            var4.reason = var1;
        }

        public List<ErrorEntry<S>> entries() {
            int var0 = this.nextErrorEntry;
            if (var0 == 0) {
                return List.of();
            }
            ArrayList<ErrorEntry<S>> var1 = new ArrayList<ErrorEntry<S>>(var0);
            for (int var2 = 0; var2 < var0; ++var2) {
                a<S> var3 = this.entries[var2];
                var1.add(new ErrorEntry(this.lastCursor, var3.suggestions, var3.reason));
            }
            return var1;
        }

        public int cursor() {
            return this.lastCursor;
        }

        static class a<S> {
            SuggestionSupplier<S> suggestions = SuggestionSupplier.empty();
            Object reason = "empty";

            a() {
            }
        }
    }

    public static class b<S>
    implements ErrorCollector<S> {
        @Override
        public void store(int var0, SuggestionSupplier<S> var1, Object var2) {
        }

        @Override
        public void finish(int var0) {
        }
    }
}

