/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.util.parsing.packrat.DelayedException;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Rule;
import org.jspecify.annotations.Nullable;

public class UnquotedStringParseRule
implements Rule<StringReader, String> {
    private final int minSize;
    private final DelayedException<CommandSyntaxException> error;

    public UnquotedStringParseRule(int var0, DelayedException<CommandSyntaxException> var1) {
        this.minSize = var0;
        this.error = var1;
    }

    @Override
    public @Nullable String parse(ParseState<StringReader> var0) {
        var0.input().skipWhitespace();
        int var1 = var0.mark();
        String var2 = var0.input().readUnquotedString();
        if (var2.length() < this.minSize) {
            var0.errorCollector().store(var1, this.error);
            return null;
        }
        return var2;
    }

    @Override
    public /* synthetic */ @Nullable Object parse(ParseState parseState) {
        return this.parse(parseState);
    }
}

