/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.jfr.Configuration;
import jdk.jfr.Event;
import jdk.jfr.FlightRecorder;
import jdk.jfr.FlightRecorderListener;
import jdk.jfr.Recording;
import net.minecraft.SharedConstants;
import net.minecraft.core.Holder;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.FileUtils;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.SummaryReporter;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.util.profiling.jfr.event.ChunkGenerationEvent;
import net.minecraft.util.profiling.jfr.event.ChunkRegionReadEvent;
import net.minecraft.util.profiling.jfr.event.ChunkRegionWriteEvent;
import net.minecraft.util.profiling.jfr.event.ClientFpsEvent;
import net.minecraft.util.profiling.jfr.event.NetworkSummaryEvent;
import net.minecraft.util.profiling.jfr.event.PacketReceivedEvent;
import net.minecraft.util.profiling.jfr.event.PacketSentEvent;
import net.minecraft.util.profiling.jfr.event.ServerTickTimeEvent;
import net.minecraft.util.profiling.jfr.event.StructureGenerationEvent;
import net.minecraft.util.profiling.jfr.event.WorldLoadFinishedEvent;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.storage.RegionFileCompression;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class JfrProfiler
implements JvmProfiler {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String ROOT_CATEGORY = "Minecraft";
    public static final String WORLD_GEN_CATEGORY = "World Generation";
    public static final String TICK_CATEGORY = "Ticking";
    public static final String NETWORK_CATEGORY = "Network";
    public static final String STORAGE_CATEGORY = "Storage";
    private static final List<Class<? extends Event>> CUSTOM_EVENTS = List.of(ChunkGenerationEvent.class, ChunkRegionReadEvent.class, ChunkRegionWriteEvent.class, PacketReceivedEvent.class, PacketSentEvent.class, NetworkSummaryEvent.class, ServerTickTimeEvent.class, ClientFpsEvent.class, StructureGenerationEvent.class, WorldLoadFinishedEvent.class);
    private static final String FLIGHT_RECORDER_CONFIG = "/flightrecorder-config.jfc";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd-HHmmss").toFormatter(Locale.ROOT).withZone(ZoneId.systemDefault());
    private static final JfrProfiler INSTANCE = new JfrProfiler();
    @Nullable Recording recording;
    private int currentFPS;
    private float currentAverageTickTimeServer;
    private final Map<String, NetworkSummaryEvent.b> networkTrafficByAddress = new ConcurrentHashMap<String, NetworkSummaryEvent.b>();
    private final Runnable periodicClientFps = () -> new ClientFpsEvent(this.currentFPS).commit();
    private final Runnable periodicServerTickTime = () -> new ServerTickTimeEvent(this.currentAverageTickTimeServer).commit();
    private final Runnable periodicNetworkSummary = () -> {
        Iterator<NetworkSummaryEvent.b> var0 = this.networkTrafficByAddress.values().iterator();
        while (var0.hasNext()) {
            var0.next().commitEvent();
            var0.remove();
        }
    };

    private JfrProfiler() {
        CUSTOM_EVENTS.forEach(FlightRecorder::register);
        this.registerPeriodicEvents();
        FlightRecorder.addListener(new FlightRecorderListener(){

            @Override
            public void recordingStateChanged(Recording var0) {
                switch (var0.getState()) {
                    case STOPPED: {
                        JfrProfiler.this.registerPeriodicEvents();
                        break;
                    }
                }
            }
        });
    }

    void registerPeriodicEvents() {
        JfrProfiler.addPeriodicEvent(ClientFpsEvent.class, this.periodicClientFps);
        JfrProfiler.addPeriodicEvent(ServerTickTimeEvent.class, this.periodicServerTickTime);
        JfrProfiler.addPeriodicEvent(NetworkSummaryEvent.class, this.periodicNetworkSummary);
    }

    private static void addPeriodicEvent(Class<? extends Event> var0, Runnable var1) {
        FlightRecorder.removePeriodicEvent(var1);
        FlightRecorder.addPeriodicEvent(var0, var1);
    }

    public static JfrProfiler getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean start(Environment var0) {
        boolean bl;
        URL var1 = JfrProfiler.class.getResource(FLIGHT_RECORDER_CONFIG);
        if (var1 == null) {
            LOGGER.warn("Could not find default flight recorder config at {}", (Object)FLIGHT_RECORDER_CONFIG);
            return false;
        }
        BufferedReader var2 = new BufferedReader(new InputStreamReader(var1.openStream(), StandardCharsets.UTF_8));
        try {
            bl = this.start(var2, var0);
        }
        catch (Throwable throwable) {
            try {
                try {
                    var2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException var22) {
                LOGGER.warn("Failed to start flight recorder using configuration at {}", (Object)var1, (Object)var22);
                return false;
            }
        }
        var2.close();
        return bl;
    }

    @Override
    public Path stop() {
        if (this.recording == null) {
            throw new IllegalStateException("Not currently profiling");
        }
        this.networkTrafficByAddress.clear();
        Path var0 = this.recording.getDestination();
        this.recording.stop();
        return var0;
    }

    @Override
    public boolean isRunning() {
        return this.recording != null;
    }

    @Override
    public boolean isAvailable() {
        return FlightRecorder.isAvailable();
    }

    private boolean start(Reader var0, Environment var1) {
        if (this.isRunning()) {
            LOGGER.warn("Profiling already in progress");
            return false;
        }
        try {
            Configuration var22 = Configuration.create(var0);
            String var3 = DATE_TIME_FORMATTER.format(Instant.now());
            this.recording = SystemUtils.make(new Recording(var22), var2 -> {
                CUSTOM_EVENTS.forEach(var2::enable);
                var2.setDumpOnExit(true);
                var2.setToDisk(true);
                var2.setName(String.format(Locale.ROOT, "%s-%s-%s", var1.getDescription(), SharedConstants.getCurrentVersion().name(), var3));
            });
            Path var4 = Paths.get(String.format(Locale.ROOT, "debug/%s-%s.jfr", var1.getDescription(), var3), new String[0]);
            FileUtils.createDirectoriesSafe(var4.getParent());
            this.recording.setDestination(var4);
            this.recording.start();
            this.setupSummaryListener();
        }
        catch (IOException | ParseException var23) {
            LOGGER.warn("Failed to start jfr profiling", (Throwable)var23);
            return false;
        }
        LOGGER.info("Started flight recorder profiling id({}):name({}) - will dump to {} on exit or stop command", new Object[]{this.recording.getId(), this.recording.getName(), this.recording.getDestination()});
        return true;
    }

    private void setupSummaryListener() {
        FlightRecorder.addListener(new FlightRecorderListener(){
            final SummaryReporter summaryReporter = new SummaryReporter(() -> {
                JfrProfiler.this.recording = null;
            });

            @Override
            public void recordingStateChanged(Recording var0) {
                if (var0 != JfrProfiler.this.recording) {
                    return;
                }
                switch (var0.getState()) {
                    case STOPPED: {
                        this.summaryReporter.recordingStopped(var0.getDestination());
                        FlightRecorder.removeListener(this);
                        break;
                    }
                }
            }
        });
    }

    @Override
    public void onClientTick(int var0) {
        if (ClientFpsEvent.TYPE.isEnabled()) {
            this.currentFPS = var0;
        }
    }

    @Override
    public void onServerTick(float var0) {
        if (ServerTickTimeEvent.TYPE.isEnabled()) {
            this.currentAverageTickTimeServer = var0;
        }
    }

    @Override
    public void onPacketReceived(EnumProtocol var0, PacketType<?> var1, SocketAddress var2, int var3) {
        if (PacketReceivedEvent.TYPE.isEnabled()) {
            new PacketReceivedEvent(var0.id(), var1.flow().id(), var1.id().toString(), var2, var3).commit();
        }
        if (NetworkSummaryEvent.TYPE.isEnabled()) {
            this.networkStatFor(var2).trackReceivedPacket(var3);
        }
    }

    @Override
    public void onPacketSent(EnumProtocol var0, PacketType<?> var1, SocketAddress var2, int var3) {
        if (PacketSentEvent.TYPE.isEnabled()) {
            new PacketSentEvent(var0.id(), var1.flow().id(), var1.id().toString(), var2, var3).commit();
        }
        if (NetworkSummaryEvent.TYPE.isEnabled()) {
            this.networkStatFor(var2).trackSentPacket(var3);
        }
    }

    private NetworkSummaryEvent.b networkStatFor(SocketAddress var0) {
        return this.networkTrafficByAddress.computeIfAbsent(var0.toString(), NetworkSummaryEvent.b::new);
    }

    @Override
    public void onRegionFileRead(RegionStorageInfo var0, ChunkCoordIntPair var1, RegionFileCompression var2, int var3) {
        if (ChunkRegionReadEvent.TYPE.isEnabled()) {
            new ChunkRegionReadEvent(var0, var1, var2, var3).commit();
        }
    }

    @Override
    public void onRegionFileWrite(RegionStorageInfo var0, ChunkCoordIntPair var1, RegionFileCompression var2, int var3) {
        if (ChunkRegionWriteEvent.TYPE.isEnabled()) {
            new ChunkRegionWriteEvent(var0, var1, var2, var3).commit();
        }
    }

    @Override
    public @Nullable ProfiledDuration onWorldLoadedStarted() {
        if (!WorldLoadFinishedEvent.TYPE.isEnabled()) {
            return null;
        }
        WorldLoadFinishedEvent var0 = new WorldLoadFinishedEvent();
        var0.begin();
        return var1 -> var0.commit();
    }

    @Override
    public @Nullable ProfiledDuration onChunkGenerate(ChunkCoordIntPair var0, ResourceKey<World> var12, String var2) {
        if (!ChunkGenerationEvent.TYPE.isEnabled()) {
            return null;
        }
        ChunkGenerationEvent var3 = new ChunkGenerationEvent(var0, var12, var2);
        var3.begin();
        return var1 -> var3.commit();
    }

    @Override
    public @Nullable ProfiledDuration onStructureGenerate(ChunkCoordIntPair var0, ResourceKey<World> var12, Holder<Structure> var2) {
        if (!StructureGenerationEvent.TYPE.isEnabled()) {
            return null;
        }
        StructureGenerationEvent var3 = new StructureGenerationEvent(var0, var2, var12);
        var3.begin();
        return var1 -> {
            var0.success = var1;
            var3.commit();
        };
    }
}

