/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.event;

import jdk.jfr.Category;
import jdk.jfr.Enabled;
import jdk.jfr.Event;
import jdk.jfr.Label;
import jdk.jfr.Name;
import jdk.jfr.StackTrace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.RegionFileCompression;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;

@Category(value={"Minecraft", "Storage"})
@StackTrace(value=false)
@Enabled(value=false)
public abstract class ChunkRegionIoEvent
extends Event {
    @Name(value="regionPosX")
    @Label(value="Region X Position")
    public final int regionPosX;
    @Name(value="regionPosZ")
    @Label(value="Region Z Position")
    public final int regionPosZ;
    @Name(value="localPosX")
    @Label(value="Local X Position")
    public final int localChunkPosX;
    @Name(value="localPosZ")
    @Label(value="Local Z Position")
    public final int localChunkPosZ;
    @Name(value="chunkPosX")
    @Label(value="Chunk X Position")
    public final int chunkPosX;
    @Name(value="chunkPosZ")
    @Label(value="Chunk Z Position")
    public final int chunkPosZ;
    @Name(value="level")
    @Label(value="Level Id")
    public final String levelId;
    @Name(value="dimension")
    @Label(value="Dimension")
    public final String dimension;
    @Name(value="type")
    @Label(value="Type")
    public final String type;
    @Name(value="compression")
    @Label(value="Compression")
    public final String compression;
    @Name(value="bytes")
    @Label(value="Bytes")
    public final int bytes;

    public ChunkRegionIoEvent(RegionStorageInfo var0, ChunkCoordIntPair var1, RegionFileCompression var2, int var3) {
        this.regionPosX = var1.getRegionX();
        this.regionPosZ = var1.getRegionZ();
        this.localChunkPosX = var1.getRegionLocalX();
        this.localChunkPosZ = var1.getRegionLocalZ();
        this.chunkPosX = var1.x;
        this.chunkPosZ = var1.z;
        this.levelId = var0.level();
        this.dimension = var0.dimension().identifier().toString();
        this.type = var0.type();
        this.compression = "standard:" + var2.getId();
        this.bytes = var3;
    }

    public static class a {
        public static final String REGION_POS_X = "regionPosX";
        public static final String REGION_POS_Z = "regionPosZ";
        public static final String LOCAL_POS_X = "localPosX";
        public static final String LOCAL_POS_Z = "localPosZ";
        public static final String CHUNK_POS_X = "chunkPosX";
        public static final String CHUNK_POS_Z = "chunkPosZ";
        public static final String LEVEL = "level";
        public static final String DIMENSION = "dimension";
        public static final String TYPE = "type";
        public static final String COMPRESSION = "compression";
        public static final String BYTES = "bytes";

        private a() {
        }
    }
}

