/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.stats;

import com.google.common.base.MoreObjects;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedThread;

public record ThreadAllocationStat(Instant timestamp, String threadName, long totalBytes) {
    private static final String UNKNOWN_THREAD = "unknown";

    public static ThreadAllocationStat from(RecordedEvent var0) {
        RecordedThread var1 = var0.getThread("thread");
        String var2 = var1 == null ? UNKNOWN_THREAD : (String)MoreObjects.firstNonNull((Object)var1.getJavaName(), (Object)UNKNOWN_THREAD);
        return new ThreadAllocationStat(var0.getStartTime(), var2, var0.getLong("allocated"));
    }

    public static a summary(List<ThreadAllocationStat> var02) {
        TreeMap<String, Double> var12 = new TreeMap<String, Double>();
        Map<String, List<ThreadAllocationStat>> var22 = var02.stream().collect(Collectors.groupingBy(var0 -> var0.threadName));
        var22.forEach((var1, var2) -> {
            if (var2.size() < 2) {
                return;
            }
            ThreadAllocationStat var3 = (ThreadAllocationStat)var2.get(0);
            ThreadAllocationStat var4 = (ThreadAllocationStat)var2.get(var2.size() - 1);
            long var5 = Duration.between(var3.timestamp, var4.timestamp).getSeconds();
            long var7 = var4.totalBytes - var3.totalBytes;
            var12.put((String)var1, (double)var7 / (double)var5);
        });
        return new a(var12);
    }

    public record a(Map<String, Double> allocationsPerSecondByThread) {
    }
}

