/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.stats;

import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.profiling.jfr.Percentiles;
import net.minecraft.util.profiling.jfr.stats.TimedStat;
import org.jspecify.annotations.Nullable;

public record TimedStatSummary<T extends TimedStat>(T fastest, T slowest, @Nullable T secondSlowest, int count, Map<Integer, Double> percentilesNanos, Duration totalDuration) {
    public static <T extends TimedStat> Optional<TimedStatSummary<T>> summary(List<T> var02) {
        if (var02.isEmpty()) {
            return Optional.empty();
        }
        List<TimedStat> var1 = var02.stream().sorted(Comparator.comparing(TimedStat::duration)).toList();
        Duration var2 = var1.stream().map(TimedStat::duration).reduce(Duration::plus).orElse(Duration.ZERO);
        TimedStat var3 = var1.getFirst();
        TimedStat var4 = var1.getLast();
        TimedStat var5 = var1.size() > 1 ? var1.get(var1.size() - 2) : null;
        int var6 = var1.size();
        Map<Integer, Double> var7 = Percentiles.evaluate(var1.stream().mapToLong(var0 -> var0.duration().toNanos()).toArray());
        return Optional.of(new TimedStatSummary<TimedStat>(var3, var4, var5, var6, var7, var2));
    }
}

