/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.FloatProviderType;

public class TrapezoidFloat
extends FloatProvider {
    public static final MapCodec<TrapezoidFloat> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.FLOAT.fieldOf("min").forGetter(var0 -> Float.valueOf(var0.min)), (App)Codec.FLOAT.fieldOf("max").forGetter(var0 -> Float.valueOf(var0.max)), (App)Codec.FLOAT.fieldOf("plateau").forGetter(var0 -> Float.valueOf(var0.plateau))).apply((Applicative)var02, TrapezoidFloat::new)).validate(var0 -> {
        if (var0.max < var0.min) {
            return DataResult.error(() -> "Max must be larger than min: [" + var0.min + ", " + var0.max + "]");
        }
        if (var0.plateau > var0.max - var0.min) {
            return DataResult.error(() -> "Plateau can at most be the full span: [" + var0.min + ", " + var0.max + "]");
        }
        return DataResult.success((Object)var0);
    });
    private final float min;
    private final float max;
    private final float plateau;

    public static TrapezoidFloat of(float var0, float var1, float var2) {
        return new TrapezoidFloat(var0, var1, var2);
    }

    private TrapezoidFloat(float var0, float var1, float var2) {
        this.min = var0;
        this.max = var1;
        this.plateau = var2;
    }

    @Override
    public float sample(RandomSource var0) {
        float var1 = this.max - this.min;
        float var2 = (var1 - this.plateau) / 2.0f;
        float var3 = var1 - var2;
        return this.min + var0.nextFloat() * var3 + var0.nextFloat() * var2;
    }

    @Override
    public float getMinValue() {
        return this.min;
    }

    @Override
    public float getMaxValue() {
        return this.max;
    }

    @Override
    public FloatProviderType<?> getType() {
        return FloatProviderType.TRAPEZOID;
    }

    public String toString() {
        return "trapezoid(" + this.plateau + ") in [" + this.min + "-" + this.max + "]";
    }
}

