/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public interface RandomizableContainer
extends IInventory {
    public static final String LOOT_TABLE_TAG = "LootTable";
    public static final String LOOT_TABLE_SEED_TAG = "LootTableSeed";

    public @Nullable ResourceKey<LootTable> getLootTable();

    public void setLootTable(@Nullable ResourceKey<LootTable> var1);

    default public void setLootTable(ResourceKey<LootTable> var0, long var1) {
        this.setLootTable(var0);
        this.setLootTableSeed(var1);
    }

    public long getLootTableSeed();

    public void setLootTableSeed(long var1);

    public BlockPosition getBlockPos();

    public @Nullable World getLevel();

    public static void setBlockEntityLootTable(IBlockAccess var0, RandomSource var1, BlockPosition var2, ResourceKey<LootTable> var3) {
        TileEntity var4 = var0.getBlockEntity(var2);
        if (var4 instanceof RandomizableContainer) {
            RandomizableContainer var5 = (RandomizableContainer)((Object)var4);
            var5.setLootTable(var3, var1.nextLong());
        }
    }

    default public boolean tryLoadLootTable(ValueInput var0) {
        ResourceKey var1 = var0.read(LOOT_TABLE_TAG, LootTable.KEY_CODEC).orElse(null);
        this.setLootTable(var1);
        this.setLootTableSeed(var0.getLongOr(LOOT_TABLE_SEED_TAG, 0L));
        return var1 != null;
    }

    default public boolean trySaveLootTable(ValueOutput var0) {
        ResourceKey<LootTable> var1 = this.getLootTable();
        if (var1 == null) {
            return false;
        }
        var0.store(LOOT_TABLE_TAG, LootTable.KEY_CODEC, var1);
        long var2 = this.getLootTableSeed();
        if (var2 != 0L) {
            var0.putLong(LOOT_TABLE_SEED_TAG, var2);
        }
        return true;
    }

    default public void unpackLootTable(@Nullable EntityHuman var0) {
        World var1 = this.getLevel();
        BlockPosition var2 = this.getBlockPos();
        ResourceKey<LootTable> var3 = this.getLootTable();
        if (var3 != null && var1 != null && var1.getServer() != null) {
            LootTable var4 = var1.getServer().reloadableRegistries().getLootTable(var3);
            if (var0 instanceof EntityPlayer) {
                CriterionTriggers.GENERATE_LOOT.trigger((EntityPlayer)var0, var3);
            }
            this.setLootTable(null);
            LootParams.a var5 = new LootParams.a((WorldServer)var1).withParameter(LootContextParameters.ORIGIN, Vec3D.atCenterOf(var2));
            if (var0 != null) {
                var5.withLuck(var0.getLuck()).withParameter(LootContextParameters.THIS_ENTITY, var0);
            }
            var4.fill(this, var5.create(LootContextParameterSets.CHEST), this.getLootTableSeed());
        }
    }
}

