/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.UnaryOperator;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.Stopwatch;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.SavedDataType;
import org.jspecify.annotations.Nullable;

public class Stopwatches
extends PersistentBase {
    private static final Codec<Stopwatches> CODEC = Codec.unboundedMap(MinecraftKey.CODEC, (Codec)Codec.LONG).fieldOf("stopwatches").codec().xmap(Stopwatches::unpack, Stopwatches::pack);
    public static final SavedDataType<Stopwatches> TYPE = new SavedDataType<Stopwatches>("stopwatches", Stopwatches::new, CODEC, DataFixTypes.SAVED_DATA_STOPWATCHES);
    private final Map<MinecraftKey, Stopwatch> stopwatches = new Object2ObjectOpenHashMap();

    private Stopwatches() {
    }

    private static Stopwatches unpack(Map<MinecraftKey, Long> var0) {
        Stopwatches var1 = new Stopwatches();
        long var2 = Stopwatches.currentTime();
        var0.forEach((var3, var4) -> var0.stopwatches.put((MinecraftKey)var3, new Stopwatch(var2, (long)var4)));
        return var1;
    }

    private Map<MinecraftKey, Long> pack() {
        long var0 = Stopwatches.currentTime();
        TreeMap<MinecraftKey, Long> var2 = new TreeMap<MinecraftKey, Long>();
        this.stopwatches.forEach((var3, var4) -> var2.put((MinecraftKey)var3, var4.elapsedMilliseconds(var0)));
        return var2;
    }

    public @Nullable Stopwatch get(MinecraftKey var0) {
        return this.stopwatches.get(var0);
    }

    public boolean add(MinecraftKey var0, Stopwatch var1) {
        if (this.stopwatches.putIfAbsent(var0, var1) == null) {
            this.setDirty();
            return true;
        }
        return false;
    }

    public boolean update(MinecraftKey var0, UnaryOperator<Stopwatch> var12) {
        if (this.stopwatches.computeIfPresent(var0, (var1, var2) -> (Stopwatch)var12.apply((Stopwatch)var2)) != null) {
            this.setDirty();
            return true;
        }
        return false;
    }

    public boolean remove(MinecraftKey var0) {
        boolean var1;
        boolean bl = var1 = this.stopwatches.remove(var0) != null;
        if (var1) {
            this.setDirty();
        }
        return var1;
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || !this.stopwatches.isEmpty();
    }

    public List<MinecraftKey> ids() {
        return List.copyOf(this.stopwatches.keySet());
    }

    public static long currentTime() {
        return SystemUtils.getMillis();
    }
}

