/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute;

import com.google.common.collect.ImmutableBiMap;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.attribute.LerpFunction;
import net.minecraft.world.attribute.modifier.AttributeModifier;

public record AttributeType<Value>(Codec<Value> valueCodec, Map<AttributeModifier.a, AttributeModifier<Value, ?>> modifierLibrary, Codec<AttributeModifier<Value, ?>> modifierCodec, LerpFunction<Value> keyframeLerp, LerpFunction<Value> stateChangeLerp, LerpFunction<Value> spatialLerp, LerpFunction<Value> partialTickLerp) {
    public static <Value> AttributeType<Value> ofInterpolated(Codec<Value> var0, Map<AttributeModifier.a, AttributeModifier<Value, ?>> var1, LerpFunction<Value> var2) {
        return AttributeType.ofInterpolated(var0, var1, var2, var2);
    }

    public static <Value> AttributeType<Value> ofInterpolated(Codec<Value> var0, Map<AttributeModifier.a, AttributeModifier<Value, ?>> var1, LerpFunction<Value> var2, LerpFunction<Value> var3) {
        return new AttributeType<Value>(var0, var1, AttributeType.createModifierCodec(var1), var2, var2, var2, var3);
    }

    public static <Value> AttributeType<Value> ofNotInterpolated(Codec<Value> var0, Map<AttributeModifier.a, AttributeModifier<Value, ?>> var1) {
        return new AttributeType<Value>(var0, var1, AttributeType.createModifierCodec(var1), LerpFunction.ofStep(1.0f), LerpFunction.ofStep(0.0f), LerpFunction.ofStep(0.5f), LerpFunction.ofStep(0.0f));
    }

    public static <Value> AttributeType<Value> ofNotInterpolated(Codec<Value> var0) {
        return AttributeType.ofNotInterpolated(var0, Map.of());
    }

    private static <Value> Codec<AttributeModifier<Value, ?>> createModifierCodec(Map<AttributeModifier.a, AttributeModifier<Value, ?>> var0) {
        ImmutableBiMap var1 = ImmutableBiMap.builder().put((Object)AttributeModifier.a.OVERRIDE, AttributeModifier.override()).putAll(var0).buildOrThrow();
        return ExtraCodecs.idResolverCodec(AttributeModifier.a.CODEC, arg_0 -> ((ImmutableBiMap)var1).get(arg_0), arg_0 -> ((ImmutableBiMap)var1.inverse()).get(arg_0));
    }

    public void checkAllowedModifier(AttributeModifier<Value, ?> var0) {
        if (var0 != AttributeModifier.override() && !this.modifierLibrary.containsValue(var0)) {
            throw new IllegalArgumentException("Modifier " + String.valueOf(var0) + " is not valid for " + String.valueOf(this));
        }
    }

    @Override
    public String toString() {
        return SystemUtils.getRegisteredName(BuiltInRegistries.ATTRIBUTE_TYPE, this);
    }
}

