/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute;

import it.unimi.dsi.fastutil.objects.Reference2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMaps;
import java.util.Objects;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributeMap;
import net.minecraft.world.attribute.LerpFunction;

public class SpatialAttributeInterpolator {
    private final Reference2DoubleArrayMap<EnvironmentAttributeMap> weightsBySource = new Reference2DoubleArrayMap();

    public void clear() {
        this.weightsBySource.clear();
    }

    public SpatialAttributeInterpolator accumulate(double var0, EnvironmentAttributeMap var2) {
        this.weightsBySource.mergeDouble((Object)var2, var0, Double::sum);
        return this;
    }

    public <Value> Value applyAttributeLayer(EnvironmentAttribute<Value> var0, Value var1) {
        if (this.weightsBySource.isEmpty()) {
            return var1;
        }
        if (this.weightsBySource.size() == 1) {
            EnvironmentAttributeMap var2 = (EnvironmentAttributeMap)this.weightsBySource.keySet().iterator().next();
            return var2.applyModifier(var0, var1);
        }
        LerpFunction<Value> var2 = var0.type().spatialLerp();
        Object var3 = null;
        double var4 = 0.0;
        for (Reference2DoubleMap.Entry var7 : Reference2DoubleMaps.fastIterable(this.weightsBySource)) {
            EnvironmentAttributeMap var8 = (EnvironmentAttributeMap)var7.getKey();
            double var9 = var7.getDoubleValue();
            Value var11 = var8.applyModifier(var0, var1);
            var4 += var9;
            if (var3 == null) {
                var3 = var11;
                continue;
            }
            float var12 = (float)(var9 / var4);
            var3 = var2.apply(var12, var3, var11);
        }
        return Objects.requireNonNull(var3);
    }
}

