/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.CommonLinks;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DeathMessageType;
import net.minecraft.world.damagesource.FallLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public class CombatTracker {
    public static final int RESET_DAMAGE_STATUS_TIME = 100;
    public static final int RESET_COMBAT_STATUS_TIME = 300;
    private static final ChatModifier INTENTIONAL_GAME_DESIGN_STYLE = ChatModifier.EMPTY.withClickEvent(new ChatClickable.OpenUrl(CommonLinks.INTENTIONAL_GAME_DESIGN_BUG)).withHoverEvent(new ChatHoverable.e(IChatBaseComponent.literal("MCPE-28723")));
    private final List<CombatEntry> entries = Lists.newArrayList();
    private final EntityLiving mob;
    private int lastDamageTime;
    private int combatStartTime;
    private int combatEndTime;
    private boolean inCombat;
    private boolean takingDamage;

    public CombatTracker(EntityLiving var0) {
        this.mob = var0;
    }

    public void recordDamage(DamageSource var0, float var1) {
        this.recheckStatus();
        FallLocation var2 = FallLocation.getCurrentFallLocation(this.mob);
        CombatEntry var3 = new CombatEntry(var0, var1, var2, (float)this.mob.fallDistance);
        this.entries.add(var3);
        this.lastDamageTime = this.mob.tickCount;
        this.takingDamage = true;
        if (!this.inCombat && this.mob.isAlive() && CombatTracker.shouldEnterCombat(var0)) {
            this.inCombat = true;
            this.combatEndTime = this.combatStartTime = this.mob.tickCount;
            this.mob.onEnterCombat();
        }
    }

    private static boolean shouldEnterCombat(DamageSource var0) {
        return var0.getEntity() instanceof EntityLiving;
    }

    private IChatBaseComponent getMessageForAssistedFall(Entity var0, IChatBaseComponent var1, String var2, String var3) {
        ItemStack var4;
        if (var0 instanceof EntityLiving) {
            EntityLiving var5 = (EntityLiving)var0;
            v0 = var5.getMainHandItem();
        } else {
            v0 = var4 = ItemStack.EMPTY;
        }
        if (!var4.isEmpty() && var4.has(DataComponents.CUSTOM_NAME)) {
            return IChatBaseComponent.translatable(var2, this.mob.getDisplayName(), var1, var4.getDisplayName());
        }
        return IChatBaseComponent.translatable(var3, this.mob.getDisplayName(), var1);
    }

    private IChatBaseComponent getFallMessage(CombatEntry var0, @Nullable Entity var1) {
        DamageSource var2 = var0.source();
        if (var2.is(DamageTypeTags.IS_FALL) || var2.is(DamageTypeTags.ALWAYS_MOST_SIGNIFICANT_FALL)) {
            FallLocation var3 = Objects.requireNonNullElse(var0.fallLocation(), FallLocation.GENERIC);
            return IChatBaseComponent.translatable(var3.languageKey(), this.mob.getDisplayName());
        }
        IChatBaseComponent var3 = CombatTracker.getDisplayName(var1);
        Entity var4 = var2.getEntity();
        IChatBaseComponent var5 = CombatTracker.getDisplayName(var4);
        if (var5 != null && !var5.equals(var3)) {
            return this.getMessageForAssistedFall(var4, var5, "death.fell.assist.item", "death.fell.assist");
        }
        if (var3 != null) {
            return this.getMessageForAssistedFall(var1, var3, "death.fell.finish.item", "death.fell.finish");
        }
        return IChatBaseComponent.translatable("death.fell.killer", this.mob.getDisplayName());
    }

    private static @Nullable IChatBaseComponent getDisplayName(@Nullable Entity var0) {
        return var0 == null ? null : var0.getDisplayName();
    }

    public IChatBaseComponent getDeathMessage() {
        if (this.entries.isEmpty()) {
            return IChatBaseComponent.translatable("death.attack.generic", this.mob.getDisplayName());
        }
        CombatEntry var0 = this.entries.get(this.entries.size() - 1);
        DamageSource var1 = var0.source();
        CombatEntry var2 = this.getMostSignificantFall();
        DeathMessageType var3 = var1.type().deathMessageType();
        if (var3 == DeathMessageType.FALL_VARIANTS && var2 != null) {
            return this.getFallMessage(var2, var1.getEntity());
        }
        if (var3 == DeathMessageType.INTENTIONAL_GAME_DESIGN) {
            String var4 = "death.attack." + var1.getMsgId();
            IChatMutableComponent var5 = ChatComponentUtils.wrapInSquareBrackets(IChatBaseComponent.translatable(var4 + ".link")).withStyle(INTENTIONAL_GAME_DESIGN_STYLE);
            return IChatBaseComponent.translatable(var4 + ".message", this.mob.getDisplayName(), var5);
        }
        return var1.getLocalizedDeathMessage(this.mob);
    }

    private @Nullable CombatEntry getMostSignificantFall() {
        CombatEntry var0 = null;
        CombatEntry var1 = null;
        float var2 = 0.0f;
        float var3 = 0.0f;
        for (int var4 = 0; var4 < this.entries.size(); ++var4) {
            float var9;
            CombatEntry var5 = this.entries.get(var4);
            CombatEntry var6 = var4 > 0 ? this.entries.get(var4 - 1) : null;
            DamageSource var7 = var5.source();
            boolean var8 = var7.is(DamageTypeTags.ALWAYS_MOST_SIGNIFICANT_FALL);
            float f2 = var9 = var8 ? Float.MAX_VALUE : var5.fallDistance();
            if ((var7.is(DamageTypeTags.IS_FALL) || var8) && var9 > 0.0f && (var0 == null || var9 > var3)) {
                var0 = var4 > 0 ? var6 : var5;
                var3 = var9;
            }
            if (var5.fallLocation() == null || var1 != null && !(var5.damage() > var2)) continue;
            var1 = var5;
            var2 = var5.damage();
        }
        if (var3 > 5.0f && var0 != null) {
            return var0;
        }
        if (var2 > 5.0f && var1 != null) {
            return var1;
        }
        return null;
    }

    public int getCombatDuration() {
        if (this.inCombat) {
            return this.mob.tickCount - this.combatStartTime;
        }
        return this.combatEndTime - this.combatStartTime;
    }

    public void recheckStatus() {
        int var0;
        int n2 = var0 = this.inCombat ? 300 : 100;
        if (this.takingDamage && (!this.mob.isAlive() || this.mob.tickCount - this.lastDamageTime > var0)) {
            boolean var1 = this.inCombat;
            this.takingDamage = false;
            this.inCombat = false;
            this.combatEndTime = this.mob.tickCount;
            if (var1) {
                this.mob.onLeaveCombat();
            }
            this.entries.clear();
        }
    }
}

