/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.Optional;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.scores.ScoreboardTeam;
import org.jspecify.annotations.Nullable;

public abstract class EntityTameableAnimal
extends EntityAnimal
implements OwnableEntity {
    public static final int TELEPORT_WHEN_DISTANCE_IS_SQ = 144;
    private static final int MIN_HORIZONTAL_DISTANCE_FROM_TARGET_AFTER_TELEPORTING = 2;
    private static final int MAX_HORIZONTAL_DISTANCE_FROM_TARGET_AFTER_TELEPORTING = 3;
    private static final int MAX_VERTICAL_DISTANCE_FROM_TARGET_AFTER_TELEPORTING = 1;
    private static final boolean DEFAULT_ORDERED_TO_SIT = false;
    protected static final DataWatcherObject<Byte> DATA_FLAGS_ID = DataWatcher.defineId(EntityTameableAnimal.class, DataWatcherRegistry.BYTE);
    protected static final DataWatcherObject<Optional<EntityReference<EntityLiving>>> DATA_OWNERUUID_ID = DataWatcher.defineId(EntityTameableAnimal.class, DataWatcherRegistry.OPTIONAL_LIVING_ENTITY_REFERENCE);
    private boolean orderedToSit = false;

    protected EntityTameableAnimal(EntityTypes<? extends EntityTameableAnimal> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_FLAGS_ID, (byte)0);
        var0.define(DATA_OWNERUUID_ID, Optional.empty());
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        EntityReference<EntityLiving> var1 = this.getOwnerReference();
        EntityReference.store(var1, var0, "Owner");
        var0.putBoolean("Sitting", this.orderedToSit);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        EntityReference var1 = EntityReference.readWithOldOwnerConversion(var0, "Owner", this.level());
        if (var1 != null) {
            try {
                this.entityData.set(DATA_OWNERUUID_ID, Optional.of(var1));
                this.setTame(true, false);
            }
            catch (Throwable var2) {
                this.setTame(false, true);
            }
        } else {
            this.entityData.set(DATA_OWNERUUID_ID, Optional.empty());
            this.setTame(false, true);
        }
        this.orderedToSit = var0.getBooleanOr("Sitting", false);
        this.setInSittingPose(this.orderedToSit);
    }

    @Override
    public boolean canBeLeashed() {
        return true;
    }

    protected void spawnTamingParticles(boolean var0) {
        ParticleType var1 = Particles.HEART;
        if (!var0) {
            var1 = Particles.SMOKE;
        }
        for (int var2 = 0; var2 < 7; ++var2) {
            double var3 = this.random.nextGaussian() * 0.02;
            double var5 = this.random.nextGaussian() * 0.02;
            double var7 = this.random.nextGaussian() * 0.02;
            this.level().addParticle(var1, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), var3, var5, var7);
        }
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 7) {
            this.spawnTamingParticles(true);
        } else if (var0 == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.handleEntityEvent(var0);
        }
    }

    public boolean isTame() {
        return (this.entityData.get(DATA_FLAGS_ID) & 4) != 0;
    }

    public void setTame(boolean var0, boolean var1) {
        byte var2 = this.entityData.get(DATA_FLAGS_ID);
        if (var0) {
            this.entityData.set(DATA_FLAGS_ID, (byte)(var2 | 4));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (byte)(var2 & 0xFFFFFFFB));
        }
        if (var1) {
            this.applyTamingSideEffects();
        }
    }

    protected void applyTamingSideEffects() {
    }

    public boolean isInSittingPose() {
        return (this.entityData.get(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setInSittingPose(boolean var0) {
        byte var1 = this.entityData.get(DATA_FLAGS_ID);
        if (var0) {
            this.entityData.set(DATA_FLAGS_ID, (byte)(var1 | 1));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (byte)(var1 & 0xFFFFFFFE));
        }
    }

    @Override
    public @Nullable EntityReference<EntityLiving> getOwnerReference() {
        return this.entityData.get(DATA_OWNERUUID_ID).orElse(null);
    }

    public void setOwner(@Nullable EntityLiving var0) {
        this.entityData.set(DATA_OWNERUUID_ID, Optional.ofNullable(var0).map(EntityReference::of));
    }

    public void setOwnerReference(@Nullable EntityReference<EntityLiving> var0) {
        this.entityData.set(DATA_OWNERUUID_ID, Optional.ofNullable(var0));
    }

    public void tame(EntityHuman var0) {
        this.setTame(true, true);
        this.setOwner(var0);
        if (var0 instanceof EntityPlayer) {
            EntityPlayer var1 = (EntityPlayer)var0;
            CriterionTriggers.TAME_ANIMAL.trigger(var1, this);
        }
    }

    @Override
    public boolean canAttack(EntityLiving var0) {
        if (this.isOwnedBy(var0)) {
            return false;
        }
        return super.canAttack(var0);
    }

    public boolean isOwnedBy(EntityLiving var0) {
        return var0 == this.getOwner();
    }

    public boolean wantsToAttack(EntityLiving var0, EntityLiving var1) {
        return true;
    }

    @Override
    public @Nullable ScoreboardTeam getTeam() {
        EntityLiving var1;
        ScoreboardTeam var0 = super.getTeam();
        if (var0 != null) {
            return var0;
        }
        if (this.isTame() && (var1 = this.getRootOwner()) != null) {
            return var1.getTeam();
        }
        return null;
    }

    @Override
    protected boolean considersEntityAsAlly(Entity var0) {
        if (this.isTame()) {
            EntityLiving var1 = this.getRootOwner();
            if (var0 == var1) {
                return true;
            }
            if (var1 != null) {
                return var1.considersEntityAsAlly(var0);
            }
        }
        return super.considersEntityAsAlly(var0);
    }

    @Override
    public void die(DamageSource var0) {
        EntityLiving entityLiving;
        WorldServer var1;
        World world = this.level();
        if (world instanceof WorldServer && (var1 = (WorldServer)world).getGameRules().get(GameRules.SHOW_DEATH_MESSAGES).booleanValue() && (entityLiving = this.getOwner()) instanceof EntityPlayer) {
            EntityPlayer var2 = (EntityPlayer)entityLiving;
            var2.sendSystemMessage(this.getCombatTracker().getDeathMessage());
        }
        super.die(var0);
    }

    public boolean isOrderedToSit() {
        return this.orderedToSit;
    }

    public void setOrderedToSit(boolean var0) {
        this.orderedToSit = var0;
    }

    public void tryToTeleportToOwner() {
        EntityLiving var0 = this.getOwner();
        if (var0 != null) {
            this.teleportToAroundBlockPos(var0.blockPosition());
        }
    }

    public boolean shouldTryTeleportToOwner() {
        EntityLiving var0 = this.getOwner();
        return var0 != null && this.distanceToSqr(this.getOwner()) >= 144.0;
    }

    private void teleportToAroundBlockPos(BlockPosition var0) {
        for (int var1 = 0; var1 < 10; ++var1) {
            int var2 = this.random.nextIntBetweenInclusive(-3, 3);
            int var3 = this.random.nextIntBetweenInclusive(-3, 3);
            if (Math.abs(var2) < 2 && Math.abs(var3) < 2) continue;
            int var4 = this.random.nextIntBetweenInclusive(-1, 1);
            if (!this.maybeTeleportTo(var0.getX() + var2, var0.getY() + var4, var0.getZ() + var3)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int var0, int var1, int var2) {
        if (!this.canTeleportTo(new BlockPosition(var0, var1, var2))) {
            return false;
        }
        this.snapTo((double)var0 + 0.5, var1, (double)var2 + 0.5, this.getYRot(), this.getXRot());
        this.navigation.stop();
        return true;
    }

    private boolean canTeleportTo(BlockPosition var0) {
        PathType var1 = PathfinderNormal.getPathTypeStatic(this, var0);
        if (var1 != PathType.WALKABLE) {
            return false;
        }
        IBlockData var2 = this.level().getBlockState(var0.below());
        if (!this.canFlyToOwner() && var2.getBlock() instanceof BlockLeaves) {
            return false;
        }
        BlockPosition var3 = var0.subtract(this.blockPosition());
        return this.level().noCollision(this, this.getBoundingBox().move(var3));
    }

    public final boolean unableToMoveToOwner() {
        return this.isOrderedToSit() || this.isPassenger() || this.mayBeLeashed() || this.getOwner() != null && this.getOwner().isSpectator();
    }

    protected boolean canFlyToOwner() {
        return false;
    }

    public class a
    extends PathfinderGoalPanic {
        public a(double var1, TagKey var3) {
            super((EntityCreature)EntityTameableAnimal.this, var1, var3);
        }

        public a(double var1) {
            super(EntityTameableAnimal.this, var1);
        }

        @Override
        public void tick() {
            if (!EntityTameableAnimal.this.unableToMoveToOwner() && EntityTameableAnimal.this.shouldTryTeleportToOwner()) {
                EntityTameableAnimal.this.tryToTeleportToOwner();
            }
            super.tick();
        }
    }
}

