/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.core.BlockPosition;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathMode;
import org.jspecify.annotations.Nullable;

public interface SpawnPlacementTypes {
    public static final SpawnPlacementType NO_RESTRICTIONS = (var0, var1, var2) -> true;
    public static final SpawnPlacementType IN_WATER = (var0, var1, var2) -> {
        if (var2 == null || !var0.getWorldBorder().isWithinBounds(var1)) {
            return false;
        }
        BlockPosition var3 = var1.above();
        return var0.getFluidState(var1).is(TagsFluid.WATER) && !var0.getBlockState(var3).isRedstoneConductor(var0, var3);
    };
    public static final SpawnPlacementType IN_LAVA = (var0, var1, var2) -> {
        if (var2 == null || !var0.getWorldBorder().isWithinBounds(var1)) {
            return false;
        }
        return var0.getFluidState(var1).is(TagsFluid.LAVA);
    };
    public static final SpawnPlacementType ON_GROUND = new SpawnPlacementType(){

        @Override
        public boolean isSpawnPositionOk(IWorldReader var0, BlockPosition var1, @Nullable EntityTypes<?> var2) {
            if (var2 == null || !var0.getWorldBorder().isWithinBounds(var1)) {
                return false;
            }
            BlockPosition var3 = var1.above();
            BlockPosition var4 = var1.below();
            IBlockData var5 = var0.getBlockState(var4);
            if (!var5.isValidSpawn(var0, var4, var2)) {
                return false;
            }
            return this.isValidEmptySpawnBlock(var0, var1, var2) && this.isValidEmptySpawnBlock(var0, var3, var2);
        }

        private boolean isValidEmptySpawnBlock(IWorldReader var0, BlockPosition var1, EntityTypes<?> var2) {
            IBlockData var3 = var0.getBlockState(var1);
            return SpawnerCreature.isValidEmptySpawnBlock(var0, var1, var3, var3.getFluidState(), var2);
        }

        @Override
        public BlockPosition adjustSpawnPosition(IWorldReader var0, BlockPosition var1) {
            BlockPosition var2 = var1.below();
            if (var0.getBlockState(var2).isPathfindable(PathMode.LAND)) {
                return var2;
            }
            return var1;
        }
    };
}

