/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class AnimalPanic<E extends EntityCreature>
extends Behavior<E> {
    private static final int PANIC_MIN_DURATION = 100;
    private static final int PANIC_MAX_DURATION = 120;
    private static final int PANIC_DISTANCE_HORIZONTAL = 5;
    private static final int PANIC_DISTANCE_VERTICAL = 4;
    private final float speedMultiplier;
    private final Function<EntityCreature, TagKey<DamageType>> panicCausingDamageTypes;
    private final Function<E, Vec3D> positionGetter;

    public AnimalPanic(float var02) {
        this(var02, var0 -> DamageTypeTags.PANIC_CAUSES, var0 -> LandRandomPos.getPos(var0, 5, 4));
    }

    public AnimalPanic(float var02, int var12) {
        this(var02, var0 -> DamageTypeTags.PANIC_CAUSES, var1 -> AirAndWaterRandomPos.getPos(var1, 5, 4, var12, var1.getViewVector((float)0.0f).x, var1.getViewVector((float)0.0f).z, 1.5707963705062866));
    }

    public AnimalPanic(float var02, Function<EntityCreature, TagKey<DamageType>> var1) {
        this(var02, var1, var0 -> LandRandomPos.getPos(var0, 5, 4));
    }

    public AnimalPanic(float var0, Function<EntityCreature, TagKey<DamageType>> var1, Function<E, Vec3D> var2) {
        super(Map.of(MemoryModuleType.IS_PANICKING, MemoryStatus.REGISTERED, MemoryModuleType.HURT_BY, MemoryStatus.REGISTERED), 100, 120);
        this.speedMultiplier = var0;
        this.panicCausingDamageTypes = var1;
        this.positionGetter = var2;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, E var12) {
        return ((EntityLiving)var12).getBrain().getMemory(MemoryModuleType.HURT_BY).map(var1 -> var1.is(this.panicCausingDamageTypes.apply((EntityCreature)var12))).orElse(false) != false || ((EntityLiving)var12).getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, E var1, long var2) {
        return true;
    }

    @Override
    protected void start(WorldServer var0, E var1, long var2) {
        ((EntityLiving)var1).getBrain().setMemory(MemoryModuleType.IS_PANICKING, true);
        ((EntityLiving)var1).getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        ((EntityInsentient)var1).getNavigation().stop();
    }

    @Override
    protected void stop(WorldServer var0, E var1, long var2) {
        BehaviorController<?> var4 = ((EntityLiving)var1).getBrain();
        var4.eraseMemory(MemoryModuleType.IS_PANICKING);
    }

    @Override
    protected void tick(WorldServer var0, E var1, long var2) {
        Vec3D var4;
        if (((EntityInsentient)var1).getNavigation().isDone() && (var4 = this.getPanicPos(var1, var0)) != null) {
            ((EntityLiving)var1).getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(var4, this.speedMultiplier, 0));
        }
    }

    private @Nullable Vec3D getPanicPos(E var0, WorldServer var1) {
        Optional<Vec3D> var2;
        if (((Entity)var0).isOnFire() && (var2 = this.lookForWater(var1, (Entity)var0).map(Vec3D::atBottomCenterOf)).isPresent()) {
            return var2.get();
        }
        return this.positionGetter.apply(var0);
    }

    private Optional<BlockPosition> lookForWater(IBlockAccess var0, Entity var13) {
        BlockPosition var2 = var13.blockPosition();
        if (!var0.getBlockState(var2).getCollisionShape(var0, var2).isEmpty()) {
            return Optional.empty();
        }
        Predicate<BlockPosition> var3 = MathHelper.ceil(var13.getBbWidth()) == 2 ? var12 -> BlockPosition.squareOutSouthEast(var12).allMatch(var1 -> var0.getFluidState((BlockPosition)var1).is(TagsFluid.WATER)) : var1 -> var0.getFluidState((BlockPosition)var1).is(TagsFluid.WATER);
        return BlockPosition.findClosestMatch(var2, 5, 1, var3);
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (E)((EntityCreature)entityLiving), l2);
    }

    @Override
    protected /* synthetic */ void tick(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.tick(worldServer, (E)((EntityCreature)entityLiving), l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (E)((EntityCreature)entityLiving), l2);
    }
}

